/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.jetty.core.internal.config;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.server.core.internal.ProgressUtil;
import org.eclipse.jst.server.jetty.core.internal.JettyConstants;
import org.eclipse.jst.server.jetty.core.internal.config.PathFileConfig;
import org.eclipse.jst.server.jetty.core.internal.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartIni
implements JettyConstants {
    private List<PathFileConfig> _jettyXMLFiles = new ArrayList<PathFileConfig>();
    private List<PathFileConfig> _otherConfigs = new ArrayList<PathFileConfig>();
    private PathFileConfig _startConfig = null;
    private PathFileConfig _webdefaultXMLConfig = null;
    private File _adminPortFile = null;
    private File _startIniFile;
    private boolean _isStartIniDirty;

    public StartIni(IPath baseDirPath) {
        this.loadStartIni(baseDirPath, null);
        this.loadOtherConfigs(baseDirPath);
        this.loadAdminPortFile(baseDirPath, null);
    }

    public StartIni(IFolder baseDirFolder) {
        this.loadStartIni(null, baseDirFolder);
        this.loadAdminPortFile(null, baseDirFolder);
    }

    private List<String> loadStartIni(IPath baseDirPath, IFolder baseDirFolder) {
        ArrayList<String> args;
        block17: {
            args = new ArrayList<String>();
            if (baseDirPath != null) {
                IPath startIniPath = baseDirPath.append("start.ini");
                this._startIniFile = startIniPath.toFile();
            } else {
                try {
                    this._startIniFile = IOUtils.toLocalFile(baseDirFolder.getFile("start.ini"), null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (this._startIniFile.exists() && this._startIniFile.canRead()) {
                FileReader reader = null;
                BufferedReader buf = null;
                try {
                    try {
                        String arg;
                        reader = new FileReader(this._startIniFile);
                        buf = new BufferedReader(reader);
                        File jettyXMLFile = null;
                        while ((arg = buf.readLine()) != null) {
                            if ((arg = arg.trim()).length() == 0 || arg.startsWith("#")) continue;
                            if (arg.indexOf(61) == -1) {
                                if (baseDirPath != null) {
                                    jettyXMLFile = baseDirPath.append(arg).toFile();
                                } else {
                                    try {
                                        jettyXMLFile = IOUtils.toLocalFile(baseDirFolder.getFile(arg), null);
                                    }
                                    catch (CoreException e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (jettyXMLFile != null && jettyXMLFile.exists() && jettyXMLFile.canRead()) {
                                    this._jettyXMLFiles.add(new PathFileConfig(jettyXMLFile, (IPath)new Path(arg)));
                                }
                            }
                            args.add(arg);
                        }
                    }
                    catch (IOException iOException) {
                        this.close(buf);
                        this.close(reader);
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    this.close(buf);
                    this.close(reader);
                    throw throwable;
                }
                this.close(buf);
                this.close(reader);
            }
        }
        return args;
    }

    private void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private void loadOtherConfigs(IPath baseDirPath) {
        IPath startJARPath;
        File startConfigFile;
        IPath webdefaultPath;
        File webdefaultFile;
        IPath realmPropertiesPath = baseDirPath.append("etc/realm.properties");
        File realmPropertiesFile = realmPropertiesPath.toFile();
        if (realmPropertiesFile.exists()) {
            this._otherConfigs.add(new PathFileConfig(realmPropertiesFile, (IPath)new Path("etc/realm.properties")));
        }
        if ((webdefaultFile = (webdefaultPath = baseDirPath.append("etc/webdefault.xml")).toFile()).exists()) {
            this._webdefaultXMLConfig = new PathFileConfig(webdefaultFile, (IPath)new Path("etc/webdefault.xml"));
        }
        if ((startConfigFile = (startJARPath = baseDirPath.append("start.jar")).toFile()).exists()) {
            this._startConfig = new PathFileConfig(startConfigFile, (IPath)new Path("start.jar"));
        }
    }

    private void loadAdminPortFile(IPath baseDirPath, IFolder baseDirFolder) {
        if (baseDirPath != null) {
            IPath adminPortPath = baseDirPath.append("adminPort");
            this._adminPortFile = adminPortPath.toFile();
        } else {
            try {
                this._adminPortFile = IOUtils.toLocalFile(baseDirFolder.getFile("adminPort"), null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public List<PathFileConfig> getJettyXMLFiles() {
        return this._jettyXMLFiles;
    }

    public PathFileConfig getWebdefaultXMLConfig() {
        return this._webdefaultXMLConfig;
    }

    public File getAdminPortFile() {
        return this._adminPortFile;
    }

    public void save(IFile file, IProgressMonitor monitor) throws Exception {
        block15: {
            if (file.exists() && !this._isStartIniDirty) {
                return;
            }
            if (this._startIniFile == null || !this._startIniFile.exists() || !this._startIniFile.canRead()) {
                return;
            }
            InputStream in = null;
            try {
                try {
                    in = new FileInputStream(this._startIniFile);
                    if (file.exists()) {
                        file.setContents(in, true, true, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)200));
                    } else {
                        file.create(in, true, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)200));
                    }
                }
                catch (Exception exception) {
                    try {
                        in.close();
                    }
                    catch (Exception exception2) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        this._isStartIniDirty = false;
    }

    public List<PathFileConfig> getOtherConfigs() {
        return this._otherConfigs;
    }

    public PathFileConfig getStartConfig() {
        return this._startConfig;
    }
}

