/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.jetty.core.internal.jetty7;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.internal.ProgressUtil;
import org.eclipse.jst.server.jetty.core.WebModule;
import org.eclipse.jst.server.jetty.core.internal.IJettyWebModule;
import org.eclipse.jst.server.jetty.core.internal.JettyConfiguration;
import org.eclipse.jst.server.jetty.core.internal.JettyConstants;
import org.eclipse.jst.server.jetty.core.internal.Messages;
import org.eclipse.jst.server.jetty.core.internal.Trace;
import org.eclipse.jst.server.jetty.core.internal.config.JettyXMLConfig;
import org.eclipse.jst.server.jetty.core.internal.config.PathFileConfig;
import org.eclipse.jst.server.jetty.core.internal.config.StartConfig;
import org.eclipse.jst.server.jetty.core.internal.config.StartIni;
import org.eclipse.jst.server.jetty.core.internal.config.WebdefaultXMLConfig;
import org.eclipse.jst.server.jetty.core.internal.util.IOUtils;
import org.eclipse.jst.server.jetty.core.internal.xml.Factory;
import org.eclipse.jst.server.jetty.core.internal.xml.jetty7.ServerInstance;
import org.eclipse.jst.server.jetty.core.internal.xml.jetty7.server.Connector;
import org.eclipse.jst.server.jetty.core.internal.xml.jetty7.server.Server;
import org.eclipse.jst.server.jetty.core.internal.xml.jetty7.server.WebApp;
import org.eclipse.jst.server.jetty.core.internal.xml.jetty7.webapp.WebAppContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.ServerPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jetty7Configuration
extends JettyConfiguration
implements JettyConstants {
    private StartIni _startIniConfig;
    protected ServerInstance _serverInstance;
    private boolean _isServerDirty;
    private transient List<PropertyChangeListener> _propertyListeners;

    public Jetty7Configuration(IFolder path) {
        super(path);
    }

    @Override
    public Collection<ServerPort> getServerPorts() {
        ArrayList<ServerPort> ports;
        block12: {
            ports = new ArrayList<ServerPort>();
            try {
                int port = Integer.parseInt(this._serverInstance.getAdminPort());
                ports.add(new ServerPort("server", Messages.portServer, port, "TCPIP"));
            }
            catch (Exception exception) {}
            try {
                List<Connector> connectors = this._serverInstance.getConnectors();
                if (connectors == null) break block12;
                int portId = 0;
                for (Connector connector : connectors) {
                    int port = -1;
                    try {
                        port = Integer.parseInt(connector.getPort());
                    }
                    catch (Exception exception) {}
                    String id = Integer.toString(portId++);
                    String type = connector.getType();
                    String name = "HTTP";
                    String className = type.substring(type.lastIndexOf(46) + 1);
                    if ("SelectChannelConnector".equals(className) || "SocketConnector".equals(className)) {
                        name = "HTTP";
                    } else if ("SslSelectChannelConnector".equals(className) || "SslSocketConnector".equals(className)) {
                        name = "SSL";
                    } else if ("Ajp13SocketConnector".equals(className)) {
                        name = "AJP";
                    }
                    ports.add(new ServerPort(id, name, port, name));
                }
            }
            catch (Exception e) {
                Trace.trace((byte)3, "Error getting server ports", e);
            }
        }
        return ports;
    }

    @Override
    public ServerPort getAdminPort() {
        Collection<ServerPort> serverPorts = this.getServerPorts();
        for (ServerPort serverPort : serverPorts) {
            if (!serverPort.getId().equals("server")) continue;
            return serverPort;
        }
        return null;
    }

    @Override
    public List<WebModule> getWebModules() {
        ArrayList<WebModule> list = new ArrayList<WebModule>();
        try {
            Collection<WebAppContext> contexts = this._serverInstance.getContexts();
            if (contexts != null) {
                for (WebAppContext context : contexts) {
                    String documentBase = context.getDocumentBase();
                    String path = context.getContextPath();
                    String memento = context.getMemento();
                    WebModule module = new WebModule(path, documentBase, memento, true);
                    list.add(module);
                }
            }
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error getting project refs", e);
        }
        return list;
    }

    @Override
    public void addWebModule(int i, IJettyWebModule module) {
        try {
            WebAppContext context = this._serverInstance.createContext(module.getDocumentBase(), module.getMemento(), module.getPath());
            if (context != null) {
                this._isServerDirty = true;
                this.firePropertyChangeEvent("addWebModule", null, module);
            }
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error adding web module " + module.getPath(), e);
        }
    }

    @Override
    public void removeWebModule(int index) {
        try {
            this._serverInstance.removeContext(index);
            this._isServerDirty = true;
            this.firePropertyChangeEvent("removeWebModule", null, index);
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error removing module ref " + index, e);
        }
    }

    protected void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (this._propertyListeners == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        try {
            Iterator<PropertyChangeListener> iterator = this._propertyListeners.iterator();
            while (iterator.hasNext()) {
                try {
                    PropertyChangeListener listener = iterator.next();
                    listener.propertyChange(event);
                }
                catch (Exception e) {
                    Trace.trace((byte)3, "Error firing property change event", e);
                }
            }
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error in property event", e);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertyListeners == null) {
            this._propertyListeners = new ArrayList<PropertyChangeListener>();
        }
        this._propertyListeners.add(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertyListeners != null) {
            this._propertyListeners.remove(listener);
        }
    }

    @Override
    public void load(IPath path, IPath runtimeBaseDirectory, IProgressMonitor monitor) throws CoreException {
        try {
            monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
            monitor.beginTask(Messages.loadingTask, 5);
            Factory serverFactory = null;
            this._startIniConfig = new StartIni(path);
            List<PathFileConfig> jettyXMLConfiFiles = this._startIniConfig.getJettyXMLFiles();
            ArrayList<Server> servers = new ArrayList<Server>();
            Server server = null;
            File file = null;
            IPath jettyPath = null;
            if (jettyXMLConfiFiles.size() > 0) {
                for (PathFileConfig jettyXMLConfig : jettyXMLConfiFiles) {
                    file = jettyXMLConfig.getFile();
                    jettyPath = jettyXMLConfig.getPath();
                    serverFactory = new Factory();
                    serverFactory.setPackageName("org.eclipse.jst.server.jetty.core.internal.xml.jetty7.server");
                    server = (Server)serverFactory.loadDocument(JettyXMLConfig.getInputStream(file));
                    server.setFile(file);
                    server.setPath(jettyPath);
                    servers.add(server);
                }
            }
            WebApp webApp = null;
            PathFileConfig pathFileConfig = this._startIniConfig.getWebdefaultXMLConfig();
            if (pathFileConfig != null) {
                File webAppFile = pathFileConfig.getFile();
                IPath webAppPath = pathFileConfig.getPath();
                Factory webdefaultFactory = new Factory();
                webdefaultFactory.setPackageName("org.eclipse.jst.server.jetty.core.internal.xml.jetty7.server");
                webApp = (WebApp)webdefaultFactory.loadDocument(WebdefaultXMLConfig.getInputStream(webAppFile));
                webApp.setFile(webAppFile);
                webApp.setPath(webAppPath);
            }
            File adminPortFile = this._startIniConfig.getAdminPortFile();
            String adminPort = null;
            if (adminPortFile != null && adminPortFile.exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(adminPortFile));
                adminPort = reader.readLine();
                reader.close();
            }
            monitor.worked(1);
            this._serverInstance = new ServerInstance(servers, webApp, runtimeBaseDirectory);
            if (adminPort != null) {
                this._serverInstance.setAdminPort(adminPort);
            }
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Could not load Jetty v7.x configuration from " + path.toOSString() + ": " + e.getMessage());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.jetty.core", 0, NLS.bind((String)Messages.errorCouldNotLoadConfiguration, (Object)path.toOSString()), (Throwable)e));
        }
    }

    @Override
    public void load(IFolder folder, IPath runtimeBaseDirectory, IProgressMonitor monitor) throws CoreException {
        try {
            monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
            monitor.beginTask(Messages.loadingTask, 800);
            Factory serverFactory = null;
            this._startIniConfig = new StartIni(folder);
            List<PathFileConfig> jettyXMLConfiFiles = this._startIniConfig.getJettyXMLFiles();
            ArrayList<Server> servers = new ArrayList<Server>();
            Server server = null;
            File file = null;
            IPath jettyPath = null;
            if (jettyXMLConfiFiles.size() > 0) {
                for (PathFileConfig jettyXMLConfig : jettyXMLConfiFiles) {
                    file = jettyXMLConfig.getFile();
                    jettyPath = jettyXMLConfig.getPath();
                    serverFactory = new Factory();
                    serverFactory.setPackageName("org.eclipse.jst.server.jetty.core.internal.xml.jetty7.server");
                    server = (Server)serverFactory.loadDocument(new FileInputStream(file));
                    server.setFile(file);
                    server.setPath(jettyPath);
                    servers.add(server);
                }
            }
            monitor.worked(1);
            WebApp webApp = null;
            PathFileConfig pathFileConfig = this._startIniConfig.getWebdefaultXMLConfig();
            if (pathFileConfig != null) {
                File webAppFile = pathFileConfig.getFile();
                IPath webAppPath = pathFileConfig.getPath();
                Factory webdefaultFactory = new Factory();
                webdefaultFactory.setPackageName("org.eclipse.jst.server.jetty.core.internal.xml.jetty7.server");
                webApp = (WebApp)webdefaultFactory.loadDocument(new FileInputStream(webAppFile));
                webApp.setFile(webAppFile);
                webApp.setPath(webAppPath);
            }
            File adminPortFile = this._startIniConfig.getAdminPortFile();
            String adminPort = null;
            if (adminPortFile != null && adminPortFile.exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(adminPortFile));
                adminPort = reader.readLine();
                reader.close();
            }
            this._serverInstance = new ServerInstance(servers, webApp, runtimeBaseDirectory);
            if (adminPort != null) {
                this._serverInstance.setAdminPort(adminPort);
            }
            monitor.worked(200);
            if (monitor.isCanceled()) {
                throw new Exception("Cancelled");
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Could not reload Jetty v7.x configuration from: " + folder.getFullPath() + ": " + e.getMessage());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.jetty.core", 0, NLS.bind((String)Messages.errorCouldNotLoadConfiguration, (Object)folder.getFullPath().toOSString()), (Throwable)e));
        }
    }

    @Override
    public void save(IFolder folder, IProgressMonitor monitor) throws CoreException {
        try {
            monitor = ProgressUtil.getMonitorFor((IProgressMonitor)monitor);
            monitor.beginTask(Messages.savingTask, 1200);
            if (monitor.isCanceled()) {
                return;
            }
            this._startIniConfig.save(folder.getFile("start.ini"), monitor);
            this._serverInstance.save(folder, monitor);
            FileInputStream in = null;
            IFolder newFolder = folder;
            IPath path = null;
            String filename = null;
            List<PathFileConfig> otherConfigs = this._startIniConfig.getOtherConfigs();
            for (PathFileConfig pathFileConfig : otherConfigs) {
                path = pathFileConfig.getPath();
                if (path.segmentCount() > 1) {
                    newFolder = folder.getFolder(path.removeLastSegments(1));
                    IOUtils.createFolder(newFolder, monitor);
                }
                filename = pathFileConfig.getFile().getName();
                in = new FileInputStream(pathFileConfig.getFile());
                IFile file = newFolder.getFile(filename);
                if (file.exists()) {
                    file.setContents((InputStream)in, true, true, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)200));
                    continue;
                }
                file.create((InputStream)in, true, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)200));
            }
            PathFileConfig startConfig = this._startIniConfig.getStartConfig();
            if (startConfig != null) {
                File startJARFile = startConfig.getFile();
                InputStream stream = StartConfig.getInputStream(startJARFile);
                IFile file = folder.getFile("start.config");
                if (file.exists()) {
                    file.setContents(stream, true, true, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)200));
                } else {
                    file.create(stream, true, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)200));
                }
            }
            monitor.done();
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Could not save Jetty v7.x configuration to " + folder.toString(), e);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.jetty.core", 0, NLS.bind((String)Messages.errorCouldNotSaveConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e));
        }
    }

    @Override
    public void importFromPath(IPath path, IPath runtimeBaseDirectory, boolean isTestEnv, IProgressMonitor monitor) throws CoreException {
        this.load(path, runtimeBaseDirectory, monitor);
        if (isTestEnv) {
            while (this._serverInstance.removeContext(0)) {
            }
        }
    }

    @Override
    public void modifyServerPort(String id, int port) {
        try {
            if ("server".equals(id)) {
                this._serverInstance.setAdminPort(String.valueOf(port));
                this._isServerDirty = true;
                this.firePropertyChangeEvent("modifyPort", id, port);
                return;
            }
            int connNum = Integer.parseInt(id);
            List<Connector> connectors = this._serverInstance.getConnectors();
            Connector connector = connectors.get(connNum);
            connector.setPort(String.valueOf(port));
            this._isServerDirty = true;
            this.firePropertyChangeEvent("modifyPort", id, new Integer(port));
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error modifying server port " + id, e);
        }
    }

    @Override
    public void modifyWebModule(int index, String docBase, String path, boolean reloadable) {
        try {
            WebAppContext context = this._serverInstance.getContext(index);
            if (context != null) {
                context.setContextPath(path);
                context.save();
                this._isServerDirty = true;
                WebModule module = new WebModule(path, docBase, null, reloadable);
                this.firePropertyChangeEvent("modifyWebModule", index, module);
            }
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error modifying web module " + index, e);
        }
    }
}

