/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.jetty.core.internal.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class IOUtils {
    private static final int __DEFAULT_BUFFER_SIZE = 4096;

    public static File toLocalFile(URI uri, IProgressMonitor monitor) throws CoreException {
        IFileStore fileStore = EFS.getStore((URI)uri);
        File localFile = fileStore.toLocalFile(0, monitor);
        if (localFile == null) {
            localFile = fileStore.toLocalFile(4096, monitor);
        }
        return localFile;
    }

    public static File toLocalFile(IFile file, IProgressMonitor monitor) throws CoreException {
        return IOUtils.toLocalFile(file.getLocationURI(), monitor);
    }

    public static void createFolder(IFolder folderHandle, IProgressMonitor monitor) throws CoreException {
        if (folderHandle.exists()) {
            return;
        }
        IPath path = folderHandle.getFullPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int numSegments = path.segmentCount();
        if (numSegments > 2 && !root.getFolder(path.removeLastSegments(1)).exists()) {
            int i = numSegments - 2;
            while (i > 0) {
                IFolder folder = root.getFolder(path.removeLastSegments(i));
                if (!folder.exists()) {
                    folder.create(false, true, monitor);
                }
                --i;
            }
        }
        folderHandle.create(false, true, monitor);
    }

    public static InputStream getInputStream(File jarFile, String fileName) throws ZipException, IOException {
        ZipFile zipFile = new ZipFile(jarFile);
        ZipEntry zipEntry = zipFile.getEntry(fileName);
        return zipFile.getInputStream(zipEntry);
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static InputStream toInputStream(String input, String encoding) throws IOException {
        byte[] bytes = encoding == null ? input.getBytes() : input.getBytes(encoding);
        return new ByteArrayInputStream(bytes);
    }
}

