/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.jetty.core.internal.util;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.jetty.core.internal.JettyConstants;
import org.eclipse.jst.server.jetty.core.internal.JettyServer;
import org.eclipse.jst.server.jetty.core.internal.JettyServerBehaviour;
import org.eclipse.jst.server.jetty.core.internal.Trace;

public class JettyVersionHelper
implements JettyConstants {
    public static IStatus checkJettyVersion(IPath installPath) {
        IPath startJarPath = installPath.append("start.jar");
        File jarFile = null;
        jarFile = startJarPath.toFile();
        if (!jarFile.exists()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public static IPath getStandardBaseDirectory(JettyServer ts) {
        if (ts.isTestEnvironment()) {
            String baseDir = ts.getInstanceDirectory();
            if (baseDir == null) {
                JettyServerBehaviour tsb = (JettyServerBehaviour)ts.getServer().loadAdapter(JettyServerBehaviour.class, null);
                if (tsb == null) {
                    return null;
                }
                return tsb.getTempDirectory();
            }
            Path path = new Path(baseDir);
            if (!path.isAbsolute()) {
                IPath rootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                path = rootPath.append((IPath)path);
            }
            return path;
        }
        return ts.getServer().getRuntime().getLocation();
    }

    public static String[] getJettyVMArguments(IPath installPath, IPath instancePath, IPath deployPath, String endorsedDirs, int mainPort, int adminPort, boolean isTestEnv) {
        ArrayList<String> list = new ArrayList<String>();
        if (isTestEnv) {
            list.add("-Djetty.home=\"" + instancePath.toOSString() + "\"");
            list.add("-DSTART=\"" + instancePath.toOSString() + "/start.config\"");
            list.add("-Dinstall.jetty.home=\"" + installPath.toOSString() + "\"");
        } else {
            list.add("-Djetty.home=\"" + installPath.toOSString() + "\"");
        }
        list.add("-DVERBOSE");
        list.add("-Djetty.port=" + Integer.toString(mainPort));
        list.add("-DSTOP.PORT=" + Integer.toString(adminPort));
        list.add("-DSTOP.KEY=secret");
        String[] s = new String[list.size()];
        list.toArray(s);
        return s;
    }

    public static String[] getJettyProgramArguments(IPath configPath, boolean debug, boolean starting) {
        ArrayList<String> list = new ArrayList<String>();
        if (!starting) {
            list.add("--stop");
        }
        String[] temp = new String[list.size()];
        list.toArray(temp);
        return temp;
    }

    public static IStatus createJettyInstanceDirectory(IPath baseDir) {
        File temp;
        if (Trace.isTraceEnabled()) {
            Trace.trace((byte)0, "Creating runtime directory at " + baseDir.toOSString());
        }
        if (!(temp = baseDir.append("contexts").toFile()).exists()) {
            temp.mkdirs();
        }
        if (!(temp = baseDir.append("etc").toFile()).exists()) {
            temp.mkdirs();
        }
        if (!(temp = baseDir.append("resources").toFile()).exists()) {
            temp.mkdirs();
        }
        if (!(temp = baseDir.append("webapps").toFile()).exists()) {
            temp.mkdirs();
        }
        return Status.OK_STATUS;
    }
}

