/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.jetty.core.internal.xml.jetty7;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.server.core.internal.ProgressUtil;
import org.eclipse.jst.server.jetty.core.internal.util.IOUtils;
import org.eclipse.jst.server.jetty.core.internal.xml.Factory;
import org.eclipse.jst.server.jetty.core.internal.xml.jetty7.server.Connector;
import org.eclipse.jst.server.jetty.core.internal.xml.jetty7.server.Server;
import org.eclipse.jst.server.jetty.core.internal.xml.jetty7.server.WebApp;
import org.eclipse.jst.server.jetty.core.internal.xml.jetty7.webapp.WebAppContext;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerInstance {
    private List<Server> _jettyServers;
    private IPath _runtimeBaseDirectory;
    private boolean _contextsLoaded = false;
    private List<WebAppContext> _webAppContexts = new ArrayList<WebAppContext>();
    private WebApp _webApp = null;
    private String _adminPort = "8082";

    public ServerInstance(List<Server> jettyServers, WebApp webApp, IPath runtimeBaseDirectory) {
        if (jettyServers == null) {
            throw new IllegalArgumentException("Jetty Server argument may not be null.");
        }
        this._jettyServers = jettyServers;
        this._runtimeBaseDirectory = runtimeBaseDirectory;
        this._webApp = webApp;
    }

    public List<Connector> getConnectors() {
        ArrayList<Connector> allConnectors = null;
        List<Connector> serverConnectors = null;
        for (Server server : this._jettyServers) {
            serverConnectors = server.getConnectors();
            if (serverConnectors == null) continue;
            if (allConnectors == null) {
                allConnectors = new ArrayList<Connector>();
            }
            allConnectors.addAll(serverConnectors);
        }
        return allConnectors;
    }

    public boolean removeContext(int index) {
        IPath contextFilePath;
        File contextFile;
        if (index >= this._webAppContexts.size()) {
            return false;
        }
        WebAppContext webAppContext = this._webAppContexts.remove(index);
        if (webAppContext != null && (contextFile = (contextFilePath = this.getXMLContextFilePath(webAppContext.getContextPath())).toFile()).exists()) {
            contextFile.delete();
        }
        return webAppContext != null;
    }

    public List<Server> getJettyServers() {
        return this._jettyServers;
    }

    public void save(IFolder folder, IProgressMonitor monitor) throws IOException, CoreException {
        IPath path = null;
        String filename = null;
        byte[] data = null;
        ByteArrayInputStream in = null;
        IFolder newFolder = folder;
        for (Server jettyServer : this._jettyServers) {
            path = jettyServer.getPath();
            if (path.segmentCount() > 1) {
                newFolder = folder.getFolder(path.removeLastSegments(1));
                IOUtils.createFolder(newFolder, monitor);
            }
            filename = jettyServer.getFile().getName();
            data = jettyServer.getFactory().getContents();
            in = new ByteArrayInputStream(data);
            IFile file = newFolder.getFile(filename);
            if (file.exists()) {
                file.setContents((InputStream)in, true, true, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)200));
                continue;
            }
            file.create((InputStream)in, true, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)200));
        }
        IFile adminPortFile = folder.getFile("adminPort");
        in = new ByteArrayInputStream(this._adminPort.getBytes());
        if (adminPortFile.exists()) {
            adminPortFile.setContents((InputStream)in, true, true, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)200));
        } else {
            adminPortFile.create((InputStream)in, true, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)200));
        }
        if (this._webApp != null) {
            path = this._webApp.getPath();
            if (path.segmentCount() > 1) {
                newFolder = folder.getFolder(path.removeLastSegments(1));
                IOUtils.createFolder(newFolder, monitor);
            }
            filename = this._webApp.getFile().getName();
            data = this._webApp.getFactory().getContents();
            in = new ByteArrayInputStream(data);
            IFile file = newFolder.getFile(filename);
            if (file.exists()) {
                file.setContents((InputStream)in, true, true, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)200));
            } else {
                file.create((InputStream)in, true, ProgressUtil.getSubMonitorFor((IProgressMonitor)monitor, (int)200));
            }
        }
    }

    public WebAppContext createContext(String documentBase, String memento, String path) throws IOException, SAXException {
        this.loadContextsIfNeeded();
        String pathWithoutSlash = path;
        if (pathWithoutSlash.startsWith("/")) {
            pathWithoutSlash = pathWithoutSlash.substring(1, pathWithoutSlash.length());
        }
        WebAppContext context = this.createContext(WebAppContext.class.getResourceAsStream("WebAppContext.xml"));
        context.setContextPath(pathWithoutSlash);
        File f = new File(documentBase);
        if (f.exists()) {
            context.setWar(documentBase, true);
        } else {
            context.setWar("/wtpwebapps/" + pathWithoutSlash, false);
        }
        IPath contextFilePath = this.getXMLContextFilePath(pathWithoutSlash);
        context.setSaveFile(contextFilePath.toFile());
        context.save();
        return context;
    }

    private IPath getXMLContextFilePath(String path) {
        String pathWithoutSlash = path;
        if (pathWithoutSlash.startsWith("/")) {
            pathWithoutSlash = pathWithoutSlash.substring(1, pathWithoutSlash.length());
        }
        String fileName = String.valueOf(pathWithoutSlash) + ".xml";
        IPath contextFolderPath = this._runtimeBaseDirectory.append("contexts");
        File folder = contextFolderPath.toFile();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return contextFolderPath.append(fileName);
    }

    private WebAppContext createContext(InputStream stream) throws IOException, SAXException {
        Factory webAppContextFactory = new Factory();
        webAppContextFactory.setPackageName("org.eclipse.jst.server.jetty.core.internal.xml.jetty7.webapp");
        WebAppContext context = (WebAppContext)webAppContextFactory.loadDocument(stream);
        this._webAppContexts.add(context);
        return context;
    }

    private void loadContextsIfNeeded() {
        block18: {
            if (this._contextsLoaded) {
                return;
            }
            try {
                WebAppContext context = null;
                IPath contexts = this._runtimeBaseDirectory.append("contexts");
                File contextsFolder = contexts.toFile();
                if (!contextsFolder.exists()) break block18;
                FileInputStream stream = null;
                File f = null;
                File[] files = contextsFolder.listFiles();
                int i = 0;
                while (i < files.length) {
                    block20: {
                        f = files[i];
                        try {
                            try {
                                stream = new FileInputStream(f);
                                context = this.createContext(stream);
                                context.setSaveFile(f);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                if (stream != null) {
                                    try {
                                        ((InputStream)stream).close();
                                    }
                                    catch (IOException e2) {
                                        e2.printStackTrace();
                                    }
                                }
                                break block20;
                            }
                        }
                        catch (Throwable throwable) {
                            if (stream != null) {
                                try {
                                    ((InputStream)stream).close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            throw throwable;
                        }
                        if (stream != null) {
                            try {
                                ((InputStream)stream).close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    ++i;
                }
            }
            finally {
                this._contextsLoaded = true;
            }
        }
    }

    public Collection<WebAppContext> getContexts() {
        this.loadContextsIfNeeded();
        return this._webAppContexts;
    }

    public WebAppContext getContext(int index) {
        return this._webAppContexts.get(index);
    }

    public void setAdminPort(String port) {
        this._adminPort = port;
    }

    public String getAdminPort() {
        return this._adminPort;
    }
}

