/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.jetty.core.internal.xml.jetty7.webapp;

import java.io.File;
import java.io.IOException;
import org.eclipse.jst.server.jetty.core.internal.xml.XMLElement;
import org.eclipse.jst.server.jetty.core.internal.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebAppContext
extends XMLElement {
    private File _saveFile;
    private String _memento;
    private String _documentBase;

    public void setContextPath(String contextPath) {
        Element element = super.findElement("Set", "contextPath");
        if (contextPath.startsWith("/")) {
            element.setTextContent(contextPath);
        } else {
            element.setTextContent("/" + contextPath);
        }
    }

    public void setWar(String war, boolean isExternal) {
        Element element = super.findElement("Set", "war");
        element.setTextContent(war);
        if (!isExternal) {
            Document document = element.getOwnerDocument();
            Element systemProperty = document.createElement("SystemProperty");
            systemProperty.setAttribute("name", "jetty.home");
            systemProperty.setAttribute("default", ".");
            Node firstChild = element.getFirstChild();
            element.insertBefore(systemProperty, firstChild);
        }
    }

    public String getContextPath() {
        Element element = super.findElement("Set", "contextPath");
        return element.getTextContent();
    }

    public String getWar() {
        Element element = super.findElement("Set", "war");
        return element.getTextContent();
    }

    public void save() throws IOException {
        XMLUtil.save(this._saveFile.getCanonicalPath(), this.getElementNode().getOwnerDocument());
    }

    public void setSaveFile(File saveFile) {
        this._saveFile = saveFile;
        String war = this.getWar();
        File warFile = new File(war);
        if (war != null && warFile.exists()) {
            try {
                this._documentBase = warFile.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this._documentBase = saveFile.getName();
            int index = this._documentBase.lastIndexOf(46);
            if (index != -1) {
                this._documentBase = this._documentBase.substring(0, index);
            }
            this._memento = "org.eclipse.jst.jee.server:" + this._documentBase;
        }
    }

    public String getMemento() {
        return this._memento;
    }

    public String getDocumentBase() {
        return this._documentBase;
    }
}

