/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit.api.gen;

import java.util.List;
import org.eclipse.jubula.toolkit.api.gen.internal.genmodel.CommonGenInfo;
import org.eclipse.jubula.toolkit.api.gen.internal.genmodel.CompInfoForFactoryGen;
import org.eclipse.jubula.toolkit.api.gen.internal.genmodel.FactoryGenInfo;
import org.eclipse.jubula.toolkit.api.gen.internal.utils.GenerateUtil;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ComponentClass;

public class FactoryGenerator {
    protected static String nl;
    public final String NL = nl == null ? System.getProperties().getProperty("line.separator") : nl;
    protected final String TEXT_1 = "/*******************************************************************************" + this.NL + " * Copyright (c) 2014 BREDEX GmbH." + this.NL + " * All rights reserved. This program and the accompanying materials" + this.NL + " * are made available under the terms of the Eclipse Public License v1.0" + this.NL + " * which accompanies this distribution, and is available at" + this.NL + " * http://www.eclipse.org/legal/epl-v10.html" + this.NL + " *" + this.NL + " * Contributors:" + this.NL + " *     BREDEX GmbH - initial API and implementation and/or initial documentation" + this.NL + " *******************************************************************************/" + this.NL + "package ";
    protected final String TEXT_2 = ";" + this.NL + this.NL + "import javax.annotation.Generated;" + this.NL + this.NL + "import org.apache.commons.lang.Validate;" + this.NL + "import org.eclipse.jdt.annotation.NonNull;" + this.NL + "import org.eclipse.jubula.tools.ComponentIdentifier;" + this.NL + "import org.eclipse.jubula.toolkit.ToolkitInfo;" + this.NL;
    protected final String TEXT_3 = "import ";
    protected final String TEXT_4 = ";";
    protected final String TEXT_5 = String.valueOf(this.NL) + this.NL + "/**" + this.NL + " * Factory for creating components from the ";
    protected final String TEXT_6 = " toolkit." + this.NL + " * @noextend This class is not intended to be extended by clients." + this.NL + " */" + this.NL + "@Generated(value = \"";
    protected final String TEXT_7 = "\", " + this.NL + "           date =  \"";
    protected final String TEXT_8 = "\")" + this.NL + "public final class ";
    protected final String TEXT_9 = " {" + this.NL + "    ";
    protected final String TEXT_10 = String.valueOf(this.NL) + "    @NonNull private final static ToolkitInfo m_toolkitInformation = new ";
    protected final String TEXT_11 = "();";
    protected final String TEXT_12 = String.valueOf(this.NL) + this.NL + "    private ";
    protected final String TEXT_13 = "() {" + this.NL + "        super();" + this.NL + "    }" + this.NL + "    ";
    protected final String TEXT_14 = String.valueOf(this.NL) + "    @NonNull public static ToolkitInfo getToolkitInformation() {" + this.NL + "        return m_toolkitInformation;" + this.NL + "    }";
    protected final String TEXT_15 = this.NL;
    protected final String TEXT_16 = String.valueOf(this.NL) + "    /** create a new representative for a {@link ";
    protected final String TEXT_17 = "} component.*/" + this.NL + "    @NonNull public static ";
    protected final String TEXT_18 = " create";
    protected final String TEXT_19 = " () {" + this.NL + "        return new ";
    protected final String TEXT_20 = "();" + this.NL + "    }";
    protected final String TEXT_21 = String.valueOf(this.NL) + "    /** create a new representative for a ";
    protected final String TEXT_22 = "{@link ";
    protected final String TEXT_23 = "}";
    protected final String TEXT_24 = " UI component.*/" + this.NL + "    @NonNull public static ";
    protected final String TEXT_25 = " create";
    protected final String TEXT_26 = " (@NonNull ComponentIdentifier componentIdentifier) {" + this.NL + "        Validate.notNull(componentIdentifier);" + this.NL + "        return new ";
    protected final String TEXT_27 = "(componentIdentifier);" + this.NL + "    }";
    protected final String TEXT_28 = String.valueOf(this.NL) + "}";

    public static synchronized FactoryGenerator create(String lineSeparator) {
        nl = lineSeparator;
        FactoryGenerator result = new FactoryGenerator();
        nl = null;
        return result;
    }

    public String generate(Object argument) {
        StringBuffer stringBuffer = new StringBuffer();
        CommonGenInfo genInfo = (CommonGenInfo)argument;
        String factoryName = genInfo.getClassName();
        String packageName = genInfo.getClassPackageName();
        Object specInfo = genInfo.getSpecificInformation();
        String fqnGeneratorClassName = this.getClass().getName();
        if (specInfo instanceof FactoryGenInfo) {
            FactoryGenInfo factoryInfo = (FactoryGenInfo)specInfo;
            List<CompInfoForFactoryGen> compInfoList = factoryInfo.getCompInformation();
            String toolkitInfoName = factoryInfo.getToolkitInfoName();
            String toolkitInfoFqName = factoryInfo.getToolkitInfoFqName();
            stringBuffer.append(this.TEXT_1);
            stringBuffer.append(packageName);
            stringBuffer.append(this.TEXT_2);
            if (toolkitInfoFqName != null) {
                stringBuffer.append("import ");
                stringBuffer.append(toolkitInfoFqName);
                stringBuffer.append(";");
            }
            stringBuffer.append(this.TEXT_5);
            stringBuffer.append(genInfo.getToolkitName());
            stringBuffer.append(this.TEXT_6);
            stringBuffer.append(fqnGeneratorClassName);
            stringBuffer.append(this.TEXT_7);
            stringBuffer.append(GenerateUtil.getISO8601Timestamp());
            stringBuffer.append(this.TEXT_8);
            stringBuffer.append(factoryName);
            stringBuffer.append(this.TEXT_9);
            if (toolkitInfoName != null) {
                stringBuffer.append(this.TEXT_10);
                stringBuffer.append(toolkitInfoName);
                stringBuffer.append("();");
            }
            stringBuffer.append(this.TEXT_12);
            stringBuffer.append(factoryName);
            stringBuffer.append(this.TEXT_13);
            if (toolkitInfoName != null) {
                stringBuffer.append(this.TEXT_14);
            }
            stringBuffer.append(this.TEXT_15);
            for (CompInfoForFactoryGen compInfo : compInfoList) {
                String componentName = compInfo.getComponentName();
                String implClassName = compInfo.getClassName();
                ComponentClass componentClass = compInfo.getComponentClass();
                String componentClassName = "";
                boolean hasComponentClass = false;
                if (componentClass != null && !componentClass.getName().isEmpty()) {
                    componentClassName = componentClass.getName();
                    hasComponentClass = true;
                }
                String returnType = compInfo.getMostSpecificVisibleSuperTypeName();
                Boolean hasDefaultMapping = compInfo.hasDefaultMapping();
                if (hasDefaultMapping.booleanValue()) {
                    stringBuffer.append(this.TEXT_16);
                    stringBuffer.append(componentName);
                    stringBuffer.append(this.TEXT_17);
                    stringBuffer.append(returnType);
                    stringBuffer.append(" create");
                    stringBuffer.append(componentName);
                    stringBuffer.append(this.TEXT_19);
                    stringBuffer.append(implClassName);
                    stringBuffer.append(this.TEXT_20);
                    continue;
                }
                stringBuffer.append(this.TEXT_21);
                if (hasComponentClass) {
                    stringBuffer.append("{@link ");
                    stringBuffer.append(componentClassName);
                    stringBuffer.append("}");
                } else {
                    stringBuffer.append(componentName);
                }
                stringBuffer.append(this.TEXT_24);
                stringBuffer.append(returnType);
                stringBuffer.append(" create");
                stringBuffer.append(componentName);
                stringBuffer.append(this.TEXT_26);
                stringBuffer.append(implClassName);
                stringBuffer.append(this.TEXT_27);
            }
            stringBuffer.append(this.TEXT_28);
        }
        return stringBuffer.toString();
    }
}

