/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestDataPO;
import org.eclipse.persistence.annotations.BatchFetch;
import org.eclipse.persistence.annotations.BatchFetchType;

@Entity
@Table(name="TEST_DATA", indexes={@Index(name="FK_TEST_DATA_LIST_IDX", columnList="FK_TEST_DATA_LIST", unique=false)})
class TestDataPO
implements ITestDataPO {
    public static final int DEFAULT_NUMBER_OF_LANGUAGES = 2;
    private transient Long m_id = null;
    private transient Map<String, String> m_map = new HashMap<String, String>(2);
    private transient Integer m_version = null;
    private Long m_parentProjectId = null;

    TestDataPO(Map<Locale, String> languageToValue) {
        for (Locale language : languageToValue.keySet()) {
            this.setValue(language, languageToValue.get(language));
        }
    }

    TestDataPO() {
    }

    @Override
    @Id
    @GeneratedValue
    public Long getId() {
        return this.m_id;
    }

    void setId(Long id) {
        this.m_id = id;
    }

    @Override
    @Transient
    public Long getParentProjectId() {
        return this.getHbmParentProjectId();
    }

    @Override
    public void setParentProjectId(Long projectId) {
        this.setHbmParentProjectId(projectId);
    }

    @Basic
    @Column(name="PARENT_PROJ")
    Long getHbmParentProjectId() {
        return this.m_parentProjectId;
    }

    void setHbmParentProjectId(Long projectId) {
        this.m_parentProjectId = projectId;
    }

    @Override
    @Version
    public Integer getVersion() {
        return this.m_version;
    }

    private void setVersion(Integer version) {
        this.m_version = version;
    }

    @Override
    @Transient
    public String getName() {
        return "";
    }

    @Override
    public ITestDataPO deepCopy() {
        TestDataPO td = new TestDataPO();
        td.getMap().putAll(this.getMap());
        td.setParentProjectId(this.getParentProjectId());
        return td;
    }

    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="LOCALE_TO_TD", indexes={@Index(name="TESTDATAPO_ID_IDX", columnList="TESTDATAPO_ID", unique=false)})
    @MapKeyColumn(name="LOCALE")
    @Column(name="TD_VALUE", length=4000, nullable=false)
    @JoinColumn(name="I18N_STR")
    @BatchFetch(value=BatchFetchType.JOIN)
    private Map<String, String> getMap() {
        return this.m_map;
    }

    void setMap(Map<String, String> map) {
        this.m_map = map;
    }

    @Override
    public void setValue(Locale lang, String value, IProjectPO project) {
        if (this.validateLang(lang, project)) {
            this.setValue(lang, value);
            this.setParentProjectId(project.getId());
        }
    }

    private void setValue(Locale lang, String value) {
        if (value != null && value.length() != 0) {
            this.getMap().put(lang.toString(), value);
        } else {
            this.getMap().remove(lang.toString());
        }
    }

    private boolean validateLang(Locale lang, IProjectPO project) {
        return project.getLangHelper().containsItem(lang);
    }

    @Override
    @Transient
    public String getValue(Locale lang) {
        Validate.notNull((Object)lang);
        return this.getMap().get(lang.toString());
    }

    @Override
    @Transient
    public Set<Locale> getLanguages() {
        HashSet<Locale> supportedLocales = new HashSet<Locale>();
        for (String localeCode : this.getMap().keySet()) {
            supportedLocales.add(LocaleUtils.toLocale((String)localeCode));
        }
        return supportedLocales;
    }

    public String toString() {
        TreeSet<String> sorter = new TreeSet<String>();
        for (Map.Entry<String, String> entry : this.getMap().entrySet()) {
            sorter.add(String.valueOf(entry.getKey()) + ":" + entry.getValue());
        }
        StringBuilder result = new StringBuilder(sorter.size() * 100);
        for (String line : sorter) {
            result.append(line);
            result.append("\n");
        }
        return result.toString();
    }

    @Override
    public void setData(ITestDataPO testData) {
        for (Locale language : testData.getLanguages()) {
            this.setValue(language, testData.getValue(language));
        }
    }

    @Override
    public void clear() {
        this.m_map.clear();
    }
}

