/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.businessprocess.UsedToolkitBP;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.jubula.mylyn.utils.MylynAccess;
import org.eclipse.jubula.toolkit.common.businessprocess.ToolkitSupportBP;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.toolkit.common.utils.ToolkitUtils;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ToolkitDescriptor;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.wikitext.ui.WikiText;
import org.eclipse.swt.widgets.Composite;

public class ControlFactory {
    private ControlFactory() {
    }

    public static DirectCombo<String> createToolkitCombo(Composite parent) {
        List descriptors = ComponentBuilder.getInstance().getCompSystem().getIndependentToolkitDescriptors(false);
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> displayValues = new ArrayList<String>();
        for (ToolkitDescriptor desc : descriptors) {
            values.add(desc.getToolkitID());
            displayValues.add(desc.getName());
        }
        return new DirectCombo(parent, 8, values, displayValues, false, true);
    }

    public static DirectCombo<String> createAutToolkitCombo(Composite parent, IProjectPO project, String currentValue) throws ToolkitPluginException {
        List<ToolkitDescriptor> toolkits = ControlFactory.getAutToolkits(project);
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> displayValues = new ArrayList<String>();
        for (ToolkitDescriptor desc : toolkits) {
            values.add(desc.getToolkitID());
            displayValues.add(desc.getName());
        }
        if (currentValue != null && currentValue.trim().length() != 0 && !values.contains(currentValue)) {
            values.add(currentValue);
            displayValues.add(currentValue);
        }
        return new DirectCombo(parent, 8, values, displayValues, false, true);
    }

    public static DirectCombo<String> createProjectToolkitCombo(Composite parent) {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        List toolkits = UsedToolkitBP.getInstance().getAllowedProjectToolkits(project);
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> displayValues = new ArrayList<String>();
        for (ToolkitDescriptor desc : toolkits) {
            values.add(desc.getToolkitID());
            displayValues.add(desc.getName());
        }
        String currentValue = project.getToolkit();
        if (currentValue != null && currentValue.trim().length() != 0 && !values.contains(currentValue)) {
            values.add(currentValue);
            String tkName = ToolkitUtils.getToolkitName((String)currentValue);
            displayValues.add(tkName);
        }
        return new DirectCombo(parent, 0, values, displayValues, false, true);
    }

    public static DirectCombo<String> createProjectMarkupLanguageCombo(Composite parent) {
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> displayValues = new ArrayList<String>();
        Set markupLanguagesFileExt = WikiText.getMarkupFileExtensions();
        for (String value : markupLanguagesFileExt) {
            values.add(value);
            displayValues.add(WikiText.getMarkupLanguageNameForFilename((String)value));
        }
        String markupLang = GeneralStorage.getInstance().getProject().getMarkupLanguage();
        if (StringUtils.isBlank((String)markupLang)) {
            markupLang = "mediawiki";
        }
        DirectCombo combo = new DirectCombo(parent, 0, values, displayValues, false, true);
        combo.setSelectedObject((Object)markupLang);
        return combo;
    }

    public static DirectCombo<String> createALMRepositoryCombo(Composite parent, String preConfiguredRepositoryName) {
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> displayValues = new ArrayList<String>();
        for (TaskRepository repo : MylynAccess.getAllRepositories()) {
            String repositoryLabel = repo.getRepositoryLabel();
            values.add(repositoryLabel);
            displayValues.add(repositoryLabel);
        }
        if (StringUtils.isNotBlank((String)preConfiguredRepositoryName) && !values.contains(preConfiguredRepositoryName)) {
            values.add(preConfiguredRepositoryName);
            displayValues.add(preConfiguredRepositoryName);
        }
        return new DirectCombo(parent, 0, values, displayValues, true, true);
    }

    public static DirectCombo<String> createAutToolkitCombo(Composite parent, IAUTMainPO aut) {
        ToolkitDescriptor toolkit = ComponentBuilder.getInstance().getCompSystem().getToolkitDescriptor(aut.getToolkit());
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> displayValues = new ArrayList<String>();
        if (toolkit != null) {
            values.add(toolkit.getToolkitID());
            displayValues.add(toolkit.getName());
        } else {
            String autToolkitId = aut.getToolkit();
            if (autToolkitId != null && autToolkitId.trim().length() != 0) {
                values.add(autToolkitId);
                displayValues.add(autToolkitId);
            }
        }
        return new DirectCombo(parent, 8, values, displayValues, false, true);
    }

    public static List<ToolkitDescriptor> getAutToolkits(IProjectPO project) throws ToolkitPluginException {
        CompSystem compSys = ComponentBuilder.getInstance().getCompSystem();
        String projToolkit = project.getToolkit();
        if (projToolkit == null) {
            return compSys.getIndependentToolkitDescriptors("toolkit");
        }
        String level = ToolkitSupportBP.getToolkitLevel((String)projToolkit);
        if ("toolkit".equals(level)) {
            ArrayList<ToolkitDescriptor> toolkitList = new ArrayList<ToolkitDescriptor>(1);
            toolkitList.add(compSys.getToolkitDescriptor(projToolkit));
            for (Object descObj : compSys.getIndependentToolkitDescriptors("toolkit")) {
                ToolkitDescriptor desc = (ToolkitDescriptor)descObj;
                if (!ToolkitUtils.doesToolkitInclude((String)desc.getToolkitID(), (String)projToolkit)) continue;
                toolkitList.add(desc);
            }
            return toolkitList;
        }
        return compSys.getIndependentToolkitDescriptors("toolkit");
    }
}

