/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;

public class CapBuilder {
    private static final String BOOLEAN_IDENTIFIER = Boolean.class.getName();
    private static final String INTEGER_IDENTIFIER = Integer.class.getName();
    private static final String STRING_IDENTIFIER = String.class.getName();
    private String m_rcMethod;
    private ComponentIdentifier m_ci = null;
    private List<MessageParam> m_params = new ArrayList<MessageParam>();
    private boolean m_defaultMapping = true;

    public CapBuilder(@NonNull String rcMethod) {
        Validate.notNull((Object)rcMethod);
        this.m_rcMethod = rcMethod;
    }

    public CapBuilder addParameter(@NonNull String value) {
        Validate.notNull((Object)value);
        this.m_params.add(new MessageParam(String.valueOf(value), STRING_IDENTIFIER));
        return this;
    }

    public CapBuilder addParameter(@NonNull Integer value) {
        Validate.notNull((Object)value);
        this.m_params.add(new MessageParam(String.valueOf(value), INTEGER_IDENTIFIER));
        return this;
    }

    public CapBuilder addParameter(@NonNull Boolean value) {
        Validate.notNull((Object)value);
        this.m_params.add(new MessageParam(String.valueOf(value), BOOLEAN_IDENTIFIER));
        return this;
    }

    public CapBuilder setComponentIdentifier(@Nullable ComponentIdentifier ci) {
        Validate.isTrue((boolean)(ci instanceof IComponentIdentifier));
        this.m_ci = ci;
        return this;
    }

    public CapBuilder setDefaultMapping(@NonNull Boolean defaultMapping) {
        Validate.notNull((Object)defaultMapping);
        this.m_defaultMapping = defaultMapping;
        return this;
    }

    @NonNull
    public CAP build() {
        MessageCap messageCap = new MessageCap();
        messageCap.setMethod(this.m_rcMethod);
        messageCap.sethasDefaultMapping(this.m_defaultMapping);
        messageCap.setCi((IComponentIdentifier)this.m_ci);
        for (MessageParam param : this.m_params) {
            messageCap.addMessageParam(param);
        }
        return messageCap;
    }
}

