/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.model.ParamDescriptionPO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.model.TDManagerPO;
import org.eclipse.jubula.client.core.model.TcParamDescriptionPO;
import org.eclipse.jubula.client.core.model.TestDataCategoryPO;
import org.eclipse.jubula.client.core.persistence.PersistenceUtil;
import org.eclipse.persistence.annotations.BatchFetch;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;

@Entity
@Table(name="PARAM_INTERFACE", indexes={@Index(name="FK_PARENT_IDX", columnList="FK_PARENT", unique=false), @Index(name="TD_MANAGER_IDX", columnList="TD_MANAGER", unique=false)})
class TestDataCubePO
implements ITestDataCubePO,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
PersistenceWeavedRest {
    private transient Long m_id = null;
    private transient Integer m_version = null;
    private Long m_parentProjectId = null;
    private String m_name = null;
    private ITestDataCategoryPO m_parent = null;
    private List<IParamDescriptionPO> m_hbmParameterList = new ArrayList<IParamDescriptionPO>();
    private ITDManager m_dataManager = null;
    private String m_dataFile = null;
    private transient boolean m_completeTd = false;
    private IParameterInterfacePO m_referencedDataCube;
    static final long serialVersionUID = 6865434670312299251L;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;

    private TestDataCubePO() {
    }

    TestDataCubePO(String name) {
        this.setName(name);
        this.setDataManager(PoMaker.createTDManagerPO(this));
    }

    @OneToMany(targetEntity=ParamDescriptionPO.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="PARAM_NODE")
    @OrderColumn(name="IDX_PARAM_NODE")
    @BatchFetch(value=BatchFetchType.JOIN)
    protected List<IParamDescriptionPO> getHbmParameterList() {
        return this.m_hbmParameterList;
    }

    protected void addParameter(IParamDescriptionPO p) {
        this.getModifiableParameterList().add(p);
        this.getHbmDataManager().addUniqueId(p.getUniqueId());
    }

    @Transient
    private List<IParamDescriptionPO> getModifiableParameterList() {
        if (this.getHbmParameterList() == null) {
            this.setHbmParameterList(new ArrayList<IParamDescriptionPO>());
        }
        return this.getHbmParameterList();
    }

    protected void removeParameter(IParamDescriptionPO p) {
        this.getModifiableParameterList().remove(p);
        this.getHbmDataManager().removeUniqueId(p.getUniqueId());
    }

    @Override
    public IParamDescriptionPO getParameterForUniqueId(String uniqueId) {
        Validate.notNull((Object)uniqueId, (String)Messages.TheUniqueIdMustNotBeNull);
        for (IParamDescriptionPO desc : this.getParameterList()) {
            if (!uniqueId.equals(desc.getUniqueId())) continue;
            return desc;
        }
        return null;
    }

    @Override
    public IParamDescriptionPO getParameterForName(String paramName) {
        Validate.notNull((Object)paramName, (String)"Param name must not be null.");
        for (IParamDescriptionPO desc : this.getParameterList()) {
            if (!paramName.equals(desc.getName())) continue;
            return desc;
        }
        return null;
    }

    @Override
    @Transient
    public List<String> getParamNames() {
        ArrayList<String> paramNames = new ArrayList<String>();
        for (IParamDescriptionPO desc : this.getParameterList()) {
            paramNames.add(desc.getName());
        }
        return paramNames;
    }

    protected final void clearParameterList() {
        this.getModifiableParameterList().clear();
        this.getDataManager().clearUniqueIds();
    }

    @Override
    @Transient
    public List<IParamDescriptionPO> getParameterList() {
        List<IParamDescriptionPO> hbmParameterList = this.getHbmParameterList();
        if (hbmParameterList == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(hbmParameterList);
    }

    @Override
    @Transient
    public ListIterator<IParamDescriptionPO> getParameterListIter() {
        if (this.getHbmParameterList() == null) {
            List emptyList = Collections.emptyList();
            return emptyList.listIterator();
        }
        return this.getHbmParameterList().listIterator();
    }

    @Override
    @Transient
    public int getParameterListSize() {
        if (this.getHbmParameterList() == null) {
            return 0;
        }
        return this.getHbmParameterList().size();
    }

    protected void setHbmParameterList(List<IParamDescriptionPO> parameterList) {
        this.m_hbmParameterList = parameterList;
    }

    @Override
    @Transient
    public ITDManager getDataManager() {
        if (this.getReferencedDataCube() != null) {
            return this.getReferencedDataCube().getDataManager();
        }
        return this.getHbmDataManager();
    }

    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, targetEntity=TDManagerPO.class)
    @JoinColumn(name="TD_MANAGER")
    @BatchFetch(value=BatchFetchType.JOIN)
    protected ITDManager getHbmDataManager() {
        return this.m_dataManager;
    }

    protected void setHbmDataManager(ITDManager dataManager) {
        this.m_dataManager = dataManager;
    }

    @Override
    public void setDataManager(ITDManager dataManager) {
        this.setHbmDataManager(dataManager);
    }

    @Override
    public void setParentProjectId(Long projectId) {
        this.setHbmParentProjectId(projectId);
        for (IParamDescriptionPO paramDesc : this.getHbmParameterList()) {
            paramDesc.setParentProjectId(projectId);
        }
    }

    @Transient
    private boolean getCompleteTdMap() {
        return this.m_completeTd;
    }

    public void setCompleteTdFlag(boolean flag) {
        this.m_completeTd = flag;
    }

    private void setHbmDataFile(String pathToExternalDataFile) {
        this.m_dataFile = pathToExternalDataFile;
    }

    @Basic
    @Column(name="DATA_FILE", length=4000)
    private String getHbmDataFile() {
        return this.m_dataFile;
    }

    @Override
    @Transient
    public String getDataFile() {
        return this.getHbmDataFile();
    }

    @Override
    public void setDataFile(String pathToExternalDataFile) {
        this.setHbmDataFile(pathToExternalDataFile);
    }

    @Override
    @Transient
    public IParameterInterfacePO getReferencedDataCube() {
        return this.getHbmReferencedDataCube();
    }

    @Override
    public void setReferencedDataCube(IParameterInterfacePO dataCube) {
        this.setHbmReferencedDataCube(dataCube);
    }

    private void setHbmReferencedDataCube(IParameterInterfacePO dataCube) {
        this.m_referencedDataCube = dataCube;
    }

    @ManyToOne(targetEntity=TestDataCubePO.class, fetch=FetchType.EAGER)
    @JoinColumn(name="REF_DATA_CUBE")
    @BatchFetch(value=BatchFetchType.JOIN)
    private IParameterInterfacePO getHbmReferencedDataCube() {
        return this.m_referencedDataCube;
    }

    @Override
    @Id
    @GeneratedValue
    public Long getId() {
        return this.m_id;
    }

    void setId(Long id) {
        this.m_id = id;
    }

    @Override
    @Basic
    @Column(name="NAME", length=4000)
    public String getName() {
        return this.m_name;
    }

    @Override
    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    @Transient
    public Long getParentProjectId() {
        return this.getHbmParentProjectId();
    }

    @Basic
    @Column(name="PARENT_PROJ")
    @org.eclipse.persistence.annotations.Index(name="PI_TDC_PARENT_PROJ")
    Long getHbmParentProjectId() {
        return this.m_parentProjectId;
    }

    void setHbmParentProjectId(Long projectId) {
        this.m_parentProjectId = projectId;
    }

    @Override
    @Transient
    public INodePO getSpecificationUser() {
        return null;
    }

    @Override
    @Version
    public Integer getVersion() {
        return this.m_version;
    }

    private void setVersion(Integer version) {
        this.m_version = version;
    }

    @Override
    public IParamDescriptionPO addParameter(String type, String name, IParamNameMapper mapper) {
        return this.addParameter(type, name, PersistenceUtil.generateGuid(), mapper);
    }

    @Override
    public IParamDescriptionPO addParameter(String type, String name, String guid, IParamNameMapper mapper) {
        Validate.notEmpty((String)type, (String)("Missing parameter type for TestDataCube " + this.getName()));
        Validate.notEmpty((String)name, (String)("Missing name for parameter in TestDataCube " + this.getName()));
        IParamDescriptionPO desc = PoMaker.createTcParamDescriptionPO(type, name, guid, mapper);
        this.addParameter(desc);
        return desc;
    }

    @Override
    public IParamDescriptionPO addParameter(String type, String userDefName, boolean always, IParamNameMapper mapper) {
        IParamDescriptionPO desc = null;
        if (always || this.getParameterForName(userDefName) == null) {
            desc = this.addParameter(type, userDefName, mapper);
        }
        return desc;
    }

    @Override
    public void moveParameter(String guId, int index) {
        IParamDescriptionPO parameter = this.getParameterForUniqueId(guId);
        List<IParamDescriptionPO> paramList = this.getHbmParameterList();
        int currIdx = paramList.indexOf(parameter);
        paramList.remove(currIdx);
        paramList.add(index, parameter);
    }

    @Override
    public void removeParameter(String uniqueId) {
        IParamDescriptionPO desc = this.getParameterForUniqueId(uniqueId);
        if (desc != null) {
            this.removeParameter(desc);
            ((TcParamDescriptionPO)desc).getParamNameMapper().removeParamNamePO(desc.getUniqueId());
        }
    }

    @Override
    @ManyToOne(targetEntity=TestDataCategoryPO.class)
    @JoinColumn(name="FK_PARENT")
    public ITestDataCategoryPO getParent() {
        return this.m_parent;
    }

    @Override
    public void setParent(ITestDataCategoryPO parent) {
        this.m_parent = parent;
    }

    public Object _persistence_post_clone() {
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new TestDataCubePO();
    }

    public Object _persistence_get(String string) {
        if (string == "parent") {
            return this.parent;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "hbmDataFile") {
            return this.hbmDataFile;
        }
        if (string == "hbmParameterList") {
            return this.hbmParameterList;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "hbmReferencedDataCube") {
            return this.hbmReferencedDataCube;
        }
        if (string == "version") {
            return this.version;
        }
        if (string == "hbmParentProjectId") {
            return this.hbmParentProjectId;
        }
        if (string == "hbmDataManager") {
            return this.hbmDataManager;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "parent") {
            this.parent = (ITestDataCategoryPO)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "hbmDataFile") {
            this.hbmDataFile = (String)object;
            return;
        }
        if (string == "hbmParameterList") {
            this.hbmParameterList = (List)object;
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "hbmReferencedDataCube") {
            this.hbmReferencedDataCube = (IParameterInterfacePO)object;
            return;
        }
        if (string == "version") {
            this.version = (Integer)object;
            return;
        }
        if (string == "hbmParentProjectId") {
            this.hbmParentProjectId = (Long)object;
            return;
        }
        if (string == "hbmDataManager") {
            this.hbmDataManager = (ITDManager)object;
            return;
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }
}

