/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.controllers.propertysources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.ui.controllers.propertysources.IPropertyController;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertySource
implements IPropertySource {
    private List<IPropertyDescriptor> m_propDescriptors = new ArrayList<IPropertyDescriptor>();

    protected void addPropertyDescriptor(IPropertyDescriptor propDescr) {
        this.m_propDescriptors.add(propDescr);
    }

    protected void addPropertyDescriptor(Collection<IPropertyDescriptor> propDescriptors) {
        this.m_propDescriptors.addAll(propDescriptors);
    }

    protected void clearPropertyDescriptors() {
        this.m_propDescriptors.clear();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        this.initPropDescriptor();
        IPropertyDescriptor[] propdescr = this.m_propDescriptors.toArray(new IPropertyDescriptor[this.m_propDescriptors.size()]);
        return propdescr;
    }

    protected List<IPropertyDescriptor> getPropertyDescriptorList() {
        return this.m_propDescriptors;
    }

    public Object getPropertyValue(Object id) {
        Object obj = null;
        if (id instanceof IPropertyController) {
            obj = ((IPropertyController)id).getProperty();
            return obj != null ? obj : "";
        }
        Assert.notReached((String)(String.valueOf(Messages.PropertyIDInexistent) + ":" + " " + id));
        return obj;
    }

    public void setPropertyValue(Object id, Object value) {
        if (id instanceof IPropertyController) {
            IPropertyController pc = (IPropertyController)id;
            pc.setProperty(value);
        } else {
            Assert.notReached((String)(String.valueOf(Messages.PropertyIDInexistent) + ":" + " " + id));
        }
        this.initPropDescriptor();
        DataEventDispatcher.getInstance().firePropertyChanged(false);
        DataEventDispatcher.getInstance().fireParamChangedListener();
    }

    protected abstract void initPropDescriptor();
}

