/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.tester.adapter;

import com.sun.javafx.scene.control.skin.TableColumnHeader;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.layout.Pane;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.util.IndexConverter;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.common.util.SelectionUtil;
import org.eclipse.jubula.rc.javafx.driver.EventThreadQueuerJavaFXImpl;
import org.eclipse.jubula.rc.javafx.util.AbstractTraverser;
import org.eclipse.jubula.rc.javafx.util.GenericTraverseHelper;
import org.eclipse.jubula.rc.javafx.util.NodeBounds;
import org.eclipse.jubula.rc.javafx.util.NodeTraverseHelper;
import org.eclipse.jubula.rc.javafx.util.Rounding;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.jubula.tools.internal.utils.StringParsing;

public class TreeTableOperationContext
extends AbstractTreeOperationContext<TreeTableView<?>, Object> {
    private static AutServerLogger log = new AutServerLogger(TreeTableOperationContext.class);
    private int m_column = 0;
    private List<TreeTableColumn<?, ?>> m_columns = new ArrayList();

    public TreeTableOperationContext(IEventThreadQueuer queuer, IRobot robot, TreeTableView<?> treeTable) {
        super(queuer, robot, treeTable);
        if (treeTable.getRoot() == null) {
            throw new StepExecutionException("Tree Table is empty.", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
    }

    public void setColumn(int column) {
        this.m_column = column;
    }

    protected String convertValueToText(final Object node, int row) throws StepExecutionException {
        String result = EventThreadQueuerJavaFXImpl.invokeAndWait("convertValueToText", new Callable<String>(){

            @Override
            public String call() throws Exception {
                Object val;
                TreeItem item;
                if (node instanceof TreeItem && (item = (TreeItem)node) != null && (val = item.getValue()) != null) {
                    return val.toString();
                }
                return node.toString();
            }
        });
        return result;
    }

    public Collection<String> getNodeTextList(Object node) {
        String rendText;
        ArrayList<String> res = new ArrayList<String>();
        int rowNotUsed = 0;
        String valText = this.convertValueToText(node, rowNotUsed);
        if (valText != null) {
            res.add(valText);
        }
        if ((rendText = this.getRenderedText(node)) != null) {
            res.add(rendText);
        }
        return res;
    }

    public String getRenderedText(Object node) throws StepExecutionException {
        int indexOfTreeColumn = this.getIndexOfTreeColumn();
        return this.getRenderedTextFromCell(node, indexOfTreeColumn);
    }

    private int getIndexOfTreeColumn() {
        ObservableList columns = ((TreeTableView)this.getTree()).getColumns();
        TreeTableColumn treeColumn = ((TreeTableView)this.getTree()).getTreeColumn();
        int indexOfColumnContainingTree = 0;
        if (columns.contains((Object)treeColumn)) {
            indexOfColumnContainingTree = columns.indexOf((Object)treeColumn);
        }
        return indexOfColumnContainingTree;
    }

    public String getRenderedTextOfColumn(Object node) throws StepExecutionException {
        return this.getRenderedTextFromCell(node, this.m_column);
    }

    private String getRenderedTextFromCell(final Object node, final int col) {
        if (node instanceof TreeItem) {
            this.scrollNodeToVisible(node);
        }
        String result = EventThreadQueuerJavaFXImpl.invokeAndWait("getRenderedText", new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (node instanceof TreeTableCell) {
                    TreeTableCell cell = (TreeTableCell)node;
                    return cell.getText();
                }
                if (node instanceof TreeItem) {
                    TreeItem item = (TreeItem)node;
                    TreeTableView treeTable = (TreeTableView)TreeTableOperationContext.this.getTree();
                    List<TreeTableCell> cells = NodeTraverseHelper.getInstancesOf((Parent)treeTable, TreeTableCell.class);
                    for (TreeTableCell cell : cells) {
                        TreeItem checkItem;
                        TreeTableRow ttRow = cell.getTreeTableRow();
                        if (ttRow == null || (checkItem = ttRow.getTreeItem()) == null || item == null || !checkItem.equals(item) || treeTable.getVisibleLeafColumns().indexOf((Object)cell.getTableColumn()) != col) continue;
                        return cell.getText();
                    }
                }
                return null;
            }
        });
        return result;
    }

    public boolean isVisible(final Object node) {
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("isVisible", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                TreeItem item = (TreeItem)node;
                if (item.isExpanded() && ((TreeTableView)TreeTableOperationContext.this.getTree()).isVisible()) {
                    return true;
                }
                return false;
            }
        });
        return result;
    }

    public Rectangle getVisibleRowBounds(final Rectangle rowBounds) {
        Rectangle result = EventThreadQueuerJavaFXImpl.invokeAndWait("getVisibleRowBounds", new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                TreeTableView tree = (TreeTableView)TreeTableOperationContext.this.getTree();
                tree.layout();
                Rectangle visibleTreeBounds = new Rectangle(0, 0, Rounding.round(tree.getWidth()), Rounding.round(tree.getHeight()));
                return rowBounds.intersection(visibleTreeBounds);
            }
        });
        return result;
    }

    public void scrollNodeToVisible(final Object node) {
        EventThreadQueuerJavaFXImpl.invokeAndWait("scrollNodeToVisible", new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int index = ((TreeTableView)TreeTableOperationContext.this.getTree()).getRow((TreeItem)node);
                TreeTableView trt = (TreeTableView)TreeTableOperationContext.this.getTree();
                trt.scrollTo(index);
                if (TreeTableOperationContext.this.m_column >= trt.getColumns().size()) {
                    trt.scrollToColumnIndex(trt.getColumns().size() - 1);
                } else {
                    trt.scrollToColumnIndex(TreeTableOperationContext.this.m_column);
                }
                trt.layout();
                return null;
            }
        });
    }

    public void clickNode(Object node, ClickOptions clickOps) {
        this.scrollNodeToVisible(node);
        Rectangle rowBounds = this.getNodeBounds(node);
        Rectangle visibleRowBounds = this.getVisibleRowBounds(rowBounds);
        this.getRobot().click(this.getTree(), (Object)visibleRowBounds, clickOps);
    }

    public void expandNode(final Object node) {
        this.scrollNodeToVisible(node);
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("expandNode", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                TreeItem item = (TreeItem)node;
                TreeTableView treeTable = (TreeTableView)TreeTableOperationContext.this.getTree();
                List<TreeTableCell> cells = NodeTraverseHelper.getInstancesOf((Parent)treeTable, TreeTableCell.class);
                for (TreeTableCell treeTableCell : cells) {
                    TreeItem checkItem;
                    TreeTableRow ttRow = treeTableCell.getTreeTableRow();
                    if (ttRow == null || (checkItem = ttRow.getTreeItem()) == null || item == null || !checkItem.equals(item) || item.isExpanded()) continue;
                    return treeTableCell.getTreeTableRow().getDisclosureNode();
                }
                return null;
            }
        });
        if (result != null) {
            this.getRobot().click(result, null, ClickOptions.create().setClickCount(1).setMouseButton(1));
        }
        EventThreadQueuerJavaFXImpl.invokeAndWait("expandNodeCheckIfExpanded", new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TreeItem item = (TreeItem)node;
                if (!((TreeTableView)TreeTableOperationContext.this.getTree()).isDisabled() && !item.isExpanded()) {
                    log.warn((Object)("Expand node fallback used for: " + item.getValue()));
                    item.setExpanded(true);
                }
                return null;
            }
        });
    }

    public void collapseNode(final Object node) {
        this.scrollNodeToVisible(node);
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("collapseNode", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                TreeItem item = (TreeItem)node;
                TreeTableView treeTable = (TreeTableView)TreeTableOperationContext.this.getTree();
                List<TreeTableCell> cells = NodeTraverseHelper.getInstancesOf((Parent)treeTable, TreeTableCell.class);
                for (TreeTableCell treeTableCell : cells) {
                    TreeItem checkItem;
                    TreeTableRow ttRow = treeTableCell.getTreeTableRow();
                    if (ttRow == null || (checkItem = ttRow.getTreeItem()) == null || item == null || !checkItem.equals(item) || !item.isExpanded()) continue;
                    return treeTableCell.getTreeTableRow().getDisclosureNode();
                }
                return null;
            }
        });
        if (result != null) {
            this.getRobot().click(result, null, ClickOptions.create().setClickCount(1).setMouseButton(1));
        }
        EventThreadQueuerJavaFXImpl.invokeAndWait("collapseNodeCheckIfExpanded", new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TreeItem item = (TreeItem)node;
                if (!((TreeTableView)TreeTableOperationContext.this.getTree()).isDisabled() && item.isExpanded()) {
                    log.warn((Object)("Expand node fallback used for: " + item.getValue()));
                    item.setExpanded(true);
                }
                return null;
            }
        });
    }

    public Object getSelectedNode() {
        TreeItem result = (TreeItem)EventThreadQueuerJavaFXImpl.invokeAndWait("getSelectedNode", new Callable<TreeItem<?>>(){

            @Override
            public TreeItem<?> call() throws Exception {
                return (TreeItem)((TreeTableView)TreeTableOperationContext.this.getTree()).getSelectionModel().getSelectedItem();
            }
        });
        if (result != null) {
            SelectionUtil.validateSelection((Object[])new Object[]{result});
        } else {
            SelectionUtil.validateSelection((Object[])new Object[0]);
        }
        return result;
    }

    public Object[] getSelectedNodes() {
        Object[] result = EventThreadQueuerJavaFXImpl.invokeAndWait("getSelectedNodes", new Callable<Object[]>(){

            @Override
            public Object[] call() throws Exception {
                return ((TreeTableView)TreeTableOperationContext.this.getTree()).getSelectionModel().getSelectedItems().toArray();
            }
        });
        SelectionUtil.validateSelection((Object[])result);
        return result;
    }

    public Object[] getRootNodes() {
        Object[] result = EventThreadQueuerJavaFXImpl.invokeAndWait("getRootNodes", new Callable<Object[]>(){

            @Override
            public Object[] call() throws Exception {
                TreeTableView tree = (TreeTableView)TreeTableOperationContext.this.getTree();
                if (tree.showRootProperty().getValue().booleanValue()) {
                    return new Object[]{tree.getRoot()};
                }
                return TreeTableOperationContext.this.getChildren(tree.getRoot());
            }
        });
        return result;
    }

    public Object getParent(final Object child) {
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("getParent", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ((TreeItem)child).getParent();
            }
        });
        return result;
    }

    public Object getChild(final Object parent, final int index) {
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("getChild", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ((TreeItem)parent).getChildren().get(index);
            }
        });
        return result;
    }

    public int getNumberOfChildren(final Object parent) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getNumberOfChildren", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ((TreeItem)parent).getChildren().size();
            }
        });
    }

    public boolean isLeaf(final Object node) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("isLeaf", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (((TreeItem)node).getChildren().size() == 0) {
                    return true;
                }
                return false;
            }
        });
    }

    public Object[] getChildren(final Object parent) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getChildren", new Callable<Object[]>(){

            @Override
            public Object[] call() throws Exception {
                return ((TreeItem)parent).getChildren().toArray();
            }
        });
    }

    public Rectangle getNodeBounds(final Object node) {
        this.scrollNodeToVisible(node);
        Rectangle nodeBounds = EventThreadQueuerJavaFXImpl.invokeAndWait("getNodeBounds", new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                TreeTableView treeTable = (TreeTableView)TreeTableOperationContext.this.getTree();
                treeTable.layout();
                TreeItem item = (TreeItem)node;
                List<TreeTableCell> cells = NodeTraverseHelper.getInstancesOf((Parent)treeTable, TreeTableCell.class);
                for (TreeTableCell cell : cells) {
                    TreeItem checkItem;
                    TreeTableRow ttRow = cell.getTreeTableRow();
                    if (ttRow == null || (checkItem = ttRow.getTreeItem()) == null || item == null || !checkItem.equals(item) || treeTable.getVisibleLeafColumns().indexOf((Object)cell.getTableColumn()) != TreeTableOperationContext.this.m_column) continue;
                    Rectangle b = NodeBounds.getAbsoluteBounds((Node)cell);
                    Rectangle treeB = NodeBounds.getAbsoluteBounds((Node)treeTable);
                    return new Rectangle(Math.abs(treeB.x - b.x), Math.abs(treeB.y - b.y), Rounding.round(b.getWidth()), Rounding.round(b.getHeight()));
                }
                return null;
            }
        });
        if (nodeBounds == null) {
            throw new StepExecutionException("Could not retrieve visible node bounds.", EventFactory.createActionError((String)"TestErrorEvent.NotVisible"));
        }
        return nodeBounds;
    }

    public int getIndexOfChild(final Object parent, final Object child) {
        return EventThreadQueuerJavaFXImpl.invokeAndWait("getIndexOfChild", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                if (parent == null) {
                    Object[] rootNodes = TreeTableOperationContext.this.getRootNodes();
                    int i = 0;
                    while (i < rootNodes.length) {
                        if (ObjectUtils.equals((Object)rootNodes[i], (Object)child)) {
                            return i;
                        }
                        ++i;
                    }
                    return -1;
                }
                ObservableList children = ((TreeItem)parent).getChildren();
                if (children.contains(child)) {
                    return children.indexOf(child);
                }
                return -1;
            }
        });
    }

    public int getRowFromString(final String row, final String operator) {
        Integer result = EventThreadQueuerJavaFXImpl.invokeAndWait("getRowFromString", new Callable<Integer>(){

            /*
             * Unable to fully structure code
             */
            @Override
            public Integer call() throws Exception {
                block6: {
                    rowInt = null;
                    treetable = (TreeTableView)TreeTableOperationContext.access$0(TreeTableOperationContext.this);
                    if (treetable.getColumns().size() <= 0) {
                        throw new StepExecutionException("No Header", EventFactory.createActionError((String)"TestErrorEvent.NoHeader"));
                    }
                    try {
                        rowInt = IndexConverter.toImplementationIndex((int)Integer.parseInt(row));
                        break block6;
                    }
                    catch (NumberFormatException v0) {
                        (TreeTableColumn)treetable.getColumns().get(0);
                        i = 0;
                        cellTxt = TreeTableOperationContext.this.getCellText(i, 0);
                        ** while (cellTxt != null)
                    }
lbl-1000:
                    // 1 sources

                    {
                        cellTxt = TreeTableOperationContext.this.getCellText(i, 0);
                        if (MatchUtil.getInstance().match(cellTxt, row, operator)) {
                            return new Integer(i);
                        }
                        ++i;
                        continue;
                    }
                }
                if (rowInt == null) {
                    throw new StepExecutionException("Row not found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
                }
                return rowInt;
            }
        });
        return result;
    }

    public int getColumnFromString(final String colPath, final String op, final boolean leafColumn) {
        Integer result = EventThreadQueuerJavaFXImpl.invokeAndWait("getColumnFromString", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                List path;
                TreeTableView treeTable = (TreeTableView)TreeTableOperationContext.this.getTree();
                TreeTableColumn column = TreeTableOperationContext.this.determineColumn(colPath, op, treeTable, path = StringParsing.splitToList((String)colPath, (char)'/', (char)'\\', (boolean)false));
                if (column == null) {
                    throw new StepExecutionException("Column not found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
                }
                if (treeTable.getVisibleLeafColumns().contains((Object)column)) {
                    return treeTable.getVisibleLeafColumns().indexOf((Object)column);
                }
                if (leafColumn) {
                    throw new StepExecutionException("Invalid column path: " + colPath + " not a leaf column", EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
                }
                if (!TreeTableOperationContext.this.m_columns.contains(column)) {
                    TreeTableOperationContext.this.m_columns.add(column);
                }
                return TreeTableOperationContext.this.m_columns.indexOf(column);
            }
        });
        return result;
    }

    private TreeTableColumn<?, ?> determineColumn(String colPath, String op, TreeTableView<?> treeTable, List<String> path) {
        ObservableList columns = colPath.contains("/") ? treeTable.getColumns() : treeTable.getVisibleLeafColumns();
        TreeTableColumn column = null;
        Iterator<String> pathIterator = path.iterator();
        String currCol = null;
        block6: while (pathIterator.hasNext()) {
            try {
                currCol = pathIterator.next();
                int usrIdxCol = Integer.parseInt(currCol);
                if (usrIdxCol == 0) {
                    ++usrIdxCol;
                }
                int i = IndexConverter.toImplementationIndex((int)usrIdxCol);
                if (MatchUtil.NOT_EQUALS == op) {
                    int j = 0;
                    while (j < columns.size()) {
                        if (j != i) {
                            if (pathIterator.hasNext()) {
                                columns = ((TreeTableColumn)columns.get(j)).getColumns();
                            } else {
                                column = (TreeTableColumn)columns.get(j);
                            }
                        }
                        ++j;
                    }
                    continue;
                }
                try {
                    if (pathIterator.hasNext()) {
                        columns = ((TreeTableColumn)columns.get(i)).getColumns();
                        continue;
                    }
                    column = (TreeTableColumn)columns.get(i);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new StepExecutionException("Invalid Index: " + IndexConverter.toUserIndex((int)i), EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
                }
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    if (path.size() <= 1) {
                        columns = treeTable.getColumns();
                    }
                    if (columns.size() <= 0) {
                        throw new StepExecutionException("No Columns", EventFactory.createActionError((String)"TestErrorEvent.NoHeader"));
                    }
                    for (Object c : columns) {
                        TreeTableColumn col = (TreeTableColumn)c;
                        String header = col.getText();
                        if (!MatchUtil.getInstance().match(header, currCol, op)) continue;
                        column = col;
                        if (!pathIterator.hasNext()) continue block6;
                        columns = col.getColumns();
                        continue block6;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return column;
    }

    public Rectangle getHeaderBounds(final int column) {
        Rectangle result = EventThreadQueuerJavaFXImpl.invokeAndWait("getHeaderBounds", new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                TreeTableView treeTable = (TreeTableView)TreeTableOperationContext.this.getTree();
                TreeTableColumn col = TreeTableOperationContext.this.m_columns.size() > 0 ? (TreeTableColumn)TreeTableOperationContext.this.m_columns.get(column) : treeTable.getVisibleLeafColumn(column);
                treeTable.scrollToColumn(col);
                treeTable.layout();
                Parent headerRow = (Parent)treeTable.lookup("TableHeaderRow");
                Set columnHeaders = headerRow.lookupAll("column-header");
                treeTable.localToScreen(0.0, 0.0);
                for (Node n : columnHeaders) {
                    TableColumnHeader colH = (TableColumnHeader)n;
                    if (!colH.getTableColumn().equals(col)) continue;
                    Rectangle b = NodeBounds.getAbsoluteBounds(n);
                    Rectangle tableB = NodeBounds.getAbsoluteBounds((Node)treeTable);
                    return new Rectangle(Math.abs(tableB.x - b.x), Math.abs(tableB.y - b.y), Rounding.round(b.getWidth()), Rounding.round(b.getHeight()));
                }
                return null;
            }
        });
        return result;
    }

    public Object getTableHeader() {
        Object result = EventThreadQueuerJavaFXImpl.invokeAndWait("getTableHeader", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ((TreeTableView)TreeTableOperationContext.this.getTree()).lookup("TableHeaderRow");
            }
        });
        return result;
    }

    public Rectangle scrollCellToVisible(final int row, final int column) throws StepExecutionException {
        Rectangle result = EventThreadQueuerJavaFXImpl.invokeAndWait("scrollCellToVisible", new Callable<Rectangle>(){

            @Override
            public Rectangle call() throws Exception {
                TreeTableView treeTable = (TreeTableView)TreeTableOperationContext.this.getTree();
                TreeTableColumn col = null;
                col = TreeTableOperationContext.this.m_columns.size() == 0 ? treeTable.getVisibleLeafColumn(column) : (TreeTableColumn)TreeTableOperationContext.this.m_columns.get(column);
                treeTable.scrollTo(row);
                treeTable.scrollToColumn(col);
                treeTable.layout();
                List<TreeTableCell> tCells = NodeTraverseHelper.getInstancesOf((Parent)treeTable, TreeTableCell.class);
                for (TreeTableCell cell : tCells) {
                    if (cell.getIndex() != row || cell.getTableColumn() != col || cell.getTreeTableView() != treeTable) continue;
                    Rectangle b = NodeBounds.getAbsoluteBounds((Node)cell);
                    Rectangle tableB = NodeBounds.getAbsoluteBounds((Node)treeTable);
                    return new Rectangle(Math.abs(tableB.x - b.x), Math.abs(tableB.y - b.y), Rounding.round(b.getWidth()), Rounding.round(b.getHeight()));
                }
                return null;
            }
        });
        return result;
    }

    public Cell getSelectedCell() throws StepExecutionException {
        Cell result = EventThreadQueuerJavaFXImpl.invokeAndWait("getSelectedCell", new Callable<Cell>(){

            @Override
            public Cell call() throws StepExecutionException {
                TreeTableView treeTable = (TreeTableView)TreeTableOperationContext.this.getTree();
                ObservableList list = treeTable.getSelectionModel().getSelectedCells();
                if (list.size() > 0) {
                    TreeTablePosition pos = null;
                    for (Object object : list) {
                        TreeTablePosition curr = (TreeTablePosition)object;
                        if (curr.getRow() != treeTable.getSelectionModel().getSelectedIndex()) continue;
                        pos = curr;
                        break;
                    }
                    if (pos != null) {
                        return new Cell(pos.getRow(), pos.getColumn());
                    }
                }
                throw new StepExecutionException("No selection found", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
            }
        });
        return result;
    }

    public boolean isCellEditable(final int row, final int column) {
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("isCellEditable", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                TreeTableView treeTable = (TreeTableView)TreeTableOperationContext.this.getTree();
                if (treeTable.isEditable()) {
                    TreeTableColumn col = null;
                    col = TreeTableOperationContext.this.m_columns.size() == 0 ? treeTable.getVisibleLeafColumn(column) : (TreeTableColumn)TreeTableOperationContext.this.m_columns.get(column);
                    if (col.isEditable()) {
                        treeTable.scrollTo(row);
                        treeTable.scrollToColumn(col);
                        treeTable.layout();
                        List<TreeTableCell> tCells = NodeTraverseHelper.getInstancesOf((Parent)treeTable, TreeTableCell.class);
                        for (TreeTableCell cell : tCells) {
                            if (cell.getIndex() != row || cell.getTableColumn() != col || cell.getTreeTableView() != treeTable || !NodeTraverseHelper.isVisible((Node)cell)) continue;
                            return cell.isEditable();
                        }
                    }
                }
                return false;
            }
        });
        return result;
    }

    public boolean isCellEditable(final TreeTableCell<?, ?> cell) {
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("isCellEditable", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                TreeTableView treeTable = (TreeTableView)TreeTableOperationContext.this.getTree();
                if (treeTable.isEditable()) {
                    return cell.isEditable();
                }
                return false;
            }
        });
        return result;
    }

    public String getColumnHeaderText(final int column) {
        String result = EventThreadQueuerJavaFXImpl.invokeAndWait("getColumnHeaderText", new Callable<String>(){

            @Override
            public String call() throws Exception {
                if (TreeTableOperationContext.this.m_columns.size() > 0) {
                    TreeTableColumn tCol = (TreeTableColumn)TreeTableOperationContext.this.m_columns.get(column);
                    return tCol.getText();
                }
                TreeTableColumn tCol = ((TreeTableView)TreeTableOperationContext.this.getTree()).getVisibleLeafColumn(column);
                return tCol.getText();
            }
        });
        return result;
    }

    public int getRowCount() {
        int result = EventThreadQueuerJavaFXImpl.invokeAndWait("getRowCount", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return ((TreeTableView)TreeTableOperationContext.this.getTree()).getExpandedItemCount();
            }
        });
        return result;
    }

    public int getColumnCount() {
        int result = EventThreadQueuerJavaFXImpl.invokeAndWait("getColumnCount", new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int counter = 0;
                for (TreeTableColumn column : ((TreeTableView)TreeTableOperationContext.this.getTree()).getColumns()) {
                    counter += new GenericTraverseHelper<TreeTableColumn, TreeTableColumn>().getInstancesOf(new AbstractTraverser<TreeTableColumn, TreeTableColumn>(column){

                        @Override
                        public Iterable<TreeTableColumn> getTraversableData() {
                            return ((TreeTableColumn)this.getObject()).getColumns();
                        }
                    }, TreeTableColumn.class).size();
                }
                return counter + ((TreeTableView)TreeTableOperationContext.this.getTree()).getColumns().size();
            }
        });
        return result;
    }

    public String getCellText(final int row, final int column) {
        String result = EventThreadQueuerJavaFXImpl.invokeAndWait("getCellText", new Callable<String>(){

            @Override
            public String call() throws Exception {
                TreeTableView table = (TreeTableView)TreeTableOperationContext.this.getTree();
                TreeTableColumn col = null;
                col = TreeTableOperationContext.this.m_columns.size() == 0 ? table.getVisibleLeafColumn(column) : (TreeTableColumn)TreeTableOperationContext.this.m_columns.get(column);
                table.scrollTo(row);
                table.scrollToColumn(col);
                table.layout();
                List<TreeTableCell> tCells = NodeTraverseHelper.getInstancesOf((Parent)table, TreeTableCell.class);
                for (TreeTableCell cell : tCells) {
                    if (cell.getIndex() != row || cell.getTableColumn() != col || cell.getTreeTableView() != table || !NodeTraverseHelper.isVisible((Node)cell)) continue;
                    String txt = cell.getText();
                    if (txt == null && cell.isEditing()) {
                        TextField f = (TextField)cell.getGraphic();
                        txt = f.getText();
                    }
                    return txt;
                }
                return null;
            }
        });
        return result;
    }

    public boolean isHeaderVisible() {
        boolean result = EventThreadQueuerJavaFXImpl.invokeAndWait("isHeaderVisible", new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                Pane header = (Pane)((TreeTableView)TreeTableOperationContext.this.getTree()).lookup("TableHeaderRow");
                if (header != null) {
                    return header.isVisible();
                }
                return false;
            }
        });
        return result;
    }

    public String getPropteryValue(final Object node, final String propertyname) {
        String prop = EventThreadQueuerJavaFXImpl.invokeAndWait("getPropertyValue", new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    return TreeTableOperationContext.this.getRobot().getPropertyValue(node, propertyname);
                }
                catch (RobotException e) {
                    throw new StepExecutionException(e.getMessage(), EventFactory.createActionError((String)"TestErrorEvent.PropertyNotAccessable"));
                }
            }
        });
        return String.valueOf(prop);
    }
}

