/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.agent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import org.eclipse.jubula.autagent.agent.AutAgent;
import org.eclipse.jubula.autagent.agent.IRestartAutHandler;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartAutAutRun
implements IRestartAutHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RestartAutAutRun.class);
    private AutIdentifier m_autId;
    private Socket m_autrunSocket;
    private BufferedReader m_socketReader;
    private String m_autStartClass;

    public RestartAutAutRun(AutIdentifier autId, Socket socket, BufferedReader reader, String startClass) {
        this.m_autId = autId;
        this.m_autrunSocket = socket;
        this.m_socketReader = reader;
        this.m_autStartClass = startClass;
    }

    @Override
    public void restartAut(AutAgent agent, int timeout) {
        try {
            PrintWriter writer = new PrintWriter(this.m_autrunSocket.getOutputStream(), true);
            writer.println("Req.PrepareForRestart");
            this.m_socketReader.readLine();
            agent.stopAut(this.m_autId, timeout);
            writer.println("Req.Restart");
        }
        catch (IOException e) {
            LOG.error("Error occurred while restarting AUT.", (Throwable)e);
        }
    }

    @Override
    public String getAUTStartClass() {
        return this.m_autStartClass;
    }
}

