/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.editors;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jubula.client.core.businessprocess.CleanupObjectMapping;
import org.eclipse.jubula.client.core.businessprocess.CompNameResult;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.IObjectMappingObserver;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.ObjectMappingEventDispatcher;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.businessprocess.db.TimestampBP;
import org.eclipse.jubula.client.core.commands.AUTModeChangedCommand;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompIdentifierPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IComponentNameReuser;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IObjectMappingProfilePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.ITimestampPO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.CompNamePM;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.ObjectMappingPM;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMReadException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.NativeSQLUtils;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.CompletenessBP;
import org.eclipse.jubula.client.ui.rcp.businessprocess.OMEditorBP;
import org.eclipse.jubula.client.ui.rcp.controllers.OpenOMETracker;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.controllers.TestExecutionContributor;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.objectmapping.LimitingDragSourceListener;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.objectmapping.OMDropTargetListener;
import org.eclipse.jubula.client.ui.rcp.dialogs.NagDialog;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingConfigComponent;
import org.eclipse.jubula.client.ui.rcp.editors.PersistableEditorInput;
import org.eclipse.jubula.client.ui.rcp.editors.PersistentObjectComparer;
import org.eclipse.jubula.client.ui.rcp.events.GuiEventDispatcher;
import org.eclipse.jubula.client.ui.rcp.filter.JBFilteredTree;
import org.eclipse.jubula.client.ui.rcp.filter.ObjectMappingEditorPatternFilter;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.objectmapping.OMEditorTreeContentProvider;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.OMEditorTreeLabelProvider;
import org.eclipse.jubula.client.ui.rcp.provider.selectionprovider.SelectionProviderIntermediate;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.views.IJBPart;
import org.eclipse.jubula.client.ui.views.IMultiTreeViewerContainer;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.swt.IFocusService;

public class ObjectMappingMultiPageEditor
extends MultiPageEditorPart
implements IJBPart,
IJBEditor,
IObjectMappingObserver,
GuiEventDispatcher.IEditorDirtyStateListener,
IMultiTreeViewerContainer,
IPropertyListener,
DataEventDispatcher.IDataChangedListener {
    public static final String CLEANUP_ID = "org.eclipse.ui.CleanupSubMenu";
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{25, 100};
    private static final int SPLIT_PAGE_IDX = 0;
    private JBEditorHelper m_editorHelper;
    private OMEditorBP m_omEditorBP;
    private TreeViewer m_compNameTreeViewer;
    private TreeViewer m_uiElementTreeViewer;
    private TreeViewer m_mappedComponentTreeViewer;
    private Set<IObjectMappingCategoryPO> m_deletedOMC = new HashSet<IObjectMappingCategoryPO>();
    private ObjectMappingConfigComponent m_mappingConfigComponent;
    private Map<Integer, ISelectionProvider> m_pageToSelectionProvider = new HashMap<Integer, ISelectionProvider>();
    private SelectionProviderIntermediate m_selectionProvider;
    private TreeViewer m_activeTreeViewer = null;
    private Text m_treeFilterText;
    private SelectionProviderIntermediate m_splitPaneSelectionProvider;

    protected void createPages() {
        if (this.m_editorHelper == null) {
            this.m_editorHelper = new JBEditorHelper(this);
        }
        this.m_omEditorBP = new OMEditorBP(this);
        IObjectMappingPO objMap = this.getAut().getObjMap();
        if (objMap == null) {
            objMap = PoMaker.createObjectMappingPO((IAUTMainPO)this.getAut());
            this.getAut().setObjMap(objMap);
        }
        this.checkMasterSessionUpToDate();
        MenuManager menuMgr = this.createContextMenu();
        GuiEventDispatcher.getInstance().addEditorDirtyStateListener(this, true);
        this.getEditorHelper().addListeners();
        this.getOmEditorBP().collectNewLogicalComponentNames();
        int splitPaneViewIndex = this.addPage(this.createSplitPanePageControl(this.getContainer(), menuMgr));
        int configViewIndex = this.addPage(this.createConfigPageControl(this.getContainer()));
        this.setPageText(splitPaneViewIndex, Messages.ObjectMappingEditorSplitPaneView);
        this.setPageText(configViewIndex, Messages.ObjectMappingEditorConfigView);
        this.m_pageToSelectionProvider.put(splitPaneViewIndex, (ISelectionProvider)this.m_splitPaneSelectionProvider);
        this.m_pageToSelectionProvider.put(configViewIndex, new NullSelectionProvider());
        this.m_selectionProvider = new SelectionProviderIntermediate();
        this.m_selectionProvider.setSelectionProviderDelegate(this.m_pageToSelectionProvider.get(this.getActivePage()));
        this.getSite().setSelectionProvider((ISelectionProvider)this.m_selectionProvider);
        this.getEditorSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_selectionProvider);
        ObjectMappingEventDispatcher.addObserver((IObjectMappingObserver)this);
        this.checkAndFixInconsistentData();
        OpenOMETracker.INSTANCE.addOME(this);
        DataEventDispatcher.getInstance().addDataChangedListener((DataEventDispatcher.IDataChangedListener)this, false);
    }

    private MenuManager createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        return menuMgr;
    }

    private void checkAndFixInconsistentData() {
        boolean isChanged = false;
        IObjectMappingPO objMap = this.getAut().getObjMap();
        isChanged |= this.fixCompNameReferences(objMap, (IComponentNameCache)this.getCompNameCache());
        isChanged |= this.removeDeletedCompNames(objMap, (IComponentNameCache)this.getCompNameCache());
        if (isChanged |= CleanupObjectMapping.cleanupObjectMapping((IObjectMappingPO)this.getAut().getObjMap())) {
            try {
                EditSupport editSupport = this.m_editorHelper.getEditSupport();
                editSupport.lockWorkVersion();
                this.m_editorHelper.setDirty(true);
                this.doSave((IProgressMonitor)new NullProgressMonitor());
            }
            catch (PMAlreadyLockedException pMAlreadyLockedException) {
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
            }
        }
    }

    private boolean removeDeletedCompNames(IObjectMappingPO objectMap, IComponentNameCache cache) {
        boolean isChanged = false;
        HashSet<IObjectMappingAssoziationPO> assocsToDelete = new HashSet<IObjectMappingAssoziationPO>();
        for (IObjectMappingAssoziationPO assoc : objectMap.getMappings()) {
            if (assoc.getTechnicalName() != null) continue;
            HashSet<String> compNamesToRemove = new HashSet<String>();
            for (String compNameGuid : assoc.getLogicalNames()) {
                if (cache.getResCompNamePOByGuid(compNameGuid) != null) continue;
                compNamesToRemove.add(compNameGuid);
            }
            for (String toRemove : compNamesToRemove) {
                assoc.removeLogicalName(toRemove);
                isChanged = true;
            }
            if (!assoc.getLogicalNames().isEmpty()) continue;
            isChanged = true;
            assocsToDelete.add(assoc);
        }
        for (IObjectMappingAssoziationPO assoc : assocsToDelete) {
            assoc.getCategory().removeAssociation(assoc);
            this.getEditorHelper().getEditSupport().getSession().remove((Object)assoc);
        }
        return isChanged;
    }

    private Control createConfigPageControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 3;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        Composite configComposite = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        configComposite.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 3;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        configComposite.setLayout((Layout)layout);
        this.m_mappingConfigComponent = new ObjectMappingConfigComponent(configComposite, this.getAut().getObjMap(), this);
        this.createConfigContextMenu(configComposite);
        return configComposite;
    }

    private Control createSplitPanePageControl(Composite parent, MenuManager contextMenuMgr) {
        this.m_splitPaneSelectionProvider = new SelectionProviderIntermediate();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 1;
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        parent.setLayout((Layout)layout);
        final SashForm mainSash = new SashForm(parent, 512);
        SashForm topSash = new SashForm((Composite)mainSash, 256);
        this.m_compNameTreeViewer = this.createSplitPaneViewer((Composite)topSash, "ObjectMappingEditor.UnAssignedLogic", this.getAut().getObjMap().getUnmappedLogicalCategory(), contextMenuMgr);
        this.m_splitPaneSelectionProvider.setSelectionProviderDelegate((ISelectionProvider)this.m_compNameTreeViewer);
        this.m_uiElementTreeViewer = this.createSplitPaneViewer((Composite)topSash, "ObjectMappingEditor.UnAssignedTech", this.getAut().getObjMap().getUnmappedTechnicalCategory(), contextMenuMgr);
        this.m_mappedComponentTreeViewer = this.createMappedSplitPaneViewer((Composite)mainSash, "ObjectMappingEditor.Assigned", this.getAut().getObjMap().getMappedCategory(), contextMenuMgr);
        this.linkSelection(new TreeViewer[]{this.m_compNameTreeViewer, this.m_uiElementTreeViewer, this.m_mappedComponentTreeViewer});
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.objectMapEditorContextId");
        final IPreferenceStore prefStore = Plugin.getDefault().getPreferenceStore();
        int divider = prefStore.getInt("OME_SASH0_PREF_KEY");
        int dividerSecond = prefStore.getInt("OME_SASH1_PREF_KEY");
        if (divider > 0 && dividerSecond > 0) {
            mainSash.setWeights(new int[]{divider, dividerSecond});
        } else {
            mainSash.setWeights(DEFAULT_SASH_WEIGHTS);
        }
        mainSash.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                int[] weights = mainSash.getWeights();
                prefStore.setValue("OME_SASH0_PREF_KEY", weights[0]);
                prefStore.setValue("OME_SASH1_PREF_KEY", weights[1]);
            }
        });
        return mainSash;
    }

    private void linkSelection(final TreeViewer[] treeViewersToLink) {
        TreeViewer[] treeViewerArray = treeViewersToLink;
        int n = treeViewersToLink.length;
        int n2 = 0;
        while (n2 < n) {
            final TreeViewer viewer = treeViewerArray[n2];
            viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelection() != null && !event.getSelection().isEmpty()) {
                        ObjectMappingMultiPageEditor.this.m_splitPaneSelectionProvider.setSelectionProviderDelegate((ISelectionProvider)viewer);
                        TreeViewer[] treeViewerArray = treeViewersToLink;
                        int n = treeViewersToLink.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeViewer viewerToDeselect = treeViewerArray[n2];
                            if (viewer != viewerToDeselect) {
                                viewerToDeselect.setSelection((ISelection)StructuredSelection.EMPTY);
                            }
                            ++n2;
                        }
                    }
                }
            });
            ++n2;
        }
    }

    private TreeViewer createSplitPaneViewer(Composite parent, String title, IObjectMappingCategoryPO topLevelCategory, MenuManager contextMenuMgr) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText(I18n.getString((String)title));
        titleLabel.setLayoutData((Object)GridDataFactory.defaultsFor((Control)titleLabel).create());
        final TreeViewer viewer = new TreeViewer(composite);
        viewer.getTree().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        ObjectMappingMultiPageEditor.setProviders((AbstractTreeViewer)viewer, this.getCompNameCache());
        viewer.setUseHashlookup(true);
        viewer.setComparator((ViewerComparator)new ObjectMappingTreeSorter());
        viewer.setComparer((IElementComparer)new PersistentObjectComparer());
        viewer.setInput((Object)topLevelCategory);
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        viewer.addDragSupport(2, transfers, (DragSourceListener)new LimitingDragSourceListener((ISelectionProvider)viewer, this.getAut()));
        viewer.addDropSupport(2, transfers, (DropTargetListener)new OMDropTargetListener(this, (Viewer)viewer));
        this.createTreeContextMenu(viewer, contextMenuMgr);
        DialogUtils.setWidgetName((Widget)viewer.getTree(), (String)title);
        IFocusService focusService = (IFocusService)this.getSite().getService(IFocusService.class);
        focusService.addFocusTracker((Control)viewer.getTree(), title);
        viewer.getTree().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ObjectMappingMultiPageEditor.this.m_activeTreeViewer = viewer;
            }
        });
        MouseListener mouseRemoveSelectionListener = this.createSelectionMouseListener(viewer);
        viewer.getTree().addMouseListener(mouseRemoveSelectionListener);
        return viewer;
    }

    private MouseListener createSelectionMouseListener(final TreeViewer viewer) {
        MouseListener mouseRemoveSelectionListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                ViewerCell cell = viewer.getCell(new Point(e.x, e.y));
                if (cell == null && viewer.getCell(new Point(e.x + 50, e.y)) == null) {
                    ObjectMappingMultiPageEditor.this.m_compNameTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                    ObjectMappingMultiPageEditor.this.m_mappedComponentTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                    ObjectMappingMultiPageEditor.this.m_uiElementTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        return mouseRemoveSelectionListener;
    }

    private TreeViewer createMappedSplitPaneViewer(Composite parent, String i18nTitleKey, IObjectMappingCategoryPO topLevelCategory, MenuManager contextMenuMgr) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        JBFilteredTree ft = new JBFilteredTree(composite, 2818, (PatternFilter)new ObjectMappingEditorPatternFilter(), true);
        this.setTreeFilterText(ft.getFilterControl());
        final TreeViewer viewer = ft.getViewer();
        viewer.getTree().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        ObjectMappingMultiPageEditor.setProviders((AbstractTreeViewer)viewer, this.getCompNameCache());
        viewer.setUseHashlookup(true);
        viewer.setComparator((ViewerComparator)new ObjectMappingTreeSorter());
        viewer.setComparer((IElementComparer)new PersistentObjectComparer());
        viewer.setInput((Object)topLevelCategory);
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        viewer.addDragSupport(2, transfers, (DragSourceListener)new LimitingDragSourceListener((ISelectionProvider)viewer, this.getAut()));
        viewer.addDropSupport(2, transfers, (DropTargetListener)new OMDropTargetListener(this, (Viewer)viewer));
        this.createTreeContextMenu(viewer, contextMenuMgr);
        DialogUtils.setWidgetName((Widget)viewer.getTree(), (String)i18nTitleKey);
        IFocusService focusService = (IFocusService)this.getSite().getService(IFocusService.class);
        focusService.addFocusTracker((Control)viewer.getTree(), i18nTitleKey);
        viewer.getTree().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ObjectMappingMultiPageEditor.this.m_activeTreeViewer = viewer;
            }
        });
        viewer.getTree().addMouseListener(this.createSelectionMouseListener(viewer));
        return viewer;
    }

    public void setTreeFilterText(Text treeFilterText) {
        this.m_treeFilterText = treeFilterText;
    }

    public Text getTreeFilterText() {
        return this.m_treeFilterText;
    }

    private void createTreeContextMenu(TreeViewer viewer, MenuManager menuMgr) {
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
    }

    private void createConfigContextMenu(Composite configComposite) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ObjectMappingMultiPageEditor.this.fillConfigContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)configComposite);
        this.setConfigContextMenu((Control)configComposite, menu);
    }

    private void setConfigContextMenu(Control control, Menu menu) {
        control.setMenu(menu);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.setConfigContextMenu(child, menu);
                ++n2;
            }
        }
    }

    protected void fillConfigContextMenu(IMenuManager mgr) {
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.rcp.commands.RevertChanges");
    }

    public void doSave(IProgressMonitor monitor) {
        monitor.beginTask(Messages.EditorsSaveEditors, -1);
        boolean errorOccurred = false;
        IObjectMappingPO objMap = this.getAut().getObjMap();
        TimestampBP.refreshTimestamp((ITimestampPO)objMap);
        try {
            try {
                if (this.getEditorHelper().isDirty()) {
                    this.performSave();
                }
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForEditor(e, this);
                errorOccurred = true;
                monitor.done();
                if (!errorOccurred) {
                    try {
                        this.reOpenEditor(((PersistableEditorInput)this.getEditorInput()).getNode());
                    }
                    catch (PMException e2) {
                        PMExceptionHandler.handlePMExceptionForEditor(e2, this);
                    }
                }
            }
            catch (ProjectDeletedException projectDeletedException) {
                PMExceptionHandler.handleProjectDeletedException();
                errorOccurred = true;
                monitor.done();
                if (!errorOccurred) {
                    try {
                        this.reOpenEditor(((PersistableEditorInput)this.getEditorInput()).getNode());
                    }
                    catch (PMException e) {
                        PMExceptionHandler.handlePMExceptionForEditor(e, this);
                    }
                }
            }
        }
        finally {
            monitor.done();
            if (!errorOccurred) {
                try {
                    this.reOpenEditor(((PersistableEditorInput)this.getEditorInput()).getNode());
                }
                catch (PMException e) {
                    PMExceptionHandler.handlePMExceptionForEditor(e, this);
                }
            }
        }
    }

    private void performSave() throws PMReadException, PMSaveException, PMException, ProjectDeletedException {
        EditSupport editSupport = this.getEditorHelper().getEditSupport();
        IWritableComponentNameCache compNameCache = editSupport.getCache();
        IObjectMappingProfilePO origProfile = ((IAUTMainPO)editSupport.getOriginal()).getObjMap().getProfile();
        IObjectMappingProfilePO workProfile = ((IAUTMainPO)editSupport.getWorkVersion()).getObjMap().getProfile();
        this.fixCompNameReferences(this.getAut().getObjMap(), (IComponentNameCache)compNameCache);
        ArrayList<DataChangedEvent> datachanged = new ArrayList<DataChangedEvent>();
        editSupport.saveWorkVersion();
        List specIdsforAssoc = NativeSQLUtils.getSpecIdsforAssoc((EntityManager)this.getEntityManager(), this.m_deletedOMC);
        for (IObjectMappingCategoryPO omc : this.m_deletedOMC) {
            NativeSQLUtils.removeOMCatAssoc((IObjectMappingCategoryPO)omc);
            datachanged.add(new DataChangedEvent((IPersistentObject)omc, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.all));
        }
        compNameCache.clear();
        this.refreshInMasterSession(specIdsforAssoc);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)this.getAut().getObjMap(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.all);
        ObjectMappingPM.deleteOMCategories(this.m_deletedOMC);
        this.m_deletedOMC.clear();
        datachanged.add(new DataChangedEvent((IPersistentObject)this.getAut().getObjMap(), DataEventDispatcher.DataState.Saved, DataEventDispatcher.UpdateState.all));
        DataEventDispatcher.getInstance().fireDataChangedListener(datachanged.toArray(new DataChangedEvent[datachanged.size()]));
        if (this.getAut().equals(TestExecution.getInstance().getConnectedAut()) && !workProfile.equals(origProfile)) {
            NagDialog.runNagDialog(Plugin.getActiveWorkbenchWindowShell(), "InfoNagger.ObjectMappingProfileChanged", "org.eclipse.jubula.client.ua.help.objectMapEditorContextId");
        }
    }

    private void refreshInMasterSession(List<BigDecimal> specIdsforAssoc) {
        for (BigDecimal id : specIdsforAssoc) {
            INodePO find = NodePM.findNodeById((Long)id.longValue());
            NodePM.refreshMasterSession((IPersistentObject)find);
        }
    }

    private boolean fixCompNameReferences(IObjectMappingPO objectMap, IComponentNameCache compNameCache) {
        boolean isChanged = false;
        for (IObjectMappingAssoziationPO assoc : objectMap.getMappings()) {
            HashSet<String> guidsToRemove = new HashSet<String>();
            for (String compNameGuid : assoc.getLogicalNames()) {
                IComponentNamePO compNamePo = compNameCache.getResCompNamePOByGuid(compNameGuid);
                if (compNamePo == null || compNamePo.getGuid().equals(compNameGuid)) continue;
                guidsToRemove.add(compNameGuid);
            }
            for (String toRemove : guidsToRemove) {
                isChanged = true;
                assoc.removeLogicalName(toRemove);
            }
        }
        if (isChanged) {
            CompNamePM.removeUnusedCompNames((Long)GeneralStorage.getInstance().getProject().getId(), (EntityManager)this.getEditorHelper().getEditSupport().getSession());
        }
        return isChanged;
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public IAUTMainPO getAut() {
        return (IAUTMainPO)this.getEditorHelper().getEditSupport().getWorkVersion();
    }

    private void checkMasterSessionUpToDate() {
        IObjectMappingPO objMap = this.getAut().getObjMap();
        boolean isUpToDate = TimestampBP.refreshEditorNodeInMasterSession((ITimestampPO)objMap);
        if (!isUpToDate) {
            CompletenessBP.getInstance().completeProjectCheck();
        }
    }

    @Override
    public Image getDisabledTitleImage() {
        return IconConstants.DISABLED_OM_EDITOR_IMAGE;
    }

    @Override
    public Composite getParentComposite() {
        return this.getContainer().getParent();
    }

    @Override
    public void reOpenEditor(IPersistentObject obj) throws PMException {
        this.getEditorHelper().setDirty(false);
        this.getEditorHelper().getEditSupport().close();
        PersistableEditorInput input = new PersistableEditorInput(obj);
        try {
            this.init(this.getEditorSite(), input);
            this.m_selectionProvider.setSelectionProviderDelegate(this.m_pageToSelectionProvider.get(this.getActivePage()));
            this.getSite().setSelectionProvider((ISelectionProvider)this.m_selectionProvider);
            IObjectMappingPO om = this.getAut().getObjMap();
            this.m_mappingConfigComponent.setInput(om);
            HashMap<TreeViewer, IObjectMappingCategoryPO> viewerToInput = new HashMap<TreeViewer, IObjectMappingCategoryPO>();
            viewerToInput.put(this.m_compNameTreeViewer, om.getUnmappedLogicalCategory());
            viewerToInput.put(this.m_uiElementTreeViewer, om.getUnmappedTechnicalCategory());
            viewerToInput.put(this.m_mappedComponentTreeViewer, om.getMappedCategory());
            for (TreeViewer splitViewer : viewerToInput.keySet()) {
                Object[] expandedSplitViewerElements = splitViewer.getExpandedElements();
                ObjectMappingMultiPageEditor.setProviders((AbstractTreeViewer)splitViewer, this.getCompNameCache());
                splitViewer.setInput(viewerToInput.get(splitViewer));
                splitViewer.setExpandedElements(expandedSplitViewerElements);
                splitViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        }
        catch (PartInitException partInitException) {
            this.getSite().getPage().closeEditor((IEditorPart)this, false);
        }
    }

    private static void setProviders(AbstractTreeViewer viewer, IWritableComponentNameCache compNameCache) {
        viewer.setLabelProvider((IBaseLabelProvider)new OMEditorTreeLabelProvider((IComponentNameCache)compNameCache));
        viewer.setContentProvider((IContentProvider)new OMEditorTreeContentProvider((IComponentNameCache)compNameCache));
    }

    public void setFocus() {
        if (this.getActivePage() == 0) {
            if (!this.m_compNameTreeViewer.getSelection().isEmpty()) {
                this.m_compNameTreeViewer.getControl().setFocus();
            } else if (!this.m_uiElementTreeViewer.getSelection().isEmpty()) {
                this.m_uiElementTreeViewer.getControl().setFocus();
            } else {
                this.m_mappedComponentTreeViewer.getControl().setFocus();
            }
        } else {
            super.setFocus();
        }
        Plugin.showStatusLine((IWorkbenchPart)this);
    }

    @Override
    public void fireDirtyProperty(boolean isDirty) {
        this.firePropertyChange(257);
        if (!isDirty) {
            this.firePropertyChange(258);
        }
    }

    @Override
    public JBEditorHelper getEditorHelper() {
        return this.m_editorHelper;
    }

    @Override
    public String getEditorPrefix() {
        return Messages.ObjectMappingEditorEditor;
    }

    @Override
    public void initTextAndInput(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(String.valueOf(this.getEditorPrefix()) + input.getName());
        this.getEditorSite().getActionBars().getMenuManager();
    }

    public void update(final int event, final Object obj) {
        Plugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ObjectMappingMultiPageEditor.this.switchEvent(event, obj);
            }
        });
    }

    private void createNewTechnicalNames(IComponentIdentifier[] components) {
        if (this.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
            return;
        }
        ArrayList<IObjectMappingAssoziationPO> alteredOMAs = new ArrayList<IObjectMappingAssoziationPO>();
        IObjectMappingPO objMap = this.getAut().getObjMap();
        IComponentIdentifier[] iComponentIdentifierArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentIdentifier component = iComponentIdentifierArray[n2];
            IObjectMappingAssoziationPO techNameAssoc = objMap.addTechnicalName(component, this.getAut());
            if (techNameAssoc != null) {
                IObjectMappingCategoryPO categoryToCreateIn = this.m_omEditorBP.getCategoryToCreateIn();
                if (categoryToCreateIn != null) {
                    categoryToCreateIn.addAssociation(techNameAssoc);
                } else {
                    objMap.getUnmappedTechnicalCategory().addAssociation(techNameAssoc);
                }
                alteredOMAs.add(techNameAssoc);
            } else {
                for (IObjectMappingAssoziationPO assoc : objMap.getMappings()) {
                    ICompIdentifierPO techName = assoc.getTechnicalName();
                    if (techName == null || !techName.equals(component)) continue;
                    techNameAssoc = assoc;
                    techNameAssoc.setCompIdentifier(component);
                    alteredOMAs.add(techNameAssoc);
                    break;
                }
            }
            ++n2;
        }
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.fireDataChangedListener((IPersistentObject)objMap, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        for (IObjectMappingAssoziationPO alteredOMA : alteredOMAs) {
            ded.fireDataChangedListener((IPersistentObject)alteredOMA, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
            StructuredSelection techNameSelection = new StructuredSelection((Object)alteredOMA);
            this.m_uiElementTreeViewer.setSelection((ISelection)techNameSelection);
            this.m_mappedComponentTreeViewer.setSelection((ISelection)techNameSelection);
        }
        this.getSite().getPage().activate((IWorkbenchPart)this);
        if (!alteredOMAs.isEmpty()) {
            this.getEditorHelper().setDirty(true);
            this.refreshAllViewer();
        }
    }

    private void refreshAllViewer() {
        this.m_uiElementTreeViewer.refresh();
        this.m_compNameTreeViewer.refresh();
        this.m_mappedComponentTreeViewer.refresh();
    }

    private void switchEvent(int event, Object obj) {
        switch (event) {
            case 1: {
                IAUTMainPO aut = (IAUTMainPO)obj;
                if (!this.getAut().equals(aut)) break;
                this.cleanupNames();
                this.synchronizeViewers();
                break;
            }
            case 2: {
                IAUTMainPO connectedAut = TestExecution.getInstance().getConnectedAut();
                if (!this.getAut().equals(connectedAut)) break;
                IComponentIdentifier[] comp = (IComponentIdentifier[])obj;
                this.createNewTechnicalNames(comp);
            }
        }
    }

    public void synchronizeViewers() {
        IObjectMappingPO om = this.getAut().getObjMap();
        this.m_compNameTreeViewer.setInput((Object)om.getUnmappedLogicalCategory());
        this.m_uiElementTreeViewer.setInput((Object)om.getUnmappedTechnicalCategory());
        this.m_mappedComponentTreeViewer.setInput((Object)om.getMappedCategory());
    }

    @Override
    public void handleEditorDirtyStateChanged(IJBEditor gdEditor, boolean isDirty) {
        if (gdEditor == this) {
            IEvaluationService service = (IEvaluationService)this.getSite().getService(IEvaluationService.class);
            service.requestEvaluation("org.eclipse.jubula.client.ui.rcp.propertytester.EditorPart.isDirty");
        }
    }

    public OMEditorBP getOmEditorBP() {
        return this.m_omEditorBP;
    }

    public TreeViewer getTreeViewer() {
        return this.getActiveTreeViewer();
    }

    public int cleanupNames() {
        int addedItems = 0;
        for (ITestSuitePO ts : TestSuiteBP.getListOfTestSuites()) {
            if (ts.getAut() == null || !ts.getAut().equals(this.getAut())) continue;
            CollectLogicalNamesOp op = new CollectLogicalNamesOp();
            TreeTraverser traverser = new TreeTraverser((INodePO)ts, (ITreeNodeOperation)op);
            traverser.traverse(true);
            addedItems += op.getAddedNodeCount();
            if (this.m_compNameTreeViewer == null) continue;
            this.m_compNameTreeViewer.refresh();
        }
        if (addedItems > 0) {
            this.getEditorHelper().setDirty(true);
        }
        if (!this.isDirty()) {
            this.getEntityManager().refresh((Object)this.getEditorHelper().getEditSupport().getWorkVersion());
            try {
                this.getEditorHelper().getEditSupport().reinitializeEditSupport();
                this.getEditorHelper().resetEditableState();
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForEditor(e, this);
            }
        }
        return addedItems;
    }

    public int addNewCompNames() {
        return 0;
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 257) {
            ((IEditorPart)source).isDirty();
        }
    }

    public boolean isDirty() {
        return super.isDirty() || this.getEditorHelper().isDirty();
    }

    public void dispose() {
        DataEventDispatcher.getInstance().removeDataChangedListener((DataEventDispatcher.IDataChangedListener)this);
        ObjectMappingEventDispatcher.removeObserver((IObjectMappingObserver)this);
        OpenOMETracker.INSTANCE.removeOME(this);
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), null);
        IAUTMainPO connectedAut = TestExecution.getInstance().getConnectedAut();
        if (AUTModeChangedCommand.getAutMode() == 2 && connectedAut != null && connectedAut.equals(this.getAut())) {
            TestExecutionContributor.getInstance().getClientTest().resetToTesting();
            DataEventDispatcher.getInstance().fireOMStateChanged(DataEventDispatcher.OMState.notRunning);
        }
        this.getSite().setSelectionProvider(null);
        GuiEventDispatcher.getInstance().removeEditorDirtyStateListener(this);
        if (this.m_editorHelper != null) {
            this.m_editorHelper.dispose();
        }
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        Object superAdapter = super.getAdapter(adapter);
        if (superAdapter != null) {
            return superAdapter;
        }
        if (this.m_editorHelper != null) {
            return this.m_editorHelper.getAdapter(adapter);
        }
        return null;
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            if (e.getUpdateState() != DataEventDispatcher.UpdateState.onlyInEditor && e.getPo() instanceof IComponentNamePO) {
                this.handleOneChange((IComponentNamePO)e.getPo(), e.getDataState());
                break;
            }
            if (e.getUpdateState() == DataEventDispatcher.UpdateState.onlyInEditor && e.getPo() instanceof IObjectMappingCategoryPO && e.getDataState() == DataEventDispatcher.DataState.Deleted) {
                this.handleOMdeleted((IObjectMappingCategoryPO)e.getPo());
            }
            ++n2;
        }
    }

    private void handleOMdeleted(IObjectMappingCategoryPO po) {
        this.m_deletedOMC.add(po);
    }

    private void handleOneChange(IComponentNamePO compName, DataEventDispatcher.DataState state) {
        switch (state) {
            case Renamed: {
                this.getCompNameCache().renamedCompName(compName.getGuid(), compName.getName());
                break;
            }
            case Deleted: {
                this.getOmEditorBP().deleteCompName(compName, false);
            }
        }
        this.m_compNameTreeViewer.refresh();
        this.m_uiElementTreeViewer.refresh();
        this.m_mappedComponentTreeViewer.refresh();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (this.m_editorHelper == null) {
            this.m_editorHelper = new JBEditorHelper(this);
        }
        this.m_editorHelper.init(site, input);
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        this.m_selectionProvider.setSelectionProviderDelegate(this.m_pageToSelectionProvider.get(newPageIndex));
    }

    public TreeViewer getActiveTreeViewer() {
        return this.m_activeTreeViewer;
    }

    public TreeViewer[] getTreeViewers() {
        return new TreeViewer[]{this.m_compNameTreeViewer, this.m_uiElementTreeViewer, this.m_mappedComponentTreeViewer};
    }

    public TreeViewer getCompNameTreeViewer() {
        return this.m_compNameTreeViewer;
    }

    public TreeViewer getUIElementTreeViewer() {
        return this.m_uiElementTreeViewer;
    }

    public TreeViewer getMappedTreeViewer() {
        return this.m_mappedComponentTreeViewer;
    }

    public EntityManager getEntityManager() {
        return this.getEditorHelper().getEditSupport().getSession();
    }

    @Override
    public IWritableComponentNameCache getCompNameCache() {
        return this.getEditorHelper().getEditSupport().getCache();
    }

    private class CollectLogicalNamesOp
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        private int m_addedNodeCount = 0;
        private List<IObjectMappingAssoziationPO> m_addedNodes = new ArrayList<IObjectMappingAssoziationPO>();
        private CompNamesBP m_compNamesBP = new CompNamesBP();

        private CollectLogicalNamesOp() {
        }

        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (!(node instanceof ICapPO)) {
                return true;
            }
            ICapPO cap = (ICapPO)node;
            CompNameResult result = this.m_compNamesBP.findCompName(ctx.getCurrentTreePath(), (INodePO)cap, cap.getComponentName(), (IComponentNameCache)ObjectMappingMultiPageEditor.this.getCompNameCache());
            IComponentNamePO compNamePo = ObjectMappingMultiPageEditor.this.getCompNameCache().getResCompNamePOByGuid(result.getCompName());
            if (compNamePo == null) {
                return true;
            }
            if (!(cap.getMetaComponentType() instanceof ConcreteComponent && ((ConcreteComponent)cap.getMetaComponentType()).hasDefaultMapping() || ObjectMappingMultiPageEditor.this.m_omEditorBP.getAssociation(compNamePo.getGuid()) != null)) {
                if (ObjectMappingMultiPageEditor.this.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
                    return true;
                }
                if (this.checkForExistingLogicalName(compNamePo)) {
                    return true;
                }
                IObjectMappingAssoziationPO assoc = PoMaker.createObjectMappingAssoziationPO(null, new HashSet());
                assoc.setParentProjectId(GeneralStorage.getInstance().getProject().getId());
                ObjectMappingMultiPageEditor.this.getCompNameCache().changeReuse((IComponentNameReuser)assoc, null, compNamePo.getGuid());
                ObjectMappingMultiPageEditor.this.getAut().getObjMap().getUnmappedLogicalCategory().addAssociation(assoc);
                this.m_addedNodes.add(assoc);
                ++this.m_addedNodeCount;
            }
            return true;
        }

        private boolean checkForExistingLogicalName(IComponentNamePO cN) {
            Map localChanges = ObjectMappingMultiPageEditor.this.getCompNameCache().getLocalChanges();
            if (localChanges.containsKey(cN.getGuid())) {
                return false;
            }
            for (String guid : localChanges.keySet()) {
                IComponentNamePO localCN = (IComponentNamePO)localChanges.get(guid);
                if (!localCN.getName().equals(cN.getName()) || localCN.getId() != null) continue;
                IObjectMappingAssoziationPO assoc = ObjectMappingMultiPageEditor.this.getAut().getObjMap().getLogicalNameAssoc(localCN.getGuid());
                Assert.isNotNull((Object)assoc);
                ObjectMappingMultiPageEditor.this.getCompNameCache().changeReuse((IComponentNameReuser)assoc, localCN.getGuid(), cN.getGuid());
                ObjectMappingMultiPageEditor.this.getCompNameCache().removeCompName(localCN.getGuid());
                return true;
            }
            return false;
        }

        public int getAddedNodeCount() {
            return this.m_addedNodeCount;
        }
    }

    private static class NullSelectionProvider
    implements ISelectionProvider {
        private NullSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }

    private static class ObjectMappingTreeSorter
    extends ViewerComparator {
        private ObjectMappingTreeSorter() {
        }

        public int category(Object element) {
            if (element instanceof IObjectMappingCategoryPO) {
                return 0;
            }
            if (element instanceof IObjectMappingAssoziationPO) {
                return 1;
            }
            if (element instanceof IComponentNamePO) {
                return 2;
            }
            return super.category(element);
        }
    }
}

