/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.filter;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class JBFilteredTree
extends FilteredTree {
    private static final int REFRESH_DELAY = 500;
    private String m_previousFilterText = "";
    private Object[] m_expandedElements = null;

    public JBFilteredTree(Composite parent, int treeStyle, PatternFilter filter, boolean useNewLook) {
        super(parent, treeStyle, filter, useNewLook);
    }

    protected long getRefreshJobDelay() {
        return 500L;
    }

    protected WorkbenchJob doCreateRefreshJob() {
        final WorkbenchJob wj = super.doCreateRefreshJob();
        wj.addJobChangeListener(new IJobChangeListener(){

            public void sleeping(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void running(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                if (JBFilteredTree.this.treeViewer != null && JBFilteredTree.this.treeViewer.getTree() != null && !JBFilteredTree.this.treeViewer.getTree().isDisposed() && JBFilteredTree.this.filterText != null && !JBFilteredTree.this.filterText.isDisposed()) {
                    if ("".equals(JBFilteredTree.this.filterText.getText())) {
                        JBFilteredTree.this.treeViewer.expandToLevel(JBFilteredTree.this.treeViewer.getAutoExpandLevel());
                    }
                } else {
                    wj.removeJobChangeListener((IJobChangeListener)this);
                }
                if (StringUtils.isEmpty((String)JBFilteredTree.this.getFilterString()) && event.getResult().isOK() && JBFilteredTree.this.m_expandedElements != null) {
                    JBFilteredTree.this.createExpanderJob().schedule(100L);
                }
            }

            public void awake(IJobChangeEvent event) {
            }

            public void aboutToRun(IJobChangeEvent event) {
            }
        });
        return wj;
    }

    private Job createExpanderJob() {
        return new WorkbenchJob("ExpandToOldValues"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (!JBFilteredTree.this.getViewer().getTree().isDisposed()) {
                        JBFilteredTree.this.getViewer().setExpandedElements(JBFilteredTree.this.m_expandedElements);
                    }
                }
                catch (SWTException sWTException) {}
                return new Status(0, "org.eclipse.jubula.client.ui.rcp", "");
            }
        };
    }

    protected void textChanged() {
        if (StringUtils.isEmpty((String)this.m_previousFilterText) && StringUtils.isNotEmpty((String)this.getFilterString())) {
            this.m_expandedElements = this.getViewer().getExpandedElements();
        }
        this.m_previousFilterText = this.getFilterString();
        super.textChanged();
    }
}

