/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.teststyle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jubula.client.core.model.CheckConfPO;
import org.eclipse.jubula.client.core.model.ICheckConfContPO;
import org.eclipse.jubula.client.core.model.ICheckConfPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.teststyle.analyze.Analyzer;
import org.eclipse.jubula.client.teststyle.analyze.AnalyzerContainer;
import org.eclipse.jubula.client.teststyle.checks.BaseCheck;
import org.eclipse.jubula.client.teststyle.checks.Category;
import org.eclipse.jubula.client.teststyle.checks.CheckCont;
import org.eclipse.jubula.client.teststyle.checks.DecoratingCheck;
import org.eclipse.jubula.client.teststyle.checks.Severity;
import org.eclipse.jubula.client.teststyle.checks.contexts.BaseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionHelper.class);
    private static Map<String, ICheckConfPO> defaults = new HashMap<String, ICheckConfPO>();

    private ExtensionHelper() {
    }

    public static Map<String, ICheckConfPO> getDefaults() {
        return defaults;
    }

    public static void initChecks() {
        IExtension[] iExtensionArray = ExtensionHelper.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement category = iConfigurationElementArray[n4];
                if ("category".equals(category.getName())) {
                    ExtensionHelper.handleCategory(category);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static void initAnalyzes() {
        IExtension[] iExtensionArray = ExtensionHelper.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement analyzer = iConfigurationElementArray[n4];
                if ("Analyzer".equals(analyzer.getName())) {
                    ExtensionHelper.handleAnalyzer(analyzer);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void handleAnalyzer(IConfigurationElement analyzerCfg) {
        String analyzerName = analyzerCfg.getAttribute("name");
        Analyzer analyzer = null;
        try {
            Object obj = analyzerCfg.createExecutableExtension("class");
            analyzer = (Analyzer)obj;
        }
        catch (CoreException e) {
            LOG.error("CoreException", (Throwable)e);
            return;
        }
        analyzer.setName(analyzerName);
        IConfigurationElement[] contextCfgs = analyzerCfg.getChildren("analyzerContexts")[0].getChildren();
        for (BaseContext context : ExtensionHelper.handleContexts(contextCfgs)) {
            AnalyzerContainer.add(context, analyzer);
        }
    }

    private static IExtension[] getExtensions() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.jubula.client.teststyle.definition");
        return extensionPoint.getExtensions();
    }

    private static void handleCategory(IConfigurationElement category) {
        String catName = category.getAttribute("name");
        String catDesc = category.getAttribute("description");
        Category cat = new Category(catName);
        cat.setDescription(catDesc);
        IConfigurationElement[] iConfigurationElementArray = category.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement chkCfg = iConfigurationElementArray[n2];
            BaseCheck chk = ExtensionHelper.handleCheck(chkCfg);
            if (chk != null) {
                BaseContext[] contextsArray;
                List<BaseContext> contexts;
                cat.addCheck(chk);
                ExtensionHelper.handleAttributes(chkCfg.getChildren("attributes")[0].getChildren(), chk);
                if (chk instanceof DecoratingCheck) {
                    contexts = ExtensionHelper.handleContexts(chkCfg.getChildren("decoratingContexts")[0].getChildren());
                    contextsArray = contexts.toArray(new BaseContext[contexts.size()]);
                    for (BaseContext context : contexts) {
                        chk.setActive(true, context);
                    }
                    DecoratingCheck decChk = (DecoratingCheck)chk;
                    CheckCont.add(decChk, cat, contextsArray);
                } else {
                    contexts = ExtensionHelper.handleContexts(chkCfg.getChildren("contexts")[0].getChildren());
                    contextsArray = contexts.toArray(new BaseContext[contexts.size()]);
                    for (BaseContext context : contexts) {
                        chk.setActive(true, context);
                    }
                    CheckCont.add(chk, cat, contextsArray);
                }
            }
            ++n2;
        }
    }

    static void initCheckConfiguration() {
        Persistor per = Persistor.instance();
        EntityManager s = per.openSession();
        EntityTransaction tx = per.getTransaction(s);
        IProjectPO project = GeneralStorage.getInstance().getProject();
        ICheckConfContPO cfg = (ICheckConfContPO)s.merge((Object)project.getProjectProperties().getCheckConfCont());
        for (BaseCheck chk : new HashSet<BaseCheck>(CheckCont.getAll())) {
            CheckConfPO chkPO = cfg.getCheckConf(chk.getId());
            ICheckConfPO defaultCfg = defaults.get(chk.getId());
            if (chkPO == null) {
                chkPO = cfg.createCheckConf();
                s.persist((Object)chkPO);
                chkPO.setSeverity(defaultCfg.getSeverity());
                chkPO.setActive(defaultCfg.isActive());
                chkPO.setAttr(defaultCfg.getAttr());
                chkPO.setContexts(new HashMap(defaultCfg.getContexts()));
                cfg.addCheckConf(chk.getId(), (ICheckConfPO)chkPO);
            } else {
                Map defaultCont = defaultCfg.getContexts();
                Map chkCont = chkPO.getContexts();
                for (Map.Entry cont : defaultCont.entrySet()) {
                    if (chkCont.containsKey(cont.getKey())) continue;
                    chkCont.put((String)cont.getKey(), (Boolean)cont.getValue());
                }
                Map defaultAttr = defaultCfg.getAttr();
                Map chkAttr = chkPO.getAttr();
                for (Map.Entry attr : defaultAttr.entrySet()) {
                    if (chkAttr.containsKey(attr.getKey())) continue;
                    chkAttr.put((String)attr.getKey(), (String)attr.getValue());
                }
            }
            chk.setConf((ICheckConfPO)chkPO);
        }
        try {
            try {
                per.commitTransaction(s, tx);
            }
            catch (Exception e) {
                LOG.error("Exception", (Throwable)e);
                per.dropSession(s);
            }
        }
        finally {
            per.dropSession(s);
        }
    }

    public static BaseCheck handleCheck(IConfigurationElement chkCfg) {
        BaseCheck chk = null;
        try {
            chk = (BaseCheck)chkCfg.createExecutableExtension("class");
        }
        catch (CoreException e) {
            LOG.error("CoreException", (Throwable)e);
            return null;
        }
        if (Boolean.TRUE.toString().equals(chkCfg.getAttribute("activeByDefault"))) {
            chk.setActive(true);
        } else {
            chk.setActive(false);
        }
        chk.setId(chkCfg.getAttribute("id"));
        chk.setName(chkCfg.getAttribute("name"));
        chk.setFulltextDescription(chkCfg.getAttribute("description"));
        String sevStr = chkCfg.getAttribute("defaultSeverity");
        if (sevStr != null) {
            chk.setSeverity(Severity.valueOf(sevStr));
        }
        defaults.put(chk.getId(), chk.getConf());
        return chk;
    }

    private static List<BaseContext> handleContexts(IConfigurationElement[] confCont) {
        String contextPackage = String.valueOf(BaseContext.class.getPackage().getName()) + ".";
        ArrayList<BaseContext> contexts = new ArrayList<BaseContext>();
        IConfigurationElement[] iConfigurationElementArray = confCont;
        int n = confCont.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement context = iConfigurationElementArray[n2];
            try {
                if (context.getName().equals("BaseContext")) {
                    contexts.add((BaseContext)context.createExecutableExtension("class"));
                } else {
                    String fullContextName = String.valueOf(contextPackage) + context.getAttribute("id");
                    contexts.add((BaseContext)Class.forName(fullContextName).newInstance());
                }
            }
            catch (Exception e) {
                LOG.error("Exception", (Throwable)e);
            }
            ++n2;
        }
        return contexts;
    }

    private static void handleAttributes(IConfigurationElement[] confCont, BaseCheck check) {
        IConfigurationElement[] iConfigurationElementArray = confCont;
        int n = confCont.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement attrConf = iConfigurationElementArray[n2];
            String name = attrConf.getAttribute("name");
            String defaultValue = attrConf.getAttribute("defaultValue");
            String descr = attrConf.getAttribute("description");
            check.setAttributeValue(name, defaultValue);
            check.addDescriptionForAttribute(name, descr);
            ++n2;
        }
    }
}

