/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.html.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the Browser component from the html toolkit.
 * 
 */
@TesterClass(testerClass="com.bredexsw.jubula.rc.html.web.implclasses.HtmlApplicationImplClass")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2018-08-27T05:59:01.077Z")
public class Browser implements org.eclipse.jubula.toolkit.html.components.Browser {
            public Browser() {
                super();
            }
    
    protected IComponentIdentifier getPseudoComponentIdentifier() {
        org.eclipse.jubula.tools.internal.objects.ComponentIdentifier pseudoIdentifier =
            new org.eclipse.jubula.tools.internal.objects.ComponentIdentifier();
        pseudoIdentifier.setComponentClassName("com.bredexsw.guidancer.webautserver.web.implclasses.WebBrowser"); //$NON-NLS-1$
        return pseudoIdentifier;
    }
    
        /**
         * 
         * @param uRL 
         *        the URL top open
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP openURL(@NonNull String uRL
        ) throws IllegalArgumentException {
            Validate.notNull(uRL, "Argument 'uRL' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcGotoUrl")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(uRL)
                        .build();
        }
        
        /**
         * 
         * 
         */
        @NonNull public CAP goBack(
        )  {
            
            return new CapBuilder("rcBack")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .build();
        }
        
        /**
         * 
         * @since 5.0
         */
        @NonNull public CAP closeWindow(
        )  {
            
            return new CapBuilder("rcClose")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .build();
        }
        
        /**
         * 
         * 
         */
        @NonNull public CAP reloadPage(
        )  {
            
            return new CapBuilder("rcReload")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .build();
        }
        
        /**
         * 
         * @param identifier 
         *        the identifier to use
         * @param identifierType 
         *        the identifier type to use
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectWindowWithIdentifier(@NonNull String identifier,@NonNull String identifierType
        ) throws IllegalArgumentException {
            Validate.notNull(identifier, "Argument 'identifier' must not be null"); //$NON-NLS-1$
            Validate.notNull(identifierType, "Argument 'identifierType' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcSelectWindowByIdentifier")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(identifier)
                        .addParameter(identifierType)
                        .build();
        }
        
        /**
         * 
         * @param windowTitle 
         *        the browser window title
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectWindowWithTitle(@NonNull String windowTitle,@NonNull Operator operator
        ) throws IllegalArgumentException {
            Validate.notNull(windowTitle, "Argument 'windowTitle' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcSelectWindow")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(windowTitle)
                        .addParameter(operator.rcValue())
                        .build();
        }
        
} 