/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.common.desktop;

import java.awt.AWTException;
import java.awt.CheckboxMenuItem;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.text.StrSubstitutor;
import org.eclipse.jubula.autagent.common.AutStarter;
import org.eclipse.jubula.autagent.common.agent.AutAgent;
import org.eclipse.jubula.autagent.common.gui.ObjectMappingFrame;
import org.eclipse.jubula.autagent.common.i18n.Messages;
import org.eclipse.jubula.communication.internal.Communicator;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DesktopIntegration
implements PropertyChangeListener {
    private static final String PROP_OBJECT_MAPPING_AUT = "OBJECT_MAPPING_AUT";
    private static AutIdentifier omAut = null;
    private static PropertyChangeSupport propertyChangedSupport;
    private static final Logger LOG;
    private boolean m_isSystraySupported;
    private TrayIcon m_trayIcon;
    private int m_port = 0;
    private PopupMenu m_startOMMMenu = null;
    private MenuItem m_stopOMMMenu = null;
    private List<String> m_auts = new ArrayList<String>();
    private Version m_version;

    static {
        LOG = LoggerFactory.getLogger(DesktopIntegration.class);
    }

    public DesktopIntegration(final AutAgent autAgent) {
        this.extractVersionInformation();
        ObjectMappingFrame.INSTANCE.setDesktopIntegration(this);
        propertyChangedSupport = new PropertyChangeSupport(this);
        propertyChangedSupport.addPropertyChangeListener(this);
        if (EnvironmentUtils.isMacOS()) {
            this.m_isSystraySupported = false;
            return;
        }
        this.m_isSystraySupported = SystemTray.isSupported();
        if (this.m_isSystraySupported) {
            SystemTray tray = SystemTray.getSystemTray();
            ClassLoader classLoader = this.getClass().getClassLoader();
            URL imageURL = classLoader.getResource("resources/autagent.png");
            Image image = Toolkit.getDefaultToolkit().getImage(imageURL);
            ActionListener exitListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            };
            PopupMenu popup = new PopupMenu();
            final CheckboxMenuItem strictModeItem = new CheckboxMenuItem("Strict AUT Management");
            autAgent.addPropertyChangeListener("killDuplicateAuts", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Object newValue = evt.getNewValue();
                    if (newValue instanceof Boolean) {
                        boolean isKillDuplicateAuts = (Boolean)newValue;
                        strictModeItem.setState(isKillDuplicateAuts);
                    } else {
                        LOG.error("Expected new value for property to be of type " + Boolean.class.getName());
                    }
                }
            });
            boolean isKillDuplicateAuts = autAgent.isKillDuplicateAuts();
            strictModeItem.setState(isKillDuplicateAuts);
            strictModeItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    autAgent.setKillDuplicateAuts(e.getStateChange() == 1);
                }
            });
            MenuItem defaultItem = new MenuItem("Exit");
            defaultItem.addActionListener(exitListener);
            popup.add(strictModeItem);
            PopupMenu objectMappingMenu = this.createObjectMappingPopup();
            popup.add(objectMappingMenu);
            popup.addSeparator();
            popup.add(defaultItem);
            this.m_trayIcon = new TrayIcon(image, "AUT Agent", popup);
            this.m_trayIcon.setImageAutoSize(true);
            try {
                tray.add(this.m_trayIcon);
            }
            catch (AWTException aWTException) {
                this.m_isSystraySupported = false;
            }
        }
    }

    private void extractVersionInformation() {
        InputStream versionInfo = DesktopIntegration.class.getResourceAsStream("/resources/version.properties");
        Properties p = new Properties();
        try {
            p.load(versionInfo);
            String versionString = StrSubstitutor.replace((Object)p.getProperty("build.version"), (Properties)p);
            this.m_version = new Version(versionString);
            versionInfo.close();
        }
        catch (Exception exception) {
            LOG.warn("Version properties could not be read");
        }
    }

    public static AutIdentifier getObjectMappingAUT() {
        return omAut;
    }

    public static void setObjectMappingAUT(AutIdentifier autID) {
        AutIdentifier id = omAut;
        omAut = autID;
        ObjectMappingFrame.INSTANCE.setOMAutName(autID != null ? autID.getID() : null);
        propertyChangedSupport.firePropertyChange(PROP_OBJECT_MAPPING_AUT, id, omAut);
    }

    private PopupMenu createObjectMappingPopup() {
        PopupMenu objectMappingMenu = new PopupMenu(Messages.ObjectMappingMenu);
        this.m_startOMMMenu = new PopupMenu(Messages.StartMenu);
        this.m_startOMMMenu.setEnabled(false);
        this.m_stopOMMMenu = new MenuItem(Messages.StopMenu);
        this.m_stopOMMMenu.setEnabled(false);
        MenuItem settings = new MenuItem(Messages.ObjectMappingOpen);
        settings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectMappingFrame.INSTANCE.showObjectMappingPanel();
            }
        });
        objectMappingMenu.add(this.m_startOMMMenu);
        objectMappingMenu.add(this.m_stopOMMMenu);
        objectMappingMenu.add(settings);
        return objectMappingMenu;
    }

    private void updateStatus() {
        if (this.m_isSystraySupported) {
            this.m_trayIcon.setToolTip(this.buildToolTip());
        }
    }

    private String buildToolTip() {
        String version = this.m_version != null ? this.m_version.toString() : "";
        StringBuilder tt = new StringBuilder("AUT Agent " + version);
        tt.append("\n");
        tt.append(" Port used: ");
        tt.append(this.m_port);
        if (!this.m_auts.isEmpty()) {
            tt.append("\n");
            tt.append(" ");
            tt.append(this.m_auts.size());
            tt.append(" running AUT");
            if (this.m_auts.size() > 1) {
                tt.append('s');
            }
            tt.append(":");
            String omAutId = omAut != null ? omAut.getID() : null;
            for (String aut : this.m_auts) {
                tt.append("\n");
                tt.append(" ");
                tt.append(aut);
                if (omAutId == null || !aut.equals(omAutId)) continue;
                tt.append(" ");
                tt.append("[OM]");
            }
        }
        return tt.toString();
    }

    public void setPort(int port) {
        this.m_port = port;
        this.updateStatus();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("auts")) {
            AutIdentifier aut;
            AutStarter.getInstance().getCommunicator().getConnectionManager().removePropertyChangedListener((PropertyChangeListener)this);
            AutStarter.getInstance().getCommunicator().getConnectionManager().addPropertyChangedListener((PropertyChangeListener)this);
            if (evt.getNewValue() instanceof AutIdentifier) {
                aut = (AutIdentifier)evt.getNewValue();
                this.m_auts.add(aut.getExecutableName());
                this.rebuildOMSubMenu();
            }
            if (evt.getOldValue() instanceof AutIdentifier) {
                aut = (AutIdentifier)evt.getOldValue();
                if (omAut != null && omAut.equals((Object)aut)) {
                    omAut = null;
                }
                this.m_auts.remove(aut.getExecutableName());
                this.rebuildOMSubMenu();
            }
        }
        if (evt.getPropertyName().equals(PROP_OBJECT_MAPPING_AUT) || evt.getPropertyName().equals("connection_changed")) {
            this.rebuildOMSubMenu();
        }
        this.updateStatus();
    }

    private void rebuildOMSubMenu() {
        this.m_startOMMMenu.removeAll();
        Communicator clientComm = AutStarter.getInstance().getCommunicator();
        if (clientComm != null && clientComm.getConnectionManager() != null && clientComm.getConnectionManager().getNextState() != 0) {
            this.m_startOMMMenu.setEnabled(false);
        } else {
            this.m_startOMMMenu.setEnabled(omAut == null && this.m_auts.size() > 0);
        }
        Set<AutIdentifier> auts = AutStarter.getInstance().getAgent().getAuts();
        for (AutIdentifier autIdentifier : auts) {
            MenuItem menuItem = new MenuItem(autIdentifier.getID());
            menuItem.addActionListener(this.createStartListener(autIdentifier));
            this.m_startOMMMenu.add(menuItem);
        }
        this.m_stopOMMMenu.setEnabled(omAut != null);
        ActionListener[] listener = this.m_stopOMMMenu.getActionListeners();
        int i = 0;
        while (i < listener.length) {
            this.m_stopOMMMenu.removeActionListener(listener[i]);
            ++i;
        }
        if (this.m_stopOMMMenu.isEnabled()) {
            this.m_stopOMMMenu.addActionListener(this.createStopListener(omAut));
        }
    }

    public abstract ActionListener createStartListener(AutIdentifier var1);

    public abstract ActionListener createStopListener(AutIdentifier var1);

    public void removeSystemTray() {
        SystemTray tray = SystemTray.getSystemTray();
        tray.remove(this.m_trayIcon);
    }
}

