/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the ComboComponent component from the concrete toolkit.
 * 
 */
@RealizedType(realizedType="guidancer.abstract.TextInputSupport")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2018-09-03T06:45:31.532Z")
public class ComboComponent extends org.eclipse.jubula.toolkit.base.internal.impl.TextInputComponent implements org.eclipse.jubula.toolkit.concrete.components.ComboComponent {
            public ComboComponent(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfEntryByValue(@NonNull String text,@NonNull Operator operator,@NonNull Boolean exists,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyContainsValue")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(text)
                        .addParameter(operator.rcValue())
                        .addParameter(exists)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfEntryByValue(@NonNull String text,@NonNull Operator operator,@NonNull Boolean exists
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyContainsValue")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(text)
                        .addParameter(operator.rcValue())
                        .addParameter(exists)
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfEntryByIndex(@NonNull String index,@NonNull Boolean selected,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(index, "Argument 'index' must not be null"); //$NON-NLS-1$
            Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifySelectedIndex")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(index)
                        .addParameter(selected)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param selected 
         *        whether the component is expected to be selected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfEntryByIndex(@NonNull String index,@NonNull Boolean selected
        ) throws IllegalArgumentException {
            Validate.notNull(index, "Argument 'index' must not be null"); //$NON-NLS-1$
            Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifySelectedIndex")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(index)
                        .addParameter(selected)
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectEntryByIndex(@NonNull String index
        ) throws IllegalArgumentException {
            Validate.notNull(index, "Argument 'index' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcSelectIndex")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(index)
                        .build();
        }
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param searchType 
         *        the search type
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectEntryByValue(@NonNull String text,@NonNull Operator operator,@NonNull SearchType searchType
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(searchType, "Argument 'searchType' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcSelectValue")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(text)
                        .addParameter(operator.rcValue())
                        .addParameter(searchType.rcValue())
                        .build();
        }
        
} 