/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.common.agent;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.autagent.common.agent.IRestartAutHandler;
import org.eclipse.jubula.autagent.common.agent.RestartAutAutRun;
import org.eclipse.jubula.autagent.common.agent.RestartAutConfiguration;
import org.eclipse.jubula.autagent.common.commands.AbstractStartToolkitAut;
import org.eclipse.jubula.autagent.common.i18n.Messages;
import org.eclipse.jubula.autagent.common.utils.AutStartHelperRegister;
import org.eclipse.jubula.autagent.common.utils.IAUTStartHelper;
import org.eclipse.jubula.communication.internal.Communicator;
import org.eclipse.jubula.communication.internal.IConnectionInitializer;
import org.eclipse.jubula.communication.internal.listener.ICommunicationErrorListener;
import org.eclipse.jubula.communication.internal.message.ConnectToAutResponseMessage;
import org.eclipse.jubula.communication.internal.message.ConnectToClientMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.PrepareForShutdownMessage;
import org.eclipse.jubula.communication.internal.message.StartAUTServerMessage;
import org.eclipse.jubula.tools.AUTIdentifier;
import org.eclipse.jubula.tools.internal.constants.EnvConstants;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.exception.JBVersionException;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.eclipse.jubula.tools.internal.utils.IsAliveThread;
import org.eclipse.jubula.tools.internal.utils.StringParsing;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutAgent {
    public static final int AUT_POST_DEREGISTRATION_DELAY_DEFAULT = 2000;
    public static final String AUT_POST_DEREGISTRATION_DELAY_VAR = "TEST_AUT_POST_DEREGISTRATION_DELAY";
    public static final String PROP_NAME_AUTS = "auts";
    public static final String PROP_KILL_DUPLICATE_AUTS = "killDuplicateAuts";
    private static final Logger LOG = LoggerFactory.getLogger(AutAgent.class);
    private ServerSocket m_serverSocket;
    private PropertyChangeSupport m_propertyChangeSupport;
    private Map<AutIdentifier, Communicator> m_auts = new HashMap<AutIdentifier, Communicator>();
    private boolean m_isRunning = true;
    private boolean m_killDuplicateAuts = true;
    private Map<AutIdentifier, IRestartAutHandler> m_autIdToRestartHandler = new HashMap<AutIdentifier, IRestartAutHandler>();
    private Map<String, IConnectionInitializer> m_connectionInitializers = new HashMap<String, IConnectionInitializer>();
    private Map<AutIdentifier, String> m_autToolkits = new LinkedHashMap<AutIdentifier, String>(5){

        @Override
        protected boolean removeEldestEntry(Map.Entry<AutIdentifier, String> eldest) {
            return this.size() > 10;
        }
    };

    public AutAgent() {
        this.m_propertyChangeSupport = new PropertyChangeSupport(this);
        this.initConnectionInitializers();
    }

    public AutAgent(int port) throws IOException {
        this.m_propertyChangeSupport = new PropertyChangeSupport(this);
        this.m_serverSocket = new ServerSocket(port);
        this.initConnectionInitializers();
    }

    private void initConnectionInitializers() {
        this.m_connectionInitializers.put("ClientType.Aut", new AutRegistrationInitializer());
        this.m_connectionInitializers.put("ClientType.autrun", new AutRunConnectionInitializer());
    }

    public int getPort() {
        return this.m_serverSocket.getLocalPort();
    }

    public void waitForConnections() throws IOException {
        while (this.m_isRunning) {
            try {
                Socket socket = this.m_serverSocket.accept();
                this.m_connectionInitializers.get("ClientType.Aut").initConnection(socket, new BufferedReader(new InputStreamReader(socket.getInputStream())));
            }
            catch (SocketException socketException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AutIdentifier> getAuts() {
        Map<AutIdentifier, Communicator> map = this.m_auts;
        synchronized (map) {
            return new HashSet<AutIdentifier>(this.m_auts.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addAut(AutIdentifier autId, Communicator autCommunicator) {
        boolean wasSetChanged = false;
        Map<AutIdentifier, Communicator> map = this.m_auts;
        synchronized (map) {
            if (this.m_isRunning) {
                boolean bl = wasSetChanged = !this.m_auts.containsKey(autId);
                if (wasSetChanged) {
                    this.m_auts.put(autId, autCommunicator);
                }
            }
        }
        if (wasSetChanged) {
            this.m_propertyChangeSupport.firePropertyChange(PROP_NAME_AUTS, null, autId);
        }
        return wasSetChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAut(AutIdentifier autId) {
        boolean wasSetChanged = false;
        Map<AutIdentifier, Communicator> map = this.m_auts;
        synchronized (map) {
            if (this.m_isRunning) {
                this.m_autIdToRestartHandler.remove(autId);
                Communicator autCommunicator = this.m_auts.remove(autId);
                if (autCommunicator != null) {
                    autCommunicator.prepareForConnectionProblems();
                    try {
                        autCommunicator.send((Message)new PrepareForShutdownMessage());
                    }
                    catch (CommunicationException e) {
                        LOG.info(e.getLocalizedMessage(), (Throwable)e);
                    }
                    autCommunicator.clearListeners();
                    autCommunicator.close();
                }
                wasSetChanged = autCommunicator != null;
            }
        }
        if (wasSetChanged) {
            this.m_propertyChangeSupport.firePropertyChange(PROP_NAME_AUTS, autId, null);
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.m_propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.m_propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Map<AutIdentifier, Communicator> map = this.m_auts;
        synchronized (map) {
            this.m_isRunning = false;
            try {
                if (this.m_serverSocket != null) {
                    this.m_serverSocket.close();
                }
            }
            catch (IOException iOException) {}
            this.m_auts = Collections.emptyMap();
        }
    }

    public static void main(String[] args) throws IOException {
        int port = 0;
        if (args.length > 0) {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Port argument '" + args[0] + "' is not an integer. A different port will be used.");
            }
        }
        AutAgent agent = new AutAgent(port);
        System.out.println("Agent started on port: " + agent.getPort());
        agent.addPropertyChangeListener(PROP_NAME_AUTS, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object oldValue;
                Object newValue = evt.getNewValue();
                if (newValue instanceof AutIdentifier) {
                    System.out.println("Registered AUT: " + ((AutIdentifier)newValue).getExecutableName());
                }
                if ((oldValue = evt.getOldValue()) instanceof AutIdentifier) {
                    System.out.println("Deregistered AUT: " + ((AutIdentifier)oldValue).getExecutableName());
                }
            }
        });
        agent.waitForConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAut(AutIdentifier autId, int timeout) {
        boolean force;
        boolean bl = force = timeout == 0;
        if (!force) {
            long startTime = System.currentTimeMillis();
            boolean timedOut = false;
            while (this.m_auts.containsKey(autId) && !timedOut) {
                timedOut = startTime + (long)timeout < System.currentTimeMillis();
                TimeUtil.delay((long)250L);
            }
            if (!timedOut) {
                TimeUtil.delayDefaultOrExternalTime((long)2000L, (String)AUT_POST_DEREGISTRATION_DELAY_VAR);
            } else {
                force = true;
            }
        }
        Map<AutIdentifier, Communicator> map = this.m_auts;
        synchronized (map) {
            Communicator autCommunicator = this.m_auts.get(autId);
            if (autCommunicator != null && force) {
                this.removeAut(autId);
            }
        }
    }

    public void restartAut(AutIdentifier autId, int timeout) {
        IRestartAutHandler message = this.m_autIdToRestartHandler.get(autId);
        message.restartAut(this, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartAutMessage(StartAUTServerMessage message) {
        Map autConfig = message.getAutConfiguration();
        String autExecName = (String)autConfig.get("AUT_ID");
        AutIdentifier autId = new AutIdentifier(autExecName);
        this.m_autToolkits.put(autId, message.getAutToolKit());
        Map<AutIdentifier, Communicator> map = this.m_auts;
        synchronized (map) {
            if (!this.m_auts.containsKey(autId)) {
                this.m_autIdToRestartHandler.put(autId, new RestartAutConfiguration(autId, message));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectToAutResponseMessage sendConnectToClientMessage(AutIdentifier autId, String clientHostName, int clientPort) {
        Map<AutIdentifier, Communicator> map = this.m_auts;
        synchronized (map) {
            Communicator autSocket = this.m_auts.get(autId);
            if (autSocket == null) {
                LOG.error(Messages.AutConnectionError);
                return new ConnectToAutResponseMessage(Messages.AutConnectionError);
            }
            try {
                HashMap<String, String> fragmentMap = new HashMap<String, String>();
                Map<AutIdentifier, IRestartAutHandler> map2 = this.m_autIdToRestartHandler;
                synchronized (map2) {
                    String startClass = this.m_autIdToRestartHandler.get(autId).getAUTStartClass();
                    Class<?> autServerClass = Class.forName(startClass);
                    AbstractStartToolkitAut autStarter = (AbstractStartToolkitAut)autServerClass.newInstance();
                    String rcBundleID = autStarter.getRcBundleId();
                    if ("org.eclipse.jubula.rc.javafx".equals(rcBundleID) || "org.eclipse.jubula.rc.swing".equals(rcBundleID) || "org.eclipse.jubula.rc.swt".equals(rcBundleID)) {
                        IAUTStartHelper autStartHelper = AutStartHelperRegister.INSTANCE.getAutStartHelper();
                        fragmentMap.putAll(autStartHelper.getFragmentPathforBundleID(rcBundleID));
                    }
                }
                autSocket.send((Message)new ConnectToClientMessage(clientHostName, clientPort, fragmentMap));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | CommunicationException ce) {
                LOG.error(ce.getLocalizedMessage(), ce);
                return new ConnectToAutResponseMessage(ce.getLocalizedMessage());
            }
            return new ConnectToAutResponseMessage(null);
        }
    }

    public Map<String, IConnectionInitializer> getConnectionInitializers() {
        return new HashMap<String, IConnectionInitializer>(this.m_connectionInitializers);
    }

    public void setKillDuplicateAuts(boolean killDuplicateAuts) {
        boolean oldValue = this.m_killDuplicateAuts;
        this.m_killDuplicateAuts = killDuplicateAuts;
        this.m_propertyChangeSupport.firePropertyChange(PROP_KILL_DUPLICATE_AUTS, oldValue, this.m_killDuplicateAuts);
    }

    public boolean isKillDuplicateAuts() {
        return this.m_killDuplicateAuts;
    }

    public Communicator getAutCommunicator(AUTIdentifier id) {
        return this.m_auts.get(id);
    }

    public String getToolkitForAutID(AutIdentifier connectedAutId) {
        String toolkit = this.m_autToolkits.get(connectedAutId);
        if (StringUtils.isBlank((String)toolkit)) {
            return this.getToolkitFromRestartHandler(connectedAutId);
        }
        return toolkit;
    }

    private String getToolkitFromRestartHandler(AutIdentifier autIdentifier) {
        IRestartAutHandler iRestartAutHandler = this.m_autIdToRestartHandler.get(autIdentifier);
        if (iRestartAutHandler != null) {
            String startCommand = iRestartAutHandler.getAUTStartClass();
            if (StringUtils.containsIgnoreCase((String)startCommand, (String)"swing")) {
                return "com.bredexsw.guidancer.SwingToolkitPlugin";
            }
            if (StringUtils.containsIgnoreCase((String)startCommand, (String)"swt")) {
                return "com.bredexsw.guidancer.SwtToolkitPlugin";
            }
            if (StringUtils.containsIgnoreCase((String)startCommand, (String)"rcp")) {
                return "com.bredexsw.guidancer.RcpToolkitPlugin";
            }
            if (StringUtils.containsIgnoreCase((String)startCommand, (String)"javafx")) {
                return "org.eclipse.jubula.JavaFXToolkitPlugin";
            }
            if (StringUtils.containsIgnoreCase((String)startCommand, (String)"html")) {
                return "com.bredexsw.guidancer.HtmlToolkitPlugin";
            }
        }
        return null;
    }

    private class AutCommunicationErrorListener
    implements ICommunicationErrorListener {
        private AutIdentifier m_autId;
        private Communicator m_autCommunicator;

        public AutCommunicationErrorListener(AutIdentifier autId, Communicator autCommunicator) {
            this.m_autId = autId;
            this.m_autCommunicator = autCommunicator;
        }

        public void shutDown() {
            AutAgent.this.removeAut(this.m_autId);
        }

        public void sendFailed(Message message) {
        }

        public void connectionGained(InetAddress inetAddress, int port) {
            boolean registeredAutSetWasModified = AutAgent.this.addAut(this.m_autId, this.m_autCommunicator);
            while (!registeredAutSetWasModified && !AutAgent.this.m_killDuplicateAuts) {
                this.m_autId = new AutIdentifier(StringParsing.incrementSequence((String)this.m_autId.getExecutableName()));
                registeredAutSetWasModified = AutAgent.this.addAut(this.m_autId, this.m_autCommunicator);
            }
            if (!registeredAutSetWasModified && AutAgent.this.m_killDuplicateAuts) {
                try {
                    this.m_autCommunicator.send((Message)new PrepareForShutdownMessage());
                }
                catch (CommunicationException e) {
                    LOG.info(e.getLocalizedMessage(), (Throwable)e);
                }
                this.m_autCommunicator.clearListeners();
                this.m_autCommunicator.close();
            }
        }

        public void connectingFailed(InetAddress inetAddress, int port) {
        }

        public void acceptingFailed(int port) {
        }
    }

    private class AutRegistrationInitializer
    implements IConnectionInitializer {
        private AutRegistrationInitializer() {
        }

        public void initConnection(final Socket socket, final BufferedReader reader) {
            new IsAliveThread("Register AUT"){

                public void run() {
                    try {
                        String autInfoLine = reader.readLine();
                        if (autInfoLine != null && autInfoLine.length() > 0) {
                            AutIdentifier autId = AutIdentifier.decode((String)autInfoLine);
                            Communicator autCommunicator = new Communicator(0, ((Object)((Object)this)).getClass().getClassLoader());
                            autCommunicator.addCommunicationErrorListener((ICommunicationErrorListener)new AutCommunicationErrorListener(autId, autCommunicator));
                            autCommunicator.run();
                            PrintStream printStream = new PrintStream(socket.getOutputStream());
                            printStream.println(EnvConstants.LOCALHOST_FQDN);
                            printStream.println(autCommunicator.getLocalPort());
                            printStream.flush();
                        } else {
                            LOG.debug("AUT did not send information and so will not be registered.");
                        }
                    }
                    catch (IOException ioe) {
                        LOG.error("Error occurred while establishing communication with AUT.", (Throwable)ioe);
                    }
                    catch (SecurityException se) {
                        LOG.error("Error occurred while establishing communication with AUT.", (Throwable)se);
                    }
                    catch (JBVersionException gdve) {
                        LOG.error("Error occurred while establishing communication with AUT.", (Throwable)gdve);
                    }
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }.start();
        }
    }

    private class AutRunConnectionInitializer
    implements IConnectionInitializer {
        private AutRunConnectionInitializer() {
        }

        public void initConnection(final Socket socket, final BufferedReader reader) {
            new IsAliveThread("Register autrun"){

                public void run() {
                    try {
                        String autID = reader.readLine();
                        String toolkit = reader.readLine();
                        if (autID != null && autID.length() > 0 && toolkit != null && toolkit.length() > 0) {
                            AutIdentifier autId = new AutIdentifier(autID);
                            AutAgent.this.m_autIdToRestartHandler.put(autId, new RestartAutAutRun(autId, socket, reader, toolkit));
                        }
                    }
                    catch (IOException ioe) {
                        LOG.error("Error occurred while establishing communication with autrun.", (Throwable)ioe);
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                    catch (SecurityException se) {
                        LOG.error("Error occurred while establishing communication with autrun.", (Throwable)se);
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }.start();
        }
    }
}

