/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Interface representing the TableComponentActionHandler component from the concrete toolkit.
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2018-09-11T11:29:09.150Z")
public interface TableComponentActionHandler extends org.eclipse.jubula.toolkit.base.components.handler.TextInputComponentActionHandler {
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * 
         */
        public Result inputTextSpecifyCell(
            @Nullable String text,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator
        ) ;
        
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * 
         */
        public Result replaceTextSpecifyCell(
            @Nullable String text,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator
        ) ;
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param numberOfClicks 
         *        the amount of interactions
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public Result selectCell(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Integer numberOfClicks,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable BinaryChoice extendSelection,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param direction 
         *        the direction
         * @param numberOfCells 
         *        the number of cells
         * @param numberOfClicks 
         *        the amount of interactions
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param extendSelection 
         *        whether to extend the selection or not
         * 
         */
        public Result move(
            @Nullable Direction direction,
            @Nullable Integer numberOfCells,
            @Nullable Integer numberOfClicks,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable BinaryChoice extendSelection
        ) ;
        
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkEditabilitySpecifyCell(
            @Nullable Boolean editable,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @since 4.1
         */
        public Result checkEditabilitySpecifyCell(
            @Nullable Boolean editable,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator
        ) ;
        
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkEditabilityOfSelectedCell(
            @Nullable Boolean editable,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @since 4.1
         */
        public Result checkEditabilityOfSelectedCell(
            @Nullable Boolean editable
        ) ;
        
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkEditabilityOfCellMousePosition(
            @Nullable Boolean editable,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @since 4.1
         */
        public Result checkEditabilityOfCellMousePosition(
            @Nullable Boolean editable
        ) ;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param textOperator 
         *        the text operator
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkTextSpecifyCell(
            @Nullable String text,
            @Nullable Operator textOperator,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param text 
         *        the text to use
         * @param textOperator 
         *        the text operator
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @since 4.1
         */
        public Result checkTextSpecifyCell(
            @Nullable String text,
            @Nullable Operator textOperator,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator
        ) ;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkTextMousePosition(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @since 4.1
         */
        public Result checkTextMousePosition(
            @Nullable String text,
            @Nullable Operator operator
        ) ;
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfValueInRow(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @since 4.1
         */
        public Result checkExistenceOfValueInRow(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Boolean exists
        ) ;
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfValueInColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @since 4.1
         */
        public Result checkExistenceOfValueInColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Boolean exists
        ) ;
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param numberOfClicks 
         *        the amount of interactions
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param searchType 
         *        the search type
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public Result selectValueFromColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable Integer numberOfClicks,
            @Nullable BinaryChoice extendSelection,
            @Nullable SearchType searchType,
            @Nullable InteractionMode mouseButton
        ) ;
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param numberOfClicks 
         *        the amount of interactions
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param searchType 
         *        the search type
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public Result selectValueFromRow(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable Integer numberOfClicks,
            @Nullable BinaryChoice extendSelection,
            @Nullable SearchType searchType,
            @Nullable InteractionMode mouseButton
        ) ;
        
        
        /**
         * CompSystem.ReadTableCellValueAPI.descr
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @since 4.0
         */
        public Result getValueSpecifyCell(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator
        ) ;
        
        
        /**
         * Use this action to read the value in the cell where the mouse is currently placed so that you can use the value in the cell as data for other Test Steps
         * @since 4.0
         */
        public Result getValueAtMousePosition(
        ) ;
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * 
         */
        public Result dragCell(
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits
        ) ;
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public Result dropOnCell(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable Integer delayBeforeDropMilliseconds
        ) ;
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * 
         */
        public Result dragCellFromColumn(
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType
        ) ;
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public Result dropOnCellFromColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Integer delayBeforeDropMilliseconds
        ) ;
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * 
         */
        public Result dragCellFromRow(
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType
        ) ;
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public Result dropOnCellFromRow(
            @Nullable String row,
            @Nullable Operator rowOperator,
            @Nullable String value,
            @Nullable Operator valueOperator,
            @Nullable SearchType searchType,
            @Nullable Integer delayBeforeDropMilliseconds
        ) ;
        
        /**
         * 
         * @param checked 
         *        Checked
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfCheckboxInSelectedRow(
            @Nullable Boolean checked,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param checked 
         *        Checked
         * @since 4.1
         */
        public Result checkSelectionOfCheckboxInSelectedRow(
            @Nullable Boolean checked
        ) ;
        
        /**
         * 
         * @param checked 
         *        Checked
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfCheckboxAtMousePosition(
            @Nullable Boolean checked,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param checked 
         *        Checked
         * @since 4.1
         */
        public Result checkSelectionOfCheckboxAtMousePosition(
            @Nullable Boolean checked
        ) ;
        
        /**
         * 
         * 
         */
        public Result toggleCheckboxInSelectedRow(
        ) ;
        
        /**
         * 
         * 
         */
        public Result toggleCheckboxAtMousePosition(
        ) ;
        
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkPropertyAtMousePosition(
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * @since 4.1
         */
        public Result checkPropertyAtMousePosition(
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator operator
        ) ;
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 5.0
         */
        public Result checkExistenceOfAColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param exists 
         *        whether existence is expected or not
         * @since 5.0
         */
        public Result checkExistenceOfAColumn(
            @Nullable String column,
            @Nullable Operator columnOperator,
            @Nullable Boolean exists
        ) ;
        
} 