/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.internal;

import java.io.IOException;
import org.eclipse.jubula.client.internal.BaseConnection;
import org.eclipse.jubula.client.internal.commands.GetKeyboardLayoutNameResponseCommand;
import org.eclipse.jubula.client.internal.exceptions.ConnectionException;
import org.eclipse.jubula.communication.internal.Communicator;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.message.GetKeyboardLayoutNameMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseAUTConnection
extends BaseConnection {
    public static final int CONNECT_TO_AUT_TIMEOUT = 10000;
    static final Logger LOG = LoggerFactory.getLogger(BaseAUTConnection.class);
    private AutIdentifier m_connectedAutId;

    public BaseAUTConnection() {
    }

    public BaseAUTConnection(int port) throws ConnectionException {
        try {
            Communicator communicator = new Communicator(port, this.getClass().getClassLoader());
            communicator.setIsServerSocketClosable(false);
            this.setCommunicator(communicator);
        }
        catch (IOException ioe) {
            this.handleInitError(ioe);
        }
        catch (SecurityException se) {
            this.handleInitError(se);
        }
    }

    private void handleInitError(Throwable throwable) throws ConnectionException {
        String message = "Initialisation of AUTConnection failed: ";
        LOG.error(message, throwable);
        throw new ConnectionException(String.valueOf(message) + throwable.getMessage(), MessageIDs.E_AUT_CONNECTION_INIT);
    }

    public AutIdentifier getConnectedAutId() {
        return this.m_connectedAutId;
    }

    protected void disconnectFromAut() {
        this.setConnectedAutId(null);
    }

    protected void setConnectedAutId(AutIdentifier connectedAutId) {
        this.m_connectedAutId = connectedAutId;
    }

    public synchronized void reset() {
        Communicator communicator = this.getCommunicator();
        if (communicator != null) {
            communicator.setIsServerSocketClosable(true);
            communicator.interruptAllTimeouts();
            communicator.clearListeners();
            communicator.close();
        }
    }

    protected void sendKeyboardLayoutToAut() throws BaseConnection.NotConnectedException, ConnectionException, CommunicationException {
        GetKeyboardLayoutNameMessage request = new GetKeyboardLayoutNameMessage();
        GetKeyboardLayoutNameResponseCommand response = new GetKeyboardLayoutNameResponseCommand(this);
        this.request((Message)request, (ICommand)response, 10000);
    }
}

