/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.swt.components.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Interface representing the {@link org.eclipse.swt.widgets.Tree} component from the swt toolkit.
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.1
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2018-10-09T12:21:27.230Z")
public interface TreeTableActionHandler extends org.eclipse.jubula.toolkit.concrete.components.handler.TreeTableComponentActionHandler {
    
    
        /**
         * 
         * @param checked 
         *        Checked
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfCheckboxOnSelectedNode(
            @Nullable Boolean checked,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param checked 
         *        Checked
         * @since 4.1
         */
        public Result checkSelectionOfCheckboxOnSelectedNode(
            @Nullable Boolean checked
        ) ;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * 
         */
        public Result toggleCheckboxOnNodeByTextpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator
        ) ;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * 
         */
        public Result toggleCheckboxOnNodeByIndexpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath
        ) ;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param checked 
         *        Checked
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfCheckboxByTextpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean checked,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param checked 
         *        Checked
         * @since 4.1
         */
        public Result checkSelectionOfCheckboxByTextpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean checked
        ) ;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param checked 
         *        Checked
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfCheckboxByIndexpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath,
            @Nullable Boolean checked,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param checked 
         *        Checked
         * @since 4.1
         */
        public Result checkSelectionOfCheckboxByIndexpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath,
            @Nullable Boolean checked
        ) ;
        
} 