/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * Interface representing the TreeTableComponent component from the concrete toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 5.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2019-01-15T09:43:59.287Z")
public interface TreeTableComponent extends org.eclipse.jubula.toolkit.concrete.components.TreeComponent {
    
    
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfAColumn(@NonNull String column,@NonNull Operator columnOperator,@NonNull Boolean exists,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param exists 
         *        whether existence is expected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfAColumn(@NonNull String column,@NonNull Operator columnOperator,@NonNull Boolean exists
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @param column 
         *        the column
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectEntryByTextpathSpecifyColumn(@NonNull SearchType pathType,@NonNull Integer preAscend,@NonNull String textpath,@NonNull Operator operator,@NonNull Integer numberOfClicks,@NonNull Integer column,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param numberOfClicks 
         *        the amount of interactions
         * @param column 
         *        the column
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectEntryByIndexpathSpecifyColumn(@NonNull SearchType pathType,@NonNull Integer preAscend,@NonNull String indexpath,@NonNull Integer numberOfClicks,@NonNull Integer column,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param column 
         *        the column
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP checkSelectionByValueSSpecifyColumn(@NonNull String text,@NonNull Operator operator,@NonNull Integer column,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param column 
         *        the column
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP checkSelectionByValueSSpecifyColumn(@NonNull String text,@NonNull Operator operator,@NonNull Integer column
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @param column 
         *        the column
         * @param columnOperator 
         *        the operator used for comparison
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP selectEntryByTextpathSpecifyColumnPath(@NonNull SearchType pathType,@NonNull Integer preAscend,@NonNull String textpath,@NonNull Operator operator,@NonNull Integer numberOfClicks,@NonNull String column,@NonNull Operator columnOperator,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param numberOfClicks 
         *        the amount of interactions
         * @param column 
         *        the column
         * @param operator 
         *        the operator used for comparison
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP selectEntryByIndexpathSpecifyColumnPath(@NonNull SearchType pathType,@NonNull Integer preAscend,@NonNull String indexpath,@NonNull Integer numberOfClicks,@NonNull String column,@NonNull Operator operator,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param column 
         *        the column
         * @param columnOperator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionByValueSSpecifyColumnPath(@NonNull String text,@NonNull Operator operator,@NonNull String column,@NonNull Operator columnOperator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param column 
         *        the column
         * @param columnOperator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionByValueSSpecifyColumnPath(@NonNull String text,@NonNull Operator operator,@NonNull String column,@NonNull Operator columnOperator
        ) throws IllegalArgumentException;
        
        /**
         * Use this action to check the text in a cell based on the current position of the cursor
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkTextOfCellMousePosition(@NonNull String text,@NonNull Operator operator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * Use this action to check the text in a cell based on the current position of the cursor
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkTextOfCellMousePosition(@NonNull String text,@NonNull Operator operator
        ) throws IllegalArgumentException;
        
        
        /**
         * Use this action to read the value in the cell where the mouse is currently placed so that you can use the value in the cell as data for other Test Steps
         * @since 4.1
         */
        @NonNull public CAP getValueAtMousePosition(
        ) ;
        
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEditabilitySpecifyCell(@NonNull Boolean editable,@NonNull String row,@NonNull Operator rowOperator,@NonNull String column,@NonNull Operator columnOperator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * 
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEditabilitySpecifyCell(@NonNull Boolean editable,@NonNull String row,@NonNull Operator rowOperator,@NonNull String column,@NonNull Operator columnOperator
        ) throws IllegalArgumentException;
        
        /**
         * Use this action to check whether a cell at the current mouse position is editable or not
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEditabilityOfCellMousePosition(@NonNull Boolean editable,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * Use this action to check whether a cell at the current mouse position is editable or not
         * @param editable 
         *        whether the component is expected to be editable or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEditabilityOfCellMousePosition(@NonNull Boolean editable
        ) throws IllegalArgumentException;
        
        /**
         * Use this action to check whether the currently selected cell is editable or not
         * @param editable 
         *        whether the component is expected to be editable or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEditabilityOfSelectedCell(@NonNull Boolean editable,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * Use this action to check whether the currently selected cell is editable or not
         * @param editable 
         *        whether the component is expected to be editable or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEditabilityOfSelectedCell(@NonNull Boolean editable
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfValueInRow(@NonNull String row,@NonNull Operator rowOperator,@NonNull String value,@NonNull Operator valueOperator,@NonNull SearchType searchType,@NonNull Boolean exists,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfValueInRow(@NonNull String row,@NonNull Operator rowOperator,@NonNull String value,@NonNull Operator valueOperator,@NonNull SearchType searchType,@NonNull Boolean exists
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfValueInColumn(@NonNull String column,@NonNull Operator columnOperator,@NonNull String value,@NonNull Operator valueOperator,@NonNull SearchType searchType,@NonNull Boolean exists,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param searchType 
         *        the search type
         * @param exists 
         *        whether existence is expected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfValueInColumn(@NonNull String column,@NonNull Operator columnOperator,@NonNull String value,@NonNull Operator valueOperator,@NonNull SearchType searchType,@NonNull Boolean exists
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param textOperator 
         *        the text operator
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkTextSpecifyCell(@NonNull String text,@NonNull Operator textOperator,@NonNull String row,@NonNull Operator rowOperator,@NonNull String column,@NonNull Operator columnOperator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * 
         * @param text 
         *        the text to use
         * @param textOperator 
         *        the text operator
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkTextSpecifyCell(@NonNull String text,@NonNull Operator textOperator,@NonNull String row,@NonNull Operator rowOperator,@NonNull String column,@NonNull Operator columnOperator
        ) throws IllegalArgumentException;
        
        
        /**
         * Use this action to read the value of the specified cell so that you can use the value in the cell as data for other Test Steps
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP getValueSpecifyCell(@NonNull String row,@NonNull Operator rowOperator,@NonNull String column,@NonNull Operator columnOperator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param numberOfClicks 
         *        the amount of interactions
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP selectCell(@NonNull String row,@NonNull Operator rowOperator,@NonNull String column,@NonNull Operator columnOperator,@NonNull Integer numberOfClicks,@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits,@NonNull BinaryChoice extendSelection,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param column 
         *        the column
         * @param columnOperator 
         *        the column operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param numberOfClicks 
         *        the amount of interactions
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param searchType 
         *        the search type
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP selectValueFromColumn(@NonNull String column,@NonNull Operator columnOperator,@NonNull String value,@NonNull Operator valueOperator,@NonNull Integer numberOfClicks,@NonNull BinaryChoice extendSelection,@NonNull SearchType searchType,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param row 
         *        the row
         * @param rowOperator 
         *        the row operator
         * @param value 
         *        the cell value
         * @param valueOperator 
         *        the operator used to compare the values
         * @param numberOfClicks 
         *        the amount of interactions
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param searchType 
         *        the search type
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP selectValueFromRow(@NonNull String row,@NonNull Operator rowOperator,@NonNull String value,@NonNull Operator valueOperator,@NonNull Integer numberOfClicks,@NonNull BinaryChoice extendSelection,@NonNull SearchType searchType,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException;
        
} 