/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.gef.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the {@link org.eclipse.draw2d.FigureCanvas} component from the gef toolkit.
 * 
 */
@RealizedType(realizedType="guidancer.abstract.Widget")
@TesterClass(testerClass="org.eclipse.jubula.rc.rcp.e3.gef.tester.FigureCanvasTester")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2019-01-15T09:43:59.143Z")
public class FigureCanvas extends org.eclipse.jubula.toolkit.base.internal.impl.GraphicsComponent implements org.eclipse.jubula.toolkit.gef.components.FigureCanvas {
            public FigureCanvas(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkFigureExistence(@NonNull String textpath,@NonNull Operator operator,@NonNull Boolean exists,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckFigureExists")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(exists)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkFigureExistence(@NonNull String textpath,@NonNull Operator operator,@NonNull Boolean exists
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckFigureExists")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(exists)
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkToolExistence(@NonNull String textpath,@NonNull Operator operator,@NonNull Boolean exists,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckToolExists")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(exists)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkToolExistence(@NonNull String textpath,@NonNull Operator operator,@NonNull Boolean exists
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckToolExists")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(exists)
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP clickFigure(@NonNull String textpath,@NonNull Operator operator,@NonNull Integer numberOfClicks,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcClickFigure")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(numberOfClicks)
                        .addParameter(mouseButton.rcIntValue())
                        .build();
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP clickInFigure(@NonNull String textpath,@NonNull Operator operator,@NonNull Integer numberOfClicks,@NonNull InteractionMode mouseButton,@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcClickInFigure")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(numberOfClicks)
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .build();
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectTool(@NonNull String textpath,@NonNull Operator operator,@NonNull Integer numberOfClicks
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcSelectTool")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(numberOfClicks)
                        .build();
        }
        
        /**
         * 
         * @param sourceTextPath 
         *        the text path used for the source
         * @param sourceOperator 
         *        the operator used for the source
         * @param targetTextPath 
         *        the text path used for the target
         * @param targetOperator 
         *        the operator used for the target
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.0
         */
        @NonNull public CAP clickConnection(@NonNull String sourceTextPath,@NonNull Operator sourceOperator,@NonNull String targetTextPath,@NonNull Operator targetOperator,@NonNull Integer numberOfClicks,@NonNull InteractionMode mouseButton
        ) throws IllegalArgumentException {
            Validate.notNull(sourceTextPath, "Argument 'sourceTextPath' must not be null"); //$NON-NLS-1$
            Validate.notNull(sourceOperator, "Argument 'sourceOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(targetTextPath, "Argument 'targetTextPath' must not be null"); //$NON-NLS-1$
            Validate.notNull(targetOperator, "Argument 'targetOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(numberOfClicks, "Argument 'numberOfClicks' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcClickConnection")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(sourceTextPath)
                        .addParameter(sourceOperator.rcValue())
                        .addParameter(targetTextPath)
                        .addParameter(targetOperator.rcValue())
                        .addParameter(numberOfClicks)
                        .addParameter(mouseButton.rcIntValue())
                        .build();
        }
        
        /**
         * 
         * @param sourceTextPath 
         *        the text path used for the source
         * @param sourceOperator 
         *        the operator used for the source
         * @param targetTextPath 
         *        the text path used for the target
         * @param targetOperator 
         *        the operator used for the target
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkConnectionExistence(@NonNull String sourceTextPath,@NonNull Operator sourceOperator,@NonNull String targetTextPath,@NonNull Operator targetOperator,@NonNull Boolean exists,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(sourceTextPath, "Argument 'sourceTextPath' must not be null"); //$NON-NLS-1$
            Validate.notNull(sourceOperator, "Argument 'sourceOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(targetTextPath, "Argument 'targetTextPath' must not be null"); //$NON-NLS-1$
            Validate.notNull(targetOperator, "Argument 'targetOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckConnectionExists")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(sourceTextPath)
                        .addParameter(sourceOperator.rcValue())
                        .addParameter(targetTextPath)
                        .addParameter(targetOperator.rcValue())
                        .addParameter(exists)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param sourceTextPath 
         *        the text path used for the source
         * @param sourceOperator 
         *        the operator used for the source
         * @param targetTextPath 
         *        the text path used for the target
         * @param targetOperator 
         *        the operator used for the target
         * @param exists 
         *        whether existence is expected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkConnectionExistence(@NonNull String sourceTextPath,@NonNull Operator sourceOperator,@NonNull String targetTextPath,@NonNull Operator targetOperator,@NonNull Boolean exists
        ) throws IllegalArgumentException {
            Validate.notNull(sourceTextPath, "Argument 'sourceTextPath' must not be null"); //$NON-NLS-1$
            Validate.notNull(sourceOperator, "Argument 'sourceOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(targetTextPath, "Argument 'targetTextPath' must not be null"); //$NON-NLS-1$
            Validate.notNull(targetOperator, "Argument 'targetOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckConnectionExists")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(sourceTextPath)
                        .addParameter(sourceOperator.rcValue())
                        .addParameter(targetTextPath)
                        .addParameter(targetOperator.rcValue())
                        .addParameter(exists)
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP dragFigure(@NonNull String textpath,@NonNull Operator operator,@NonNull InteractionMode mouseButton,@NonNull Modifier[] modifierKeys,@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(mouseButton, "Argument 'mouseButton' must not be null"); //$NON-NLS-1$
            Validate.notNull(modifierKeys, "Argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.noNullElements(modifierKeys, "Elements of argument 'modifierKeys' must not be null"); //$NON-NLS-1$
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcDragFigure")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(mouseButton.rcIntValue())
                        .addParameter(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR))
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .build();
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP dropOnFigure(@NonNull String textpath,@NonNull Operator operator,@NonNull Integer xPosition,@NonNull Unit xUnits,@NonNull Integer yPosition,@NonNull Unit yUnits,@NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(xPosition, "Argument 'xPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(xUnits, "Argument 'xUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(yPosition, "Argument 'yPosition' must not be null"); //$NON-NLS-1$
            Validate.notNull(yUnits, "Argument 'yUnits' must not be null"); //$NON-NLS-1$
            Validate.notNull(delayBeforeDropMilliseconds, "Argument 'delayBeforeDropMilliseconds' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcDropOnFigure")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(xPosition)
                        .addParameter(xUnits.rcValue())
                        .addParameter(yPosition)
                        .addParameter(yUnits.rcValue())
                        .addParameter(delayBeforeDropMilliseconds)
                        .build();
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param textOperator 
         *        the text operator
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param valueOperator 
         *        the operator used to compare the values
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkFigureProperty(@NonNull String textpath,@NonNull Operator textOperator,@NonNull String propertyName,@NonNull String propertyValue,@NonNull Operator valueOperator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(textOperator, "Argument 'textOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(propertyName, "Argument 'propertyName' must not be null"); //$NON-NLS-1$
            Validate.notNull(propertyValue, "Argument 'propertyValue' must not be null"); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyFigureProperty")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(textOperator.rcValue())
                        .addParameter(propertyName)
                        .addParameter(propertyValue)
                        .addParameter(valueOperator.rcValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param textOperator 
         *        the text operator
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param valueOperator 
         *        the operator used to compare the values
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkFigureProperty(@NonNull String textpath,@NonNull Operator textOperator,@NonNull String propertyName,@NonNull String propertyValue,@NonNull Operator valueOperator
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(textOperator, "Argument 'textOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(propertyName, "Argument 'propertyName' must not be null"); //$NON-NLS-1$
            Validate.notNull(propertyValue, "Argument 'propertyValue' must not be null"); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyFigureProperty")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(textOperator.rcValue())
                        .addParameter(propertyName)
                        .addParameter(propertyValue)
                        .addParameter(valueOperator.rcValue())
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param textOperator 
         *        the text operator
         * @param anchorType 
         *        the anchor type
         * @param numberOfAnchors 
         *        Number of Anchors
         * @param comparisonMethod 
         *        the comparison method
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkAnchorCount(@NonNull String textpath,@NonNull Operator textOperator,@NonNull AnchorType anchorType,@NonNull Integer numberOfAnchors,@NonNull NumberComparisonOperator comparisonMethod,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(textOperator, "Argument 'textOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(anchorType, "Argument 'anchorType' must not be null"); //$NON-NLS-1$
            Validate.notNull(numberOfAnchors, "Argument 'numberOfAnchors' must not be null"); //$NON-NLS-1$
            Validate.notNull(comparisonMethod, "Argument 'comparisonMethod' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckNumberOfAnchors")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(textOperator.rcValue())
                        .addParameter(anchorType.rcValue())
                        .addParameter(numberOfAnchors)
                        .addParameter(comparisonMethod.rcValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param textOperator 
         *        the text operator
         * @param anchorType 
         *        the anchor type
         * @param numberOfAnchors 
         *        Number of Anchors
         * @param comparisonMethod 
         *        the comparison method
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkAnchorCount(@NonNull String textpath,@NonNull Operator textOperator,@NonNull AnchorType anchorType,@NonNull Integer numberOfAnchors,@NonNull NumberComparisonOperator comparisonMethod
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(textOperator, "Argument 'textOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(anchorType, "Argument 'anchorType' must not be null"); //$NON-NLS-1$
            Validate.notNull(numberOfAnchors, "Argument 'numberOfAnchors' must not be null"); //$NON-NLS-1$
            Validate.notNull(comparisonMethod, "Argument 'comparisonMethod' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckNumberOfAnchors")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(textOperator.rcValue())
                        .addParameter(anchorType.rcValue())
                        .addParameter(numberOfAnchors)
                        .addParameter(comparisonMethod.rcValue())
                        .addParameter(0)
                        .build();
        }
        
        /**
         * Verifies if an anchor has a connection or not
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param hasConnection 
         *        whether a connection is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkAnchorHasConnection(@NonNull String textpath,@NonNull Operator operator,@NonNull Boolean hasConnection,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(hasConnection, "Argument 'hasConnection' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckAnchorConnection")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(hasConnection)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * Verifies if an anchor has a connection or not
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param hasConnection 
         *        whether a connection is expected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkAnchorHasConnection(@NonNull String textpath,@NonNull Operator operator,@NonNull Boolean hasConnection
        ) throws IllegalArgumentException {
            Validate.notNull(textpath, "Argument 'textpath' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(hasConnection, "Argument 'hasConnection' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcCheckAnchorConnection")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(textpath)
                        .addParameter(operator.rcValue())
                        .addParameter(hasConnection)
                        .addParameter(0)
                        .build();
        }
        
        /**
         * Checks a property from a Figure in a ConnectionEditPart
         * @param sourceTextPath 
         *        the text path used for the source
         * @param sourceOperator 
         *        the operator used for the source
         * @param targetTextPath 
         *        the text path used for the target
         * @param targetOperator 
         *        the operator used for the target
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param valueOperator 
         *        the operator used to compare the values
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkConnectionFigureProperty(@NonNull String sourceTextPath,@NonNull Operator sourceOperator,@NonNull String targetTextPath,@NonNull Operator targetOperator,@NonNull String propertyName,@NonNull String propertyValue,@NonNull Operator valueOperator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(sourceTextPath, "Argument 'sourceTextPath' must not be null"); //$NON-NLS-1$
            Validate.notNull(sourceOperator, "Argument 'sourceOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(targetTextPath, "Argument 'targetTextPath' must not be null"); //$NON-NLS-1$
            Validate.notNull(targetOperator, "Argument 'targetOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(propertyName, "Argument 'propertyName' must not be null"); //$NON-NLS-1$
            Validate.notNull(propertyValue, "Argument 'propertyValue' must not be null"); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyConnectionProperty")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(sourceTextPath)
                        .addParameter(sourceOperator.rcValue())
                        .addParameter(targetTextPath)
                        .addParameter(targetOperator.rcValue())
                        .addParameter(propertyName)
                        .addParameter(propertyValue)
                        .addParameter(valueOperator.rcValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * Checks a property from a Figure in a ConnectionEditPart
         * @param sourceTextPath 
         *        the text path used for the source
         * @param sourceOperator 
         *        the operator used for the source
         * @param targetTextPath 
         *        the text path used for the target
         * @param targetOperator 
         *        the operator used for the target
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param valueOperator 
         *        the operator used to compare the values
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkConnectionFigureProperty(@NonNull String sourceTextPath,@NonNull Operator sourceOperator,@NonNull String targetTextPath,@NonNull Operator targetOperator,@NonNull String propertyName,@NonNull String propertyValue,@NonNull Operator valueOperator
        ) throws IllegalArgumentException {
            Validate.notNull(sourceTextPath, "Argument 'sourceTextPath' must not be null"); //$NON-NLS-1$
            Validate.notNull(sourceOperator, "Argument 'sourceOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(targetTextPath, "Argument 'targetTextPath' must not be null"); //$NON-NLS-1$
            Validate.notNull(targetOperator, "Argument 'targetOperator' must not be null"); //$NON-NLS-1$
            Validate.notNull(propertyName, "Argument 'propertyName' must not be null"); //$NON-NLS-1$
            Validate.notNull(propertyValue, "Argument 'propertyValue' must not be null"); //$NON-NLS-1$
            Validate.notNull(valueOperator, "Argument 'valueOperator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyConnectionProperty")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(sourceTextPath)
                        .addParameter(sourceOperator.rcValue())
                        .addParameter(targetTextPath)
                        .addParameter(targetOperator.rcValue())
                        .addParameter(propertyName)
                        .addParameter(propertyValue)
                        .addParameter(valueOperator.rcValue())
                        .addParameter(0)
                        .build();
        }
        
} 