/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.gef.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the {@link org.eclipse.draw2d.FigureCanvas} component from the gef toolkit.
 * @since 4.0
 */
@RealizedType(realizedType="guidancer.abstract.Widget")
@TesterClass(testerClass="org.eclipse.jubula.rc.rcp.e3.gef.tester.FigureCanvasTester")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2019-01-15T09:43:59.155Z")
public class FigureCanvasActionHandler extends org.eclipse.jubula.toolkit.base.internal.impl.handler.GraphicsComponentActionHandler implements org.eclipse.jubula.toolkit.gef.components.handler.FigureCanvasActionHandler {
            public FigureCanvasActionHandler(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkFigureExistence(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        )  {
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (exists == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckFigureExists")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(exists)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @since 4.1
         */
        public Result checkFigureExistence(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean exists
        )  {
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (exists == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckFigureExists")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(exists)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkToolExistence(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        )  {
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (exists == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckToolExists")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(exists)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @since 4.1
         */
        public Result checkToolExistence(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean exists
        )  {
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (exists == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckToolExists")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(exists)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * 
         */
        public Result clickFigure(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Integer numberOfClicks,
            @Nullable InteractionMode mouseButton
        )  {
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (numberOfClicks == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcClickFigure")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(numberOfClicks)
                            .addParameter(mouseButton.rcIntValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * 
         */
        public Result clickInFigure(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Integer numberOfClicks,
            @Nullable InteractionMode mouseButton,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits
        )  {
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (numberOfClicks == null) return null;
            
            if (mouseButton == null) return null;
            
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcClickInFigure")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(numberOfClicks)
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * 
         */
        public Result selectTool(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Integer numberOfClicks
        )  {
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (numberOfClicks == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcSelectTool")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(numberOfClicks)
                            .build(), null);
        }
        
        /**
         * 
         * @param sourceTextPath 
         *        the text path used for the source
         * @param sourceOperator 
         *        the operator used for the source
         * @param targetTextPath 
         *        the text path used for the target
         * @param targetOperator 
         *        the operator used for the target
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @since 4.0
         */
        public Result clickConnection(
            @Nullable String sourceTextPath,
            @Nullable Operator sourceOperator,
            @Nullable String targetTextPath,
            @Nullable Operator targetOperator,
            @Nullable Integer numberOfClicks,
            @Nullable InteractionMode mouseButton
        )  {
            if (sourceTextPath == null) return null;
            
            if (sourceOperator == null) return null;
            
            if (targetTextPath == null) return null;
            
            if (targetOperator == null) return null;
            
            if (numberOfClicks == null) return null;
            
            if (mouseButton == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcClickConnection")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(sourceTextPath)
                            .addParameter(sourceOperator.rcValue())
                            .addParameter(targetTextPath)
                            .addParameter(targetOperator.rcValue())
                            .addParameter(numberOfClicks)
                            .addParameter(mouseButton.rcIntValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param sourceTextPath 
         *        the text path used for the source
         * @param sourceOperator 
         *        the operator used for the source
         * @param targetTextPath 
         *        the text path used for the target
         * @param targetOperator 
         *        the operator used for the target
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkConnectionExistence(
            @Nullable String sourceTextPath,
            @Nullable Operator sourceOperator,
            @Nullable String targetTextPath,
            @Nullable Operator targetOperator,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        )  {
            if (sourceTextPath == null) return null;
            
            if (sourceOperator == null) return null;
            
            if (targetTextPath == null) return null;
            
            if (targetOperator == null) return null;
            
            if (exists == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckConnectionExists")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(sourceTextPath)
                            .addParameter(sourceOperator.rcValue())
                            .addParameter(targetTextPath)
                            .addParameter(targetOperator.rcValue())
                            .addParameter(exists)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param sourceTextPath 
         *        the text path used for the source
         * @param sourceOperator 
         *        the operator used for the source
         * @param targetTextPath 
         *        the text path used for the target
         * @param targetOperator 
         *        the operator used for the target
         * @param exists 
         *        whether existence is expected or not
         * @since 4.1
         */
        public Result checkConnectionExistence(
            @Nullable String sourceTextPath,
            @Nullable Operator sourceOperator,
            @Nullable String targetTextPath,
            @Nullable Operator targetOperator,
            @Nullable Boolean exists
        )  {
            if (sourceTextPath == null) return null;
            
            if (sourceOperator == null) return null;
            
            if (targetTextPath == null) return null;
            
            if (targetOperator == null) return null;
            
            if (exists == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckConnectionExists")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(sourceTextPath)
                            .addParameter(sourceOperator.rcValue())
                            .addParameter(targetTextPath)
                            .addParameter(targetOperator.rcValue())
                            .addParameter(exists)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * 
         */
        public Result dragFigure(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits
        )  {
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (mouseButton == null) return null;
            
            if (modifierKeys == null) return null;
            
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcDragFigure")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(mouseButton.rcIntValue())
                            .addParameter(StringUtils.join(modifierKeys, TestDataConstants.COMBI_VALUE_SEPARATOR))
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param xPosition 
         *        the x-position
         * @param xUnits 
         *        the unit of the x-position
         * @param yPosition 
         *        the y-position
         * @param yUnits 
         *        the unit of the y-position
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public Result dropOnFigure(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Integer xPosition,
            @Nullable Unit xUnits,
            @Nullable Integer yPosition,
            @Nullable Unit yUnits,
            @Nullable Integer delayBeforeDropMilliseconds
        )  {
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (xPosition == null) return null;
            
            if (xUnits == null) return null;
            
            if (yPosition == null) return null;
            
            if (yUnits == null) return null;
            
            if (delayBeforeDropMilliseconds == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcDropOnFigure")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(xPosition)
                            .addParameter(xUnits.rcValue())
                            .addParameter(yPosition)
                            .addParameter(yUnits.rcValue())
                            .addParameter(delayBeforeDropMilliseconds)
                            .build(), null);
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param textOperator 
         *        the text operator
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param valueOperator 
         *        the operator used to compare the values
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkFigureProperty(
            @Nullable String textpath,
            @Nullable Operator textOperator,
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator valueOperator,
            @Nullable Integer timeoutInMs
        )  {
            if (textpath == null) return null;
            
            if (textOperator == null) return null;
            
            if (propertyName == null) return null;
            
            if (propertyValue == null) return null;
            
            if (valueOperator == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyFigureProperty")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(textOperator.rcValue())
                            .addParameter(propertyName)
                            .addParameter(propertyValue)
                            .addParameter(valueOperator.rcValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param textOperator 
         *        the text operator
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param valueOperator 
         *        the operator used to compare the values
         * @since 4.1
         */
        public Result checkFigureProperty(
            @Nullable String textpath,
            @Nullable Operator textOperator,
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator valueOperator
        )  {
            if (textpath == null) return null;
            
            if (textOperator == null) return null;
            
            if (propertyName == null) return null;
            
            if (propertyValue == null) return null;
            
            if (valueOperator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyFigureProperty")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(textOperator.rcValue())
                            .addParameter(propertyName)
                            .addParameter(propertyValue)
                            .addParameter(valueOperator.rcValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param textOperator 
         *        the text operator
         * @param anchorType 
         *        the anchor type
         * @param numberOfAnchors 
         *        Number of Anchors
         * @param comparisonMethod 
         *        the comparison method
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkAnchorCount(
            @Nullable String textpath,
            @Nullable Operator textOperator,
            @Nullable AnchorType anchorType,
            @Nullable Integer numberOfAnchors,
            @Nullable NumberComparisonOperator comparisonMethod,
            @Nullable Integer timeoutInMs
        )  {
            if (textpath == null) return null;
            
            if (textOperator == null) return null;
            
            if (anchorType == null) return null;
            
            if (numberOfAnchors == null) return null;
            
            if (comparisonMethod == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckNumberOfAnchors")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(textOperator.rcValue())
                            .addParameter(anchorType.rcValue())
                            .addParameter(numberOfAnchors)
                            .addParameter(comparisonMethod.rcValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param textpath 
         *        the textpath to use
         * @param textOperator 
         *        the text operator
         * @param anchorType 
         *        the anchor type
         * @param numberOfAnchors 
         *        Number of Anchors
         * @param comparisonMethod 
         *        the comparison method
         * @since 4.1
         */
        public Result checkAnchorCount(
            @Nullable String textpath,
            @Nullable Operator textOperator,
            @Nullable AnchorType anchorType,
            @Nullable Integer numberOfAnchors,
            @Nullable NumberComparisonOperator comparisonMethod
        )  {
            if (textpath == null) return null;
            
            if (textOperator == null) return null;
            
            if (anchorType == null) return null;
            
            if (numberOfAnchors == null) return null;
            
            if (comparisonMethod == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckNumberOfAnchors")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(textOperator.rcValue())
                            .addParameter(anchorType.rcValue())
                            .addParameter(numberOfAnchors)
                            .addParameter(comparisonMethod.rcValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * Verifies if an anchor has a connection or not
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param hasConnection 
         *        whether a connection is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkAnchorHasConnection(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean hasConnection,
            @Nullable Integer timeoutInMs
        )  {
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (hasConnection == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckAnchorConnection")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(hasConnection)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * Verifies if an anchor has a connection or not
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param hasConnection 
         *        whether a connection is expected or not
         * @since 4.1
         */
        public Result checkAnchorHasConnection(
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean hasConnection
        )  {
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (hasConnection == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcCheckAnchorConnection")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(hasConnection)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * Checks a property from a Figure in a ConnectionEditPart
         * @param sourceTextPath 
         *        the text path used for the source
         * @param sourceOperator 
         *        the operator used for the source
         * @param targetTextPath 
         *        the text path used for the target
         * @param targetOperator 
         *        the operator used for the target
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param valueOperator 
         *        the operator used to compare the values
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkConnectionFigureProperty(
            @Nullable String sourceTextPath,
            @Nullable Operator sourceOperator,
            @Nullable String targetTextPath,
            @Nullable Operator targetOperator,
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator valueOperator,
            @Nullable Integer timeoutInMs
        )  {
            if (sourceTextPath == null) return null;
            
            if (sourceOperator == null) return null;
            
            if (targetTextPath == null) return null;
            
            if (targetOperator == null) return null;
            
            if (propertyName == null) return null;
            
            if (propertyValue == null) return null;
            
            if (valueOperator == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyConnectionProperty")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(sourceTextPath)
                            .addParameter(sourceOperator.rcValue())
                            .addParameter(targetTextPath)
                            .addParameter(targetOperator.rcValue())
                            .addParameter(propertyName)
                            .addParameter(propertyValue)
                            .addParameter(valueOperator.rcValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * Checks a property from a Figure in a ConnectionEditPart
         * @param sourceTextPath 
         *        the text path used for the source
         * @param sourceOperator 
         *        the operator used for the source
         * @param targetTextPath 
         *        the text path used for the target
         * @param targetOperator 
         *        the operator used for the target
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param valueOperator 
         *        the operator used to compare the values
         * @since 4.1
         */
        public Result checkConnectionFigureProperty(
            @Nullable String sourceTextPath,
            @Nullable Operator sourceOperator,
            @Nullable String targetTextPath,
            @Nullable Operator targetOperator,
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator valueOperator
        )  {
            if (sourceTextPath == null) return null;
            
            if (sourceOperator == null) return null;
            
            if (targetTextPath == null) return null;
            
            if (targetOperator == null) return null;
            
            if (propertyName == null) return null;
            
            if (propertyValue == null) return null;
            
            if (valueOperator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyConnectionProperty")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(sourceTextPath)
                            .addParameter(sourceOperator.rcValue())
                            .addParameter(targetTextPath)
                            .addParameter(targetOperator.rcValue())
                            .addParameter(propertyName)
                            .addParameter(propertyValue)
                            .addParameter(valueOperator.rcValue())
                            .addParameter(0)
                            .build(), null);
        }
        
} 