/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.rcp.swt.aut;

import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.adaptable.AdapterFactoryRegistry;
import org.eclipse.jubula.rc.common.classloader.IUrlLocator;
import org.eclipse.jubula.rc.rcp.common.classloader.EclipseUrlLocator;
import org.eclipse.jubula.rc.rcp.swt.aut.RcpSwtComponentNamer;
import org.eclipse.jubula.rc.swt.SwtAUTServer;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwtRemoteControlService
extends SwtAUTServer {
    private static final Logger LOG = LoggerFactory.getLogger(SwtRemoteControlService.class);
    private static SwtRemoteControlService instance;
    private boolean m_hasRemoteControlServiceStarted = false;

    private SwtRemoteControlService() {
        SwtRemoteControlService.setInstance((AUTServer)this);
    }

    public static AUTServer getInstance() {
        if (instance == null) {
            instance = new SwtRemoteControlService();
        }
        return instance;
    }

    public void checkRemoteControlService(Display display, RcpSwtComponentNamer rcpSwtComonentNamer) {
        if (!this.m_hasRemoteControlServiceStarted && this.startRemoteControlService(display)) {
            SwtRemoteControlService.prepareRemoteControlService(display, rcpSwtComonentNamer);
        }
    }

    private boolean startRemoteControlService(Display display) {
        String autAgentHost = EnvironmentUtils.getProcessOrSystemProperty((String)"com.bredexsw.guidancer.aut.register.autAgentHost");
        if (autAgentHost != null) {
            try {
                this.setAutAgentHost(autAgentHost);
                this.setAutAgentPort(EnvironmentUtils.getProcessOrSystemProperty((String)"com.bredexsw.guidancer.aut.register.autAgentPort"));
                this.setAutID(EnvironmentUtils.getProcessOrSystemProperty((String)"com.bredexsw.guidancer.aut.register.autName"));
                this.setInstallationDir(EnvironmentUtils.getProcessOrSystemProperty((String)"org.eclipse.jubula.STARTED_ROOT_DIRECTORY"));
                this.setDisplay(display);
                this.start(true);
                this.m_hasRemoteControlServiceStarted = true;
            }
            catch (Exception e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
                System.exit(25);
            }
        }
        return this.m_hasRemoteControlServiceStarted;
    }

    private static void prepareRemoteControlService(Display display, RcpSwtComponentNamer rcpSwtComponentNamer) {
        AdapterFactoryRegistry.initRegistration((IUrlLocator)new EclipseUrlLocator());
        AUTServer.getInstance().addToolKitEventListenerToAUT();
        display.addFilter(9, (Listener)rcpSwtComponentNamer);
        display.addFilter(26, (Listener)rcpSwtComponentNamer);
    }
}

