/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.swt.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * Interface representing the {@link org.eclipse.swt.widgets.Tree} component from the swt toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.1
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2019-01-29T10:31:41.643Z")
public interface TreeTable extends org.eclipse.jubula.toolkit.concrete.components.TreeTableComponent {
    
    
        /**
         * 
         * @param checked 
         *        Checked
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfCheckboxOnSelectedNode(@NonNull Boolean checked,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * 
         * @param checked 
         *        Checked
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfCheckboxOnSelectedNode(@NonNull Boolean checked
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP toggleCheckboxOnNodeByTextpath(@NonNull SearchType pathType,@NonNull Integer preAscend,@NonNull String textpath,@NonNull Operator operator
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP toggleCheckboxOnNodeByIndexpath(@NonNull SearchType pathType,@NonNull Integer preAscend,@NonNull String indexpath
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param checked 
         *        Checked
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfCheckboxByTextpath(@NonNull SearchType pathType,@NonNull Integer preAscend,@NonNull String textpath,@NonNull Operator operator,@NonNull Boolean checked,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param checked 
         *        Checked
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfCheckboxByTextpath(@NonNull SearchType pathType,@NonNull Integer preAscend,@NonNull String textpath,@NonNull Operator operator,@NonNull Boolean checked
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param checked 
         *        Checked
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfCheckboxByIndexpath(@NonNull SearchType pathType,@NonNull Integer preAscend,@NonNull String indexpath,@NonNull Boolean checked,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param checked 
         *        Checked
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfCheckboxByIndexpath(@NonNull SearchType pathType,@NonNull Integer preAscend,@NonNull String indexpath,@NonNull Boolean checked
        ) throws IllegalArgumentException;
        
} 