/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jubula.client.core.functions.AbstractFunctionEvaluator;
import org.eclipse.jubula.client.core.functions.FunctionContext;
import org.eclipse.jubula.client.core.functions.FunctionDefinition;
import org.eclipse.jubula.client.core.functions.FunctionRegistry;
import org.eclipse.jubula.client.core.functions.IFunctionEvaluator;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.utils.AbstractParamValueToken;
import org.eclipse.jubula.client.core.utils.ExecObject;
import org.eclipse.jubula.client.core.utils.FunctionArgumentSeparatorToken;
import org.eclipse.jubula.client.core.utils.INestableParamValueToken;
import org.eclipse.jubula.client.core.utils.IParamValueToken;
import org.eclipse.jubula.client.core.utils.ParamValueConverter;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.osgi.util.NLS;

public class FunctionToken
extends AbstractParamValueToken
implements INestableParamValueToken {
    private IParamValueToken[] m_argTokens;
    private String m_prefix;
    private String m_suffix;
    private String m_functionName;

    public FunctionToken(String s, String functionPrefix, String functionSuffix, int pos, IParamDescriptionPO desc, String functionName, IParamValueToken[] argTokens) {
        super(s, pos, desc);
        this.m_argTokens = argTokens;
        this.m_prefix = functionPrefix;
        this.m_suffix = functionSuffix;
        this.m_functionName = functionName;
    }

    @Override
    public ParamValueConverter.ConvValidationState validate() {
        FunctionDefinition function = FunctionRegistry.getInstance().getFunction(this.m_functionName);
        if (function == null) {
            this.setErrorKey(MessageIDs.E_FUNCTION_NOT_REGISTERED);
            return ParamValueConverter.ConvValidationState.invalid;
        }
        int paramCount = function.getParameters().length;
        boolean hasVarArgs = function.getVarArgs() != null;
        int argCount = this.getArgumentCount();
        if (!hasVarArgs && argCount != paramCount || hasVarArgs && argCount < paramCount) {
            this.setErrorKey(MessageIDs.E_WRONG_NUM_FUNCTION_ARGS);
            return ParamValueConverter.ConvValidationState.invalid;
        }
        ParamValueConverter.ConvValidationState state = ParamValueConverter.ConvValidationState.valid;
        Integer errorKey = null;
        IParamValueToken[] iParamValueTokenArray = this.getNestedTokens();
        int n = iParamValueTokenArray.length;
        int n2 = 0;
        while (n2 < n) {
            IParamValueToken childToken = iParamValueTokenArray[n2];
            ParamValueConverter.ConvValidationState childState = childToken.validate();
            if (childState == ParamValueConverter.ConvValidationState.invalid) {
                this.setErrorKey(childToken.getErrorKey());
                return childState;
            }
            if (childState == ParamValueConverter.ConvValidationState.undecided) {
                state = childState;
                errorKey = childToken.getErrorKey();
            }
            ++n2;
        }
        this.setErrorKey(errorKey);
        return state;
    }

    @Override
    public String getExecutionString(List<ExecObject> stack) throws InvalidDataException {
        FunctionDefinition function = FunctionRegistry.getInstance().getFunction(this.m_functionName);
        if (function == null) {
            throw new InvalidDataException(NLS.bind((String)Messages.FunctionNotDefined, (Object)this.m_functionName), MessageIDs.E_NO_FUNCTION);
        }
        IFunctionEvaluator evaluator = function.getEvaluator();
        if (evaluator instanceof AbstractFunctionEvaluator && stack.size() > 0) {
            AbstractFunctionEvaluator aEvaluator = (AbstractFunctionEvaluator)evaluator;
            ExecObject currentExecObject = this.getLastExecTCFromStack(stack);
            INodePO execNode = currentExecObject.getExecNode();
            int innerIndex = currentExecObject.getIndex();
            INodePO actualNode = innerIndex < 0 ? execNode : ((IExecTestCasePO)execNode).getSpecTestCase().getUnmodifiableNodeList().get(innerIndex);
            aEvaluator.setContext(new FunctionContext(actualNode));
        }
        ArrayList<String> argList = new ArrayList<String>();
        StringBuilder argBuilder = new StringBuilder();
        IParamValueToken[] iParamValueTokenArray = this.getNestedTokens();
        int n = iParamValueTokenArray.length;
        int n2 = 0;
        while (n2 < n) {
            IParamValueToken argToken = iParamValueTokenArray[n2];
            if (argToken instanceof FunctionArgumentSeparatorToken) {
                argList.add(argBuilder.toString());
                argBuilder.setLength(0);
            } else {
                argBuilder.append(argToken.getExecutionString(stack));
            }
            ++n2;
        }
        argList.add(argBuilder.toString());
        try {
            return evaluator.evaluate(argList.toArray(new String[argList.size()]));
        }
        catch (Throwable t) {
            if (t instanceof InvalidDataException) {
                throw (InvalidDataException)t;
            }
            throw new InvalidDataException(t.getLocalizedMessage(), MessageIDs.E_FUNCTION_EVAL_ERROR);
        }
    }

    private ExecObject getLastExecTCFromStack(List<ExecObject> stack) {
        ExecObject currentExecObject = null;
        int posInStack = stack.size();
        while (!((currentExecObject = stack.get(--posInStack)).getExecNode() instanceof IExecTestCasePO) && posInStack > 0) {
        }
        return currentExecObject;
    }

    @Override
    public String getGuiString() {
        StringBuilder guiStringBuilder = new StringBuilder();
        guiStringBuilder.append(this.m_prefix);
        IParamValueToken[] iParamValueTokenArray = this.getNestedTokens();
        int n = iParamValueTokenArray.length;
        int n2 = 0;
        while (n2 < n) {
            IParamValueToken nestedToken = iParamValueTokenArray[n2];
            guiStringBuilder.append(nestedToken.getGuiString());
            ++n2;
        }
        guiStringBuilder.append(this.m_suffix);
        return guiStringBuilder.toString();
    }

    @Override
    public String getModelString() {
        StringBuilder modelStringBuilder = new StringBuilder();
        modelStringBuilder.append(this.m_prefix);
        IParamValueToken[] iParamValueTokenArray = this.getNestedTokens();
        int n = iParamValueTokenArray.length;
        int n2 = 0;
        while (n2 < n) {
            IParamValueToken nestedToken = iParamValueTokenArray[n2];
            modelStringBuilder.append(nestedToken.getModelString());
            ++n2;
        }
        modelStringBuilder.append(this.m_suffix);
        return modelStringBuilder.toString();
    }

    @Override
    public IParamValueToken[] getNestedTokens() {
        return this.m_argTokens;
    }

    private int getArgumentCount() {
        if (this.m_argTokens.length == 0) {
            return 0;
        }
        int argCount = 1;
        IParamValueToken[] iParamValueTokenArray = this.m_argTokens;
        int n = this.m_argTokens.length;
        int n2 = 0;
        while (n2 < n) {
            IParamValueToken token = iParamValueTokenArray[n2];
            if (token instanceof FunctionArgumentSeparatorToken) {
                ++argCount;
            }
            ++n2;
        }
        return argCount;
    }

    public String getFunctionName() {
        return this.m_functionName;
    }
}

