/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Interface representing the OperatingSystemComponentActionHandler component from the concrete toolkit.
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2019-05-07T11:32:02.669Z")
public interface OperatingSystemComponentActionHandler {
    
    
        
        /**
         * Run operating system specific executable
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param directory 
         *        the directory in which the command should be executed
         * @param executable 
         *        the command to execute without any command line arguments
         * @param arguments 
         *        a splitChar-delimited list of command-line arguments
         * @param argumentSplitCharacter 
         *        the character used to split the arguments string into individual arguments
         * @param expectedExitCode 
         *        the expected exit code
         * @param encoding 
         *        the encoding used to read output from the process
         * @param useNewEnvironment 
         *        Do not use old / current environment for new sub-process 
         * @since 4.1
         */
        public Result runExecutable(
            @Nullable Integer timeoutInMs,
            @Nullable String directory,
            @Nullable String executable,
            @Nullable String arguments,
            @Nullable String argumentSplitCharacter,
            @Nullable Integer expectedExitCode,
            @Nullable String encoding,
            @Nullable Boolean useNewEnvironment
        ) ;
        /**
         * Run operating system specific executable
         * @param directory 
         *        the directory in which the command should be executed
         * @param executable 
         *        the command to execute without any command line arguments
         * @param arguments 
         *        a splitChar-delimited list of command-line arguments
         * @param argumentSplitCharacter 
         *        the character used to split the arguments string into individual arguments
         * @param expectedExitCode 
         *        the expected exit code
         * @param encoding 
         *        the encoding used to read output from the process
         * @param useNewEnvironment 
         *        Do not use old / current environment for new sub-process 
         * @since 4.1
         */
        public Result runExecutable(
            @Nullable String directory,
            @Nullable String executable,
            @Nullable String arguments,
            @Nullable String argumentSplitCharacter,
            @Nullable Integer expectedExitCode,
            @Nullable String encoding,
            @Nullable Boolean useNewEnvironment
        ) ;
        
} 