/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.propertytester;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICommentPO;
import org.eclipse.jubula.client.core.model.IControllerPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.propertytester.AbstractBooleanPropertyTester;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionClipboardTransfer;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TCEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TJEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TSEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.TestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.editors.TestJobEditor;
import org.eclipse.jubula.client.ui.rcp.editors.TestSuiteEditor;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IEditorPart;

public class AbstractJBCollectionPropertyTester
extends AbstractBooleanPropertyTester {
    public static final String IS_PASTE_ALLOWED = "isPasteAllowed";
    public static final String IS_COPY_ALLOWED = "isCopyAllowed";
    public static final String IS_CUT_ALLOWED = "isCutAllowed";
    public static final String CAN_EXTRACT_OR_SAVE = "canExtractOrSaveAs";
    public static final String CAN_ADD_COND = "canAddCondition";
    private static final String[] PROPERTIES = new String[]{"isPasteAllowed", "isCopyAllowed", "isCutAllowed", "canExtractOrSaveAs", "canAddCondition"};

    public boolean testImpl(Object receiver, String property, Object[] args) {
        Collection selectionContents = (Collection)receiver;
        if (property.equals(IS_PASTE_ALLOWED)) {
            return this.testIsPasteAllowed(selectionContents);
        }
        if (property.equals(IS_COPY_ALLOWED)) {
            return this.testIsCopyCutAllowed(selectionContents, false);
        }
        if (property.equals(IS_CUT_ALLOWED)) {
            return this.testIsCopyCutAllowed(selectionContents, true);
        }
        if (property.equals(CAN_EXTRACT_OR_SAVE)) {
            return this.testCanExtractOrSave(selectionContents);
        }
        if (property.equals(CAN_ADD_COND)) {
            return this.canAddCondition(selectionContents);
        }
        return false;
    }

    private boolean testCanExtractOrSave(Collection<? extends Object> selection) {
        IEditorPart activeEditor = Plugin.getActiveEditor();
        if (!(activeEditor instanceof TestCaseEditor) && !(activeEditor instanceof TestSuiteEditor) || selection == null || selection.isEmpty()) {
            return false;
        }
        for (Object object : selection) {
            if ((object instanceof ICommentPO || object instanceof IControllerPO || object instanceof ICapPO || object instanceof IExecTestCasePO) && !(object instanceof IEventExecTestCasePO)) continue;
            return false;
        }
        return this.nodesAndHaveSameParent(selection);
    }

    private boolean canAddCondition(Collection<? extends Object> selection) {
        IEditorPart activeEditor = Plugin.getActiveEditor();
        if (!(activeEditor instanceof TestCaseEditor) && !(activeEditor instanceof TestSuiteEditor) || selection == null || selection.size() != 1) {
            return false;
        }
        Object sel = selection.iterator().next();
        if (sel instanceof ISpecTestCasePO || sel instanceof ITestSuitePO) {
            return true;
        }
        if (!(sel instanceof INodePO)) {
            return false;
        }
        INodePO par = ((INodePO)sel).getParentNode();
        return par != null && (par instanceof ISpecTestCasePO || par instanceof ITestSuitePO);
    }

    private boolean testIsCopyCutAllowed(Collection<? extends Object> selectionContents, boolean isItCut) {
        IEditorPart activeEditor = Plugin.getActiveEditor();
        if (!(activeEditor instanceof AbstractJBEditor) || selectionContents == null || selectionContents.isEmpty() || activeEditor.isDirty() && !isItCut) {
            return false;
        }
        boolean isEnable = false;
        ArrayList classes = new ArrayList();
        if (activeEditor instanceof TestCaseEditor) {
            classes.add(IExecTestCasePO.class);
            classes.add(ICapPO.class);
            classes.add(IControllerPO.class);
            classes.add(ICommentPO.class);
            isEnable = this.getCopyActionEnablement(selectionContents, classes, isItCut);
            isEnable &= this.nodesAndHaveSameParent(selectionContents);
        } else if (activeEditor instanceof TestSuiteEditor) {
            classes.add(IExecTestCasePO.class);
            classes.add(ICommentPO.class);
            classes.add(IControllerPO.class);
            isEnable = this.getCopyActionEnablement(selectionContents, classes, isItCut);
        } else if (activeEditor instanceof TestJobEditor) {
            classes.add(IRefTestSuitePO.class);
            classes.add(ICommentPO.class);
            isEnable = this.getCopyActionEnablement(selectionContents, classes, isItCut);
        }
        return isEnable;
    }

    private boolean nodesAndHaveSameParent(Collection<? extends Object> selection) {
        INodePO par = null;
        for (Object object : selection) {
            if (!(object instanceof INodePO)) {
                return false;
            }
            if (par != null && par != ((INodePO)object).getParentNode()) {
                return false;
            }
            par = ((INodePO)object).getParentNode();
        }
        return true;
    }

    private boolean testIsPasteAllowed(Collection<? extends Object> selectionContents) {
        LocalSelectionClipboardTransfer transfer = LocalSelectionClipboardTransfer.getInstance();
        IEditorPart activeEditor = Plugin.getActiveEditor();
        if (!(activeEditor instanceof AbstractJBEditor) || selectionContents == null || selectionContents.isEmpty()) {
            return false;
        }
        AbstractJBEditor aJBEditor = (AbstractJBEditor)activeEditor;
        Object toDrop = aJBEditor.getEditorHelper().getClipboard().getContents((Transfer)transfer);
        if (toDrop == null || !(toDrop instanceof IStructuredSelection) || aJBEditor.getSelection() == null || !(aJBEditor.getSelection() instanceof IStructuredSelection) || transfer.getIsItCut() && !aJBEditor.getTreeViewer().equals(transfer.getSource())) {
            return false;
        }
        IStructuredSelection targetSel = (IStructuredSelection)aJBEditor.getSelection();
        boolean isEnable = false;
        if (aJBEditor instanceof TestCaseEditor) {
            isEnable = this.getPasteActionEnablementForTCE((IStructuredSelection)toDrop, targetSel);
        } else if (aJBEditor instanceof TestSuiteEditor) {
            isEnable = this.getPasteActionEnablementForTSE((IStructuredSelection)toDrop, targetSel);
        } else if (aJBEditor instanceof TestJobEditor) {
            isEnable = this.getPasteActionEnablementForTJE((IStructuredSelection)toDrop, targetSel);
        }
        return isEnable;
    }

    private boolean getCopyActionEnablement(Collection<? extends Object> selectionContents, List<Class<?>> checkedClasses, boolean isItCut) {
        for (Object object : selectionContents) {
            if (object == null || object instanceof IEventExecTestCasePO && isItCut) {
                return false;
            }
            boolean contains = false;
            for (Class<?> checkedClass : checkedClasses) {
                if (!checkedClass.isAssignableFrom(object.getClass())) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            return false;
        }
        return true;
    }

    private boolean getPasteActionEnablementForTCE(IStructuredSelection toDrop, IStructuredSelection targetSel) {
        for (Object target : targetSel.toList()) {
            if (target != null && target instanceof INodePO && TCEditorDndSupport.validateCopy(toDrop, (INodePO)target)) continue;
            return false;
        }
        return true;
    }

    private boolean getPasteActionEnablementForTSE(IStructuredSelection toDrop, IStructuredSelection targetSel) {
        for (Object target : targetSel.toList()) {
            if (target != null && target instanceof INodePO && TSEditorDndSupport.validateCopy(toDrop, (INodePO)target)) continue;
            return false;
        }
        return true;
    }

    private boolean getPasteActionEnablementForTJE(IStructuredSelection toDrop, IStructuredSelection targetSel) {
        for (Object target : targetSel.toList()) {
            if (target != null && target instanceof INodePO && TJEditorDndSupport.validateCopy(toDrop, (INodePO)target)) continue;
            return false;
        }
        return true;
    }

    public Class<? extends Object> getType() {
        return Collection.class;
    }

    public String[] getProperties() {
        return PROPERTIES;
    }
}

