/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.poi.POIXMLException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.util.Internal;
import org.apache.poi.xwpf.usermodel.BreakClear;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.VerticalAlign;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.apache.xmlbeans.XmlToken;
import org.apache.xmlbeans.impl.values.XmlAnyTypeImpl;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlip;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGraphicalObjectData;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualPictureProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTransform2D;
import org.openxmlformats.schemas.drawingml.x2006.main.STShapeType;
import org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture;
import org.openxmlformats.schemas.drawingml.x2006.picture.CTPictureNonVisual;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTAnchor;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.CTInline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTEmpty;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPTab;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSignedHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTUnderline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVerticalAlignRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBrClear;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBrType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STUnderline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalAlignRun;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWPFRun {
    private CTR run;
    private String pictureText;
    private XWPFParagraph paragraph;
    private List<XWPFPicture> pictures;

    public XWPFRun(CTR r, XWPFParagraph p) {
        this.run = r;
        this.paragraph = p;
        List drawingList = r.getDrawingList();
        for (CTDrawing ctDrawing : drawingList) {
            List anchorList = ctDrawing.getAnchorList();
            for (CTAnchor anchor : anchorList) {
                if (anchor.getDocPr() == null) continue;
                this.getDocument().getDrawingIdManager().reserve(anchor.getDocPr().getId());
            }
            List inlineList = ctDrawing.getInlineList();
            for (CTInline inline : inlineList) {
                if (inline.getDocPr() == null) continue;
                this.getDocument().getDrawingIdManager().reserve(inline.getDocPr().getId());
            }
        }
        StringBuffer text = new StringBuffer();
        ArrayList pictTextObjs = new ArrayList();
        pictTextObjs.addAll(r.getPictList());
        pictTextObjs.addAll(drawingList);
        for (XmlObject o : pictTextObjs) {
            XmlObject[] t = o.selectPath("declare namespace w='http://schemas.openxmlformats.org/wordprocessingml/2006/main' .//w:t");
            for (int m = 0; m < t.length; ++m) {
                NodeList kids = t[m].getDomNode().getChildNodes();
                for (int n = 0; n < kids.getLength(); ++n) {
                    if (!(kids.item(n) instanceof Text)) continue;
                    if (text.length() > 0) {
                        text.append("\n");
                    }
                    text.append(kids.item(n).getNodeValue());
                }
            }
        }
        this.pictureText = text.toString();
        this.pictures = new ArrayList<XWPFPicture>();
        for (XmlObject o : pictTextObjs) {
            for (CTPicture pict : this.getCTPictures(o)) {
                XWPFPicture picture = new XWPFPicture(pict, this);
                this.pictures.add(picture);
            }
        }
    }

    private List<CTPicture> getCTPictures(XmlObject o) {
        XmlObject[] picts;
        ArrayList<CTPicture> pictures = new ArrayList<CTPicture>();
        for (XmlObject pict : picts = o.selectPath("declare namespace pic='" + CTPicture.type.getName().getNamespaceURI() + "' .//pic:pic")) {
            if (pict instanceof XmlAnyTypeImpl) {
                try {
                    pict = CTPicture.Factory.parse((String)pict.toString());
                }
                catch (XmlException e) {
                    throw new POIXMLException(e);
                }
            }
            if (!(pict instanceof CTPicture)) continue;
            pictures.add((CTPicture)pict);
        }
        return pictures;
    }

    @Internal
    public CTR getCTR() {
        return this.run;
    }

    public XWPFParagraph getParagraph() {
        return this.paragraph;
    }

    public XWPFDocument getDocument() {
        if (this.paragraph != null) {
            return this.paragraph.getDocument();
        }
        return null;
    }

    private boolean isCTOnOff(CTOnOff onoff) {
        if (!onoff.isSetVal()) {
            return true;
        }
        if (onoff.getVal() == STOnOff.ON) {
            return true;
        }
        return onoff.getVal() == STOnOff.TRUE;
    }

    public boolean isBold() {
        CTRPr pr = this.run.getRPr();
        if (pr == null || !pr.isSetB()) {
            return false;
        }
        return this.isCTOnOff(pr.getB());
    }

    public void setBold(boolean value) {
        CTRPr pr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTOnOff bold = pr.isSetB() ? pr.getB() : pr.addNewB();
        bold.setVal(value ? STOnOff.TRUE : STOnOff.FALSE);
    }

    public String getColor() {
        CTRPr pr;
        String color = null;
        if (this.run.isSetRPr() && (pr = this.run.getRPr()).isSetColor()) {
            CTColor clr = pr.getColor();
            color = clr.xgetVal().getStringValue();
        }
        return color;
    }

    public void setColor(String rgbStr) {
        CTRPr pr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTColor color = pr.isSetColor() ? pr.getColor() : pr.addNewColor();
        color.setVal((Object)rgbStr);
    }

    public String getText(int pos) {
        return this.run.sizeOfTArray() == 0 ? null : this.run.getTArray(pos).getStringValue();
    }

    public String getPictureText() {
        return this.pictureText;
    }

    public void setText(String value) {
        this.setText(value, this.run.getTList().size());
    }

    public void setText(String value, int pos) {
        if (pos > this.run.sizeOfTArray()) {
            throw new ArrayIndexOutOfBoundsException("Value too large for the parameter position in XWPFRun.setText(String value,int pos)");
        }
        CTText t = pos < this.run.sizeOfTArray() && pos >= 0 ? this.run.getTArray(pos) : this.run.addNewT();
        t.setStringValue(value);
        XWPFRun.preserveSpaces((XmlString)t);
    }

    public boolean isItalic() {
        CTRPr pr = this.run.getRPr();
        if (pr == null || !pr.isSetI()) {
            return false;
        }
        return this.isCTOnOff(pr.getI());
    }

    public void setItalic(boolean value) {
        CTRPr pr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTOnOff italic = pr.isSetI() ? pr.getI() : pr.addNewI();
        italic.setVal(value ? STOnOff.TRUE : STOnOff.FALSE);
    }

    public UnderlinePatterns getUnderline() {
        CTRPr pr = this.run.getRPr();
        return pr != null && pr.isSetU() ? UnderlinePatterns.valueOf(pr.getU().getVal().intValue()) : UnderlinePatterns.NONE;
    }

    public void setUnderline(UnderlinePatterns value) {
        CTRPr pr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTUnderline underline = pr.getU() == null ? pr.addNewU() : pr.getU();
        underline.setVal(STUnderline.Enum.forInt((int)value.getValue()));
    }

    public boolean isStrike() {
        CTRPr pr = this.run.getRPr();
        if (pr == null || !pr.isSetStrike()) {
            return false;
        }
        return this.isCTOnOff(pr.getStrike());
    }

    public void setStrike(boolean value) {
        CTRPr pr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTOnOff strike = pr.isSetStrike() ? pr.getStrike() : pr.addNewStrike();
        strike.setVal(value ? STOnOff.TRUE : STOnOff.FALSE);
    }

    public VerticalAlign getSubscript() {
        CTRPr pr = this.run.getRPr();
        return pr != null && pr.isSetVertAlign() ? VerticalAlign.valueOf(pr.getVertAlign().getVal().intValue()) : VerticalAlign.BASELINE;
    }

    public void setSubscript(VerticalAlign valign) {
        CTRPr pr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTVerticalAlignRun ctValign = pr.isSetVertAlign() ? pr.getVertAlign() : pr.addNewVertAlign();
        ctValign.setVal(STVerticalAlignRun.Enum.forInt((int)valign.getValue()));
    }

    public String getFontFamily() {
        CTRPr pr = this.run.getRPr();
        return pr != null && pr.isSetRFonts() ? pr.getRFonts().getAscii() : null;
    }

    public void setFontFamily(String fontFamily) {
        CTRPr pr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTFonts fonts = pr.isSetRFonts() ? pr.getRFonts() : pr.addNewRFonts();
        fonts.setAscii(fontFamily);
    }

    public int getFontSize() {
        CTRPr pr = this.run.getRPr();
        return pr != null && pr.isSetSz() ? pr.getSz().getVal().divide(new BigInteger("2")).intValue() : -1;
    }

    public void setFontSize(int size) {
        BigInteger bint = new BigInteger("" + size);
        CTRPr pr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTHpsMeasure ctSize = pr.isSetSz() ? pr.getSz() : pr.addNewSz();
        ctSize.setVal(bint.multiply(new BigInteger("2")));
    }

    public int getTextPosition() {
        CTRPr pr = this.run.getRPr();
        return pr != null && pr.isSetPosition() ? pr.getPosition().getVal().intValue() : -1;
    }

    public void setTextPosition(int val) {
        BigInteger bint = new BigInteger("" + val);
        CTRPr pr = this.run.isSetRPr() ? this.run.getRPr() : this.run.addNewRPr();
        CTSignedHpsMeasure position = pr.isSetPosition() ? pr.getPosition() : pr.addNewPosition();
        position.setVal(bint);
    }

    public void removeBreak() {
    }

    public void addBreak() {
        this.run.addNewBr();
    }

    public void addBreak(BreakType type) {
        CTBr br = this.run.addNewBr();
        br.setType(STBrType.Enum.forInt((int)type.getValue()));
    }

    public void addBreak(BreakClear clear) {
        CTBr br = this.run.addNewBr();
        br.setType(STBrType.Enum.forInt((int)BreakType.TEXT_WRAPPING.getValue()));
        br.setClear(STBrClear.Enum.forInt((int)clear.getValue()));
    }

    public void addCarriageReturn() {
        this.run.addNewCr();
    }

    public void removeCarriageReturn() {
    }

    public XWPFPicture addPicture(InputStream pictureData, int pictureType, String filename, int width, int height) throws InvalidFormatException, IOException {
        XWPFDocument doc = this.paragraph.document;
        String relationId = doc.addPictureData(pictureData, pictureType);
        XWPFPictureData picData = (XWPFPictureData)doc.getRelationById(relationId);
        try {
            CTDrawing drawing = this.run.addNewDrawing();
            CTInline inline = drawing.addNewInline();
            String xml = "<a:graphic xmlns:a=\"" + CTGraphicalObject.type.getName().getNamespaceURI() + "\">" + "<a:graphicData uri=\"" + CTPicture.type.getName().getNamespaceURI() + "\">" + "<pic:pic xmlns:pic=\"" + CTPicture.type.getName().getNamespaceURI() + "\" />" + "</a:graphicData>" + "</a:graphic>";
            inline.set((XmlObject)XmlToken.Factory.parse((String)xml));
            inline.setDistT(0L);
            inline.setDistR(0L);
            inline.setDistB(0L);
            inline.setDistL(0L);
            CTNonVisualDrawingProps docPr = inline.addNewDocPr();
            long id = this.getParagraph().document.getDrawingIdManager().reserveNew();
            docPr.setId(id);
            docPr.setName("Drawing " + id);
            docPr.setDescr(filename);
            CTPositiveSize2D extent = inline.addNewExtent();
            extent.setCx((long)width);
            extent.setCy((long)height);
            CTGraphicalObject graphic = inline.getGraphic();
            CTGraphicalObjectData graphicData = graphic.getGraphicData();
            CTPicture pic = this.getCTPictures((XmlObject)graphicData).get(0);
            CTPictureNonVisual nvPicPr = pic.addNewNvPicPr();
            CTNonVisualDrawingProps cNvPr = nvPicPr.addNewCNvPr();
            cNvPr.setId(0L);
            cNvPr.setName("Picture " + id);
            cNvPr.setDescr(filename);
            CTNonVisualPictureProperties cNvPicPr = nvPicPr.addNewCNvPicPr();
            cNvPicPr.addNewPicLocks().setNoChangeAspect(true);
            CTBlipFillProperties blipFill = pic.addNewBlipFill();
            CTBlip blip = blipFill.addNewBlip();
            blip.setEmbed(picData.getPackageRelationship().getId());
            blipFill.addNewStretch().addNewFillRect();
            CTShapeProperties spPr = pic.addNewSpPr();
            CTTransform2D xfrm = spPr.addNewXfrm();
            CTPoint2D off = xfrm.addNewOff();
            off.setX(0L);
            off.setY(0L);
            CTPositiveSize2D ext = xfrm.addNewExt();
            ext.setCx((long)width);
            ext.setCy((long)height);
            CTPresetGeometry2D prstGeom = spPr.addNewPrstGeom();
            prstGeom.setPrst(STShapeType.RECT);
            prstGeom.addNewAvLst();
            XWPFPicture xwpfPicture = new XWPFPicture(pic, this);
            this.pictures.add(xwpfPicture);
            return xwpfPicture;
        }
        catch (XmlException e) {
            throw new IllegalStateException(e);
        }
    }

    public List<XWPFPicture> getEmbeddedPictures() {
        return this.pictures;
    }

    static void preserveSpaces(XmlString xs) {
        String text = xs.getStringValue();
        if (text != null && (text.startsWith(" ") || text.endsWith(" "))) {
            XmlCursor c = xs.newCursor();
            c.toNextToken();
            c.insertAttributeWithValue(new QName("http://www.w3.org/XML/1998/namespace", "space"), "preserve");
            c.dispose();
        }
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        XmlCursor c = this.run.newCursor();
        c.selectPath("./*");
        while (c.toNextSelection()) {
            String tagName;
            XmlObject o = c.getObject();
            if (o instanceof CTText && !"w:instrText".equals(tagName = o.getDomNode().getNodeName())) {
                text.append(((CTText)o).getStringValue());
            }
            if (o instanceof CTPTab) {
                text.append("\t");
            }
            if (o instanceof CTBr) {
                text.append("\n");
            }
            if (!(o instanceof CTEmpty)) continue;
            tagName = o.getDomNode().getNodeName();
            if ("w:tab".equals(tagName)) {
                text.append("\t");
            }
            if ("w:br".equals(tagName)) {
                text.append("\n");
            }
            if (!"w:cr".equals(tagName)) continue;
            text.append("\n");
        }
        c.dispose();
        if (this.pictureText != null && this.pictureText.length() > 0) {
            text.append("\n").append(this.pictureText);
        }
        return text.toString();
    }
}

