/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jubula.client.ui.rcp.businessprocess.RemoteFileBrowserBP;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.communication.internal.Communicator;

public class RemoteFileStore
extends FileStore {
    private Communicator m_com;
    private String m_path;
    private RemoteFileBrowserBP m_remBrowser;
    private boolean m_isDirectory;
    private boolean m_isContentValid;

    public RemoteFileStore(Communicator com, String path, boolean isDirectory) {
        Assert.isNotNull((Object)com, (String)Messages.NoNullConnectionAllowed);
        this.m_com = com;
        this.m_path = path != null ? path : ".";
        this.m_isDirectory = isDirectory;
        this.m_remBrowser = new RemoteFileBrowserBP(this.m_com);
        this.m_isContentValid = this.m_remBrowser.fetchRemoteDirContent(this.m_path);
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        List<String> remoteDirContent = this.m_remBrowser.getRemoteDirContent();
        String[] res = new String[remoteDirContent.size()];
        int index = 0;
        for (String entry : remoteDirContent) {
            res[index++] = this.normalize(entry.substring(1));
        }
        return res;
    }

    private String normalize(String path) {
        String currentDir = "." + this.m_remBrowser.getSepChar();
        StringBuilder s = new StringBuilder(path);
        while (s.indexOf(currentDir) == 0) {
            s.delete(0, currentDir.length());
        }
        return s.toString();
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) {
        FileInfo result = new FileInfo(this.m_path);
        result.setDirectory(this.m_isDirectory);
        result.setExists(this.m_isContentValid);
        result.setLength(0L);
        return result;
    }

    public IFileStore getChild(String name) {
        boolean isDirectory = false;
        for (String candidate : this.m_remBrowser.getRemoteDirContent()) {
            if (!this.normalize(candidate.substring(1)).equals(name)) continue;
            isDirectory = candidate.charAt(0) == 'D';
            break;
        }
        return new RemoteFileStore(this.m_com, name, isDirectory);
    }

    public String getName() {
        if (!this.m_isContentValid) {
            return this.m_path;
        }
        int sepPos = this.m_path.lastIndexOf(this.m_remBrowser.getSepChar());
        if (sepPos == -1) {
            return this.m_path;
        }
        return this.m_path.substring(sepPos + 1);
    }

    public IFileStore getParent() {
        if (!this.m_remBrowser.isDataValid()) {
            return null;
        }
        int sepPos = this.m_path.lastIndexOf(this.m_remBrowser.getSepChar());
        if (sepPos == -1) {
            return null;
        }
        return new RemoteFileStore(this.m_com, this.m_path.substring(0, sepPos), true);
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) {
        return new ByteArrayInputStream(new byte[0]);
    }

    public URI toURI() {
        try {
            return new URI(this.m_path);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RemoteFileStore)) {
            return false;
        }
        RemoteFileStore fs = (RemoteFileStore)((Object)obj);
        if (this.m_path == fs.m_path) {
            return true;
        }
        return this.normalize(this.m_path).equals(this.normalize(fs.m_path));
    }

    public int hashCode() {
        if (this.m_path == null) {
            return 0;
        }
        return this.normalize(this.m_path).hashCode();
    }

    public List<String> getRootFSs() {
        return this.m_remBrowser.getRemoteFilesystemRoots();
    }

    public Communicator getCommunicator() {
        return this.m_com;
    }

    public boolean isContentValid() {
        return this.m_isContentValid;
    }

    public String getPath() {
        return this.m_path;
    }
}

