/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.base.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the ButtonComponent component from the base toolkit.
 * 
 */
@RealizedType(realizedType="guidancer.abstract.TextVerifiable")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2019-08-13T11:01:45.501Z")
public class ButtonComponent extends org.eclipse.jubula.toolkit.base.internal.impl.TextComponent implements org.eclipse.jubula.toolkit.base.components.ButtonComponent {
            public ButtonComponent(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelection(@NonNull Boolean selected,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifySelected")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(selected)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param selected 
         *        whether the component is expected to be selected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelection(@NonNull Boolean selected
        ) throws IllegalArgumentException {
            Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifySelected")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(selected)
                        .addParameter(0)
                        .build();
        }
        
        /**
         * Gets the selection value from the component
         * @since 5.0
         */
        @NonNull public CAP isSelected(
        )  {
            
            return new CapBuilder("rcIsSelected")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .build();
        }
        
} 