/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.base.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the TextComponent component from the base toolkit.
 * 
 */
@RealizedType(realizedType="guidancer.abstract.Widget")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2019-08-13T11:01:45.500Z")
public class TextComponent extends org.eclipse.jubula.toolkit.base.internal.impl.GraphicsComponent implements org.eclipse.jubula.toolkit.base.components.TextComponent {
            public TextComponent(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkText(@NonNull String text,@NonNull Operator operator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyText")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(text)
                        .addParameter(operator.rcValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkText(@NonNull String text,@NonNull Operator operator
        ) throws IllegalArgumentException {
            Validate.notNull(text, "Argument 'text' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyText")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(text)
                        .addParameter(operator.rcValue())
                        .addParameter(0)
                        .build();
        }
        
        
        /**
         * Use this action to read the value of a component with text so that you can use the value as data for other Test Steps
         * @since 4.0
         */
        @NonNull public CAP readValue(
        )  {
            
            return new CapBuilder("rcReadValue")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .build();
        }
        
} 