/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.base.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the ButtonComponentActionHandler component from the base toolkit.
 * @since 4.0
 */
@RealizedType(realizedType="guidancer.abstract.TextVerifiable")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2019-08-13T11:01:45.501Z")
public class ButtonComponentActionHandler extends org.eclipse.jubula.toolkit.base.internal.impl.handler.TextComponentActionHandler implements org.eclipse.jubula.toolkit.base.components.handler.ButtonComponentActionHandler {
            public ButtonComponentActionHandler(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelection(
            @Nullable Boolean selected,
            @Nullable Integer timeoutInMs
        )  {
            if (selected == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelected")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(selected)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param selected 
         *        whether the component is expected to be selected or not
         * @since 4.1
         */
        public Result checkSelection(
            @Nullable Boolean selected
        )  {
            if (selected == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelected")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(selected)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * Gets the selection value from the component
         * @since 5.0
         */
        public Result isSelected(
        )  {
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcIsSelected")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .build(), null);
        }
        
} 