/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.swt.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the {@link org.eclipse.swt.widgets.Tree} component from the swt toolkit.
 * @since 4.1
 */
@RealizedType(realizedType="guidancer.concrete.TreeTable")
@TesterClass(testerClass="org.eclipse.jubula.rc.swt.tester.TreeTester")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2019-08-27T10:33:21.096Z")
public class TreeTableActionHandler extends org.eclipse.jubula.toolkit.concrete.internal.impl.handler.TreeTableComponentActionHandler implements org.eclipse.jubula.toolkit.swt.components.handler.TreeTableActionHandler {
            public TreeTableActionHandler(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param checked 
         *        Checked
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfCheckboxOnSelectedNode(
            @Nullable Boolean checked,
            @Nullable Integer timeoutInMs
        )  {
            if (checked == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelectedCheckbox")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(checked)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param checked 
         *        Checked
         * @since 4.1
         */
        public Result checkSelectionOfCheckboxOnSelectedNode(
            @Nullable Boolean checked
        )  {
            if (checked == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifySelectedCheckbox")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(checked)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * 
         */
        public Result toggleCheckboxOnNodeByTextpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcToggleCheckbox")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * 
         */
        public Result toggleCheckboxOnNodeByIndexpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (indexpath == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcToggleCheckboxByIndices")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(indexpath)
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param checked 
         *        Checked
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfCheckboxByTextpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean checked,
            @Nullable Integer timeoutInMs
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (checked == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyCheckbox")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(checked)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param checked 
         *        Checked
         * @since 4.1
         */
        public Result checkSelectionOfCheckboxByTextpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean checked
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (textpath == null) return null;
            
            if (operator == null) return null;
            
            if (checked == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyCheckbox")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(textpath)
                            .addParameter(operator.rcValue())
                            .addParameter(checked)
                            .addParameter(0)
                            .build(), null);
        }
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param checked 
         *        Checked
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfCheckboxByIndexpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath,
            @Nullable Boolean checked,
            @Nullable Integer timeoutInMs
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (indexpath == null) return null;
            
            if (checked == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyCheckboxByIndices")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(indexpath)
                            .addParameter(checked)
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param checked 
         *        Checked
         * @since 4.1
         */
        public Result checkSelectionOfCheckboxByIndexpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath,
            @Nullable Boolean checked
        )  {
            if (pathType == null) return null;
            
            if (preAscend == null) return null;
            
            if (indexpath == null) return null;
            
            if (checked == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyCheckboxByIndices")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(pathType.rcValue())
                            .addParameter(preAscend)
                            .addParameter(indexpath)
                            .addParameter(checked)
                            .addParameter(0)
                            .build(), null);
        }
        
} 