/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.util;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeTableOperationContext;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.util.IndexConverter;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.common.util.SelectionUtil;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.rc.swt.tester.util.CAPUtil;
import org.eclipse.jubula.rc.swt.utils.SwtPointUtil;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeTableOperationContext
extends AbstractTreeTableOperationContext<Tree, TreeItem> {
    private static AutServerLogger log = new AutServerLogger(TreeTableOperationContext.class);

    public TreeTableOperationContext(IEventThreadQueuer queuer, IRobot robot, Tree tree, int column) {
        super(queuer, robot, (Object)tree, column);
    }

    public TreeTableOperationContext(IEventThreadQueuer queuer, IRobot robot, Tree tree) {
        super(queuer, robot, (Object)tree, 0);
    }

    public int getNumberOfColumns() {
        return ((Tree)this.getTreeTable()).getColumnCount();
    }

    public void clickNode(final TreeItem node, ClickOptions clickOps) {
        this.scrollNodeToVisible(node);
        org.eclipse.swt.graphics.Rectangle visibleItemBounds = (org.eclipse.swt.graphics.Rectangle)this.getQueuer().invokeAndWait("getVisibleNodeBounds " + node, (IRunnable)new IRunnable<org.eclipse.swt.graphics.Rectangle>(){

            public org.eclipse.swt.graphics.Rectangle run() {
                Rectangle nodeBounds = SwtPointUtil.toAwtRectangle(SwtUtils.getRelativeBounds(node, TreeTableOperationContext.this.getColumn()));
                return SwtPointUtil.toSwtRectangle(TreeTableOperationContext.this.getVisibleRowBounds(nodeBounds));
            }
        });
        this.getRobot().click(this.getTree(), (Object)visibleItemBounds, clickOps.setScrollToVisible(false));
    }

    public String getRenderedTextOfColumn(Object node) {
        if (node instanceof TreeItem) {
            final TreeItem treeItem = (TreeItem)node;
            int userIndex = IndexConverter.toUserIndex((int)this.getColumn());
            return (String)this.getQueuer().invokeAndWait("getNodeText: " + treeItem + " at column: " + userIndex, (IRunnable)new IRunnable<String>(){

                public String run() {
                    return CAPUtil.getWidgetText((Widget)treeItem, "TEST_TESTABLE_TEXT_" + TreeTableOperationContext.this.getColumn(), treeItem.getText(TreeTableOperationContext.this.getColumn()));
                }
            });
        }
        return "";
    }

    public String getRenderedText(TreeItem node) throws StepExecutionException {
        return this.getRenderedTextOfColumn(node);
    }

    public void scrollNodeToVisible(final TreeItem node) {
        this.getQueuer().invokeAndWait("showColumn: " + node, (IRunnable)new IRunnable<Void>(){

            public Void run() {
                ((Tree)TreeTableOperationContext.this.getTree()).showItem(node);
                ((Tree)TreeTableOperationContext.this.getTree()).showColumn(((Tree)TreeTableOperationContext.this.getTree()).getColumn(TreeTableOperationContext.this.getColumn()));
                return null;
            }
        });
        final Rectangle nodeBoundsRelativeToParent = this.getNodeBounds(node);
        final Tree tree = (Tree)this.getTree();
        this.getQueuer().invokeAndWait("getNodeBoundsRelativeToParent", (IRunnable)new IRunnable<Void>(){

            public Void run() {
                Point cellOriginRelativeToParent = tree.getDisplay().map((Control)tree, (Control)tree.getParent(), new Point(nodeBoundsRelativeToParent.x, nodeBoundsRelativeToParent.y));
                nodeBoundsRelativeToParent.x = cellOriginRelativeToParent.x;
                nodeBoundsRelativeToParent.y = cellOriginRelativeToParent.y;
                return null;
            }
        });
        Control parent = (Control)this.getQueuer().invokeAndWait("getParent", (IRunnable)new IRunnable<Control>(){

            public Control run() {
                return tree.getParent();
            }
        });
        this.getRobot().scrollToVisible((Object)parent, (Object)SwtPointUtil.toSwtRectangle(nodeBoundsRelativeToParent));
    }

    public int getColumnFromString(final String col, final String operator, boolean leaf) {
        int column = -2;
        try {
            int usrIdxCol = Integer.parseInt(col);
            if (usrIdxCol == 0) {
                ++usrIdxCol;
            }
            column = IndexConverter.toImplementationIndex((int)usrIdxCol);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Boolean isVisible = (Boolean)this.getQueuer().invokeAndWait("getColumnFromString", (IRunnable)new IRunnable<Boolean>(){

                    public Boolean run() {
                        return ((Tree)TreeTableOperationContext.this.getTree()).getHeaderVisible();
                    }
                });
                if (!isVisible.booleanValue()) {
                    throw new StepExecutionException("No Header", EventFactory.createActionError((String)"TestErrorEvent.NoHeader"));
                }
                Integer implCol = (Integer)this.getQueuer().invokeAndWait("getColumnFromString", (IRunnable)new IRunnable<Integer>(){

                    public Integer run() throws StepExecutionException {
                        int i = 0;
                        while (i < ((Tree)TreeTableOperationContext.this.getTree()).getColumnCount()) {
                            String colHeader = TreeTableOperationContext.this.getColumnHeaderText(i);
                            if (MatchUtil.getInstance().match(colHeader, col, operator)) {
                                return i;
                            }
                            ++i;
                        }
                        return -2;
                    }
                });
                column = implCol;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return column;
    }

    public String getColumnHeaderText(final int colIdx) {
        return (String)this.getQueuer().invokeAndWait("getColumnName", (IRunnable)new IRunnable<String>(){

            public String run() {
                TreeColumn column = ((Tree)TreeTableOperationContext.this.getTree()).getColumn(colIdx);
                return CAPUtil.getWidgetText((Widget)column, column.getText());
            }
        });
    }

    public Rectangle getHeaderBounds(final int col) {
        return (Rectangle)this.getQueuer().invokeAndWait("getHeaderBounds", (IRunnable)new IRunnable<Rectangle>(){

            public Rectangle run() throws StepExecutionException {
                Tree tree = (Tree)TreeTableOperationContext.this.getTree();
                org.eclipse.swt.graphics.Rectangle rect = tree.getItem(0).getBounds(col);
                rect.y = tree.getClientArea().y;
                return new Rectangle(rect.x, rect.y, rect.width, rect.height);
            }
        });
    }

    public Rectangle getNodeBounds(final TreeItem node) {
        org.eclipse.swt.graphics.Rectangle r = (org.eclipse.swt.graphics.Rectangle)this.getQueuer().invokeAndWait("getNodeBounds: " + node, (IRunnable)new IRunnable<org.eclipse.swt.graphics.Rectangle>(){

            public org.eclipse.swt.graphics.Rectangle run() {
                Tree tree = (Tree)TreeTableOperationContext.this.getTree();
                org.eclipse.swt.graphics.Rectangle bounds = SwtUtils.getBounds(node, TreeTableOperationContext.this.getColumn());
                Point relativeLocation = tree.toControl(bounds.x, bounds.y);
                bounds.x = relativeLocation.x;
                bounds.y = relativeLocation.y;
                return bounds;
            }
        });
        Rectangle nodeBounds = new Rectangle(r.x, r.y, r.width, r.height);
        return nodeBounds;
    }

    protected String convertValueToText(TreeItem node, int row) throws StepExecutionException {
        return this.getRenderedText(node);
    }

    public boolean isVisible(final TreeItem node) {
        return (Boolean)this.getQueuer().invokeAndWait("isVisible", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() {
                TreeItem item = node;
                boolean vis = true;
                while (item != null && item.getParentItem() != null) {
                    vis = item.getParentItem().getExpanded();
                    item = item.getParentItem();
                }
                return vis;
            }
        });
    }

    public Rectangle getVisibleRowBounds(Rectangle rowBounds) {
        org.eclipse.swt.graphics.Rectangle r = (org.eclipse.swt.graphics.Rectangle)this.getQueuer().invokeAndWait("getVisibleRowBounds: " + rowBounds, (IRunnable)new IRunnable<org.eclipse.swt.graphics.Rectangle>(){

            public org.eclipse.swt.graphics.Rectangle run() {
                Tree tree = (Tree)TreeTableOperationContext.this.getTree();
                org.eclipse.swt.graphics.Rectangle visibleBounds = tree.getClientArea();
                return visibleBounds;
            }
        });
        Rectangle visibleTreeBounds = new Rectangle(r.x, r.y, r.width, r.height);
        Rectangle visibleRowBounds = visibleTreeBounds.intersection(rowBounds);
        return visibleRowBounds;
    }

    public void collapseNode(final TreeItem node) {
        final Tree tree = (Tree)this.getTree();
        boolean doAction = this.isExpanded(node);
        if (doAction) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Collapsing node: " + node));
            }
            this.getQueuer().invokeAndWait("collapse", (IRunnable)new IRunnable<Void>(){

                public Void run() throws StepExecutionException {
                    Event collapseEvent = new Event();
                    collapseEvent.time = (int)System.currentTimeMillis();
                    collapseEvent.type = 18;
                    collapseEvent.widget = tree;
                    collapseEvent.item = node;
                    tree.notifyListeners(18, collapseEvent);
                    node.setExpanded(false);
                    tree.update();
                    return null;
                }
            });
        }
    }

    public void expandNode(final TreeItem node) {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            final Tree tree = (Tree)this.getTree();
            boolean doAction = !this.isExpanded(node);
            Thread.currentThread().setContextClassLoader(tree.getClass().getClassLoader());
            this.getQueuer().invokeAndWait("Scroll Tree item: " + node + " to visible", (IRunnable)new IRunnable<Void>(){

                public Void run() {
                    tree.showItem(node);
                    return null;
                }
            });
            Rectangle nodeBounds = this.getNodeBounds(node);
            Rectangle visibleNodeBounds = this.getVisibleRowBounds(nodeBounds);
            org.eclipse.swt.graphics.Rectangle swtVisibleNodeBounds = new org.eclipse.swt.graphics.Rectangle(visibleNodeBounds.x, visibleNodeBounds.y, visibleNodeBounds.width, visibleNodeBounds.height);
            this.getRobot().move((Object)tree, (Object)swtVisibleNodeBounds);
            if (doAction) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Expanding node: " + node));
                    log.debug((Object)("Node bounds   : " + visibleNodeBounds));
                }
                this.getQueuer().invokeAndWait("expand", (IRunnable)new IRunnable<Void>(){

                    public Void run() throws StepExecutionException {
                        Event expandEvent = new Event();
                        expandEvent.time = (int)System.currentTimeMillis();
                        expandEvent.type = 17;
                        expandEvent.widget = tree;
                        expandEvent.item = node;
                        tree.notifyListeners(17, expandEvent);
                        node.setExpanded(true);
                        tree.update();
                        return null;
                    }
                });
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public TreeItem[] getRootNodes() {
        return (TreeItem[])this.getQueuer().invokeAndWait("getRootNode", (IRunnable)new IRunnable<TreeItem[]>(){

            public TreeItem[] run() {
                return ((Tree)TreeTableOperationContext.this.getTree()).getItems();
            }
        });
    }

    public boolean isExpanded(final TreeItem node) {
        return (Boolean)this.getQueuer().invokeAndWait("isExpanded: " + node, (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() {
                return node.getExpanded();
            }
        });
    }

    public void toggleNodeCheckbox(final TreeItem node) {
        this.scrollNodeToVisible(node);
        this.getQueuer().invokeAndWait("selectNodeCheckbox", (IRunnable)new IRunnable<Void>(){

            public Void run() {
                Tree tree = (Tree)TreeTableOperationContext.this.getTree();
                boolean toggledValue = !node.getChecked();
                node.setChecked(toggledValue);
                Event toggleEvent = new Event();
                toggleEvent.type = 13;
                toggleEvent.detail = 32;
                toggleEvent.widget = tree;
                toggleEvent.item = node;
                toggleEvent.button = 524288;
                toggleEvent.count = 1;
                toggleEvent.display = node.getDisplay();
                tree.notifyListeners(13, toggleEvent);
                return null;
            }
        });
    }

    public void verifyCheckboxSelection(final TreeItem node, boolean checked) {
        this.scrollNodeToVisible(node);
        Boolean checkSelected = (Boolean)this.getQueuer().invokeAndWait("verifyCheckboxSelection", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() {
                return node.getChecked();
            }
        });
        Verifier.equals((boolean)checked, (boolean)checkSelected);
    }

    public TreeItem getChild(final TreeItem parent, final int index) {
        if (parent == null) {
            TreeItem[] rootNodes = this.getRootNodes();
            if (index < 0 || index >= rootNodes.length) {
                return null;
            }
            return rootNodes[index];
        }
        return (TreeItem)this.getQueuer().invokeAndWait("getChild: " + parent + "; With index: " + index, (IRunnable)new IRunnable<TreeItem>(){

            public TreeItem run() {
                try {
                    return parent.getItem(index);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
            }
        });
    }

    public TreeItem getParent(final TreeItem child) {
        return (TreeItem)this.getQueuer().invokeAndWait("getParent: " + child, (IRunnable)new IRunnable<TreeItem>(){

            public TreeItem run() {
                return child.getParentItem();
            }
        });
    }

    public TreeItem getSelectedNode() {
        return this.getSelectedNodes()[0];
    }

    public TreeItem[] getSelectedNodes() {
        return (TreeItem[])this.getQueuer().invokeAndWait("getSelectedNodes", (IRunnable)new IRunnable<TreeItem[]>(){

            public TreeItem[] run() {
                Object[] selectedItems = ((Tree)TreeTableOperationContext.this.getTree()).getSelection();
                SelectionUtil.validateSelection((Object[])selectedItems);
                return selectedItems;
            }
        });
    }

    public TreeItem[] getChildren(final TreeItem parent) {
        if (parent == null) {
            return this.getRootNodes();
        }
        return (TreeItem[])this.getQueuer().invokeAndWait("getChildren: " + parent, (IRunnable)new IRunnable<TreeItem[]>(){

            public TreeItem[] run() {
                return parent.getItems();
            }
        });
    }

    public int getNumberOfChildren(final TreeItem parent) {
        if (parent == null) {
            return this.getRootNodes().length;
        }
        return (Integer)this.getQueuer().invokeAndWait("getChildren: " + parent, (IRunnable)new IRunnable<Integer>(){

            public Integer run() {
                return parent.getItemCount();
            }
        });
    }

    public Collection<String> getNodeTextList(final TreeItem node) {
        final ArrayList<String> res = new ArrayList<String>();
        this.getQueuer().invokeAndWait("getNodeText: " + node, (IRunnable)new IRunnable<Void>(){

            public Void run() {
                int colCount = ((Tree)TreeTableOperationContext.this.getTree()).getColumnCount();
                int i = 0;
                while (i < colCount) {
                    String textAtColumn = CAPUtil.getWidgetText((Widget)node, "TEST_TESTABLE_TEXT_" + i, node.getText(i));
                    if (textAtColumn != null) {
                        res.add(textAtColumn);
                    }
                    ++i;
                }
                String text = CAPUtil.getWidgetText((Widget)node, node.getText());
                if (text != null) {
                    res.add(text);
                }
                return null;
            }
        });
        return res;
    }

    public int getIndexOfChild(final TreeItem parent, final TreeItem child) {
        if (parent != null) {
            return (Integer)this.getQueuer().invokeAndWait("getIndexOfChild", (IRunnable)new IRunnable<Integer>(){

                public Integer run() throws StepExecutionException {
                    return parent.indexOf(child);
                }
            });
        }
        TreeItem[] rootNodes = this.getRootNodes();
        int i = 0;
        while (i < rootNodes.length) {
            if (rootNodes[i] == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isLeaf(TreeItem node) {
        return this.getNumberOfChildren(node) == 0;
    }
}

