/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the TabComponent component from the concrete toolkit.
 * 
 */
@RealizedType(realizedType="guidancer.abstract.Widget")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2019-09-10T07:28:31.242Z")
public class TabComponent extends org.eclipse.jubula.toolkit.base.internal.impl.GraphicsComponent implements org.eclipse.jubula.toolkit.concrete.components.TabComponent {
            public TabComponent(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfTabByValue(@NonNull String title,@NonNull Operator operator,@NonNull Boolean selected,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifySelectedTab")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(title)
                        .addParameter(operator.rcValue())
                        .addParameter(selected)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfTabByValue(@NonNull String title,@NonNull Operator operator,@NonNull Boolean selected
        ) throws IllegalArgumentException {
            Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifySelectedTab")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(title)
                        .addParameter(operator.rcValue())
                        .addParameter(selected)
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectTabByValue(@NonNull String title,@NonNull Operator operator
        ) throws IllegalArgumentException {
            Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcSelectTab")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(title)
                        .addParameter(operator.rcValue())
                        .build();
        }
        
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEnablementOfTabByValue(@NonNull String title,@NonNull Operator operator,@NonNull Boolean enabled,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(enabled, "Argument 'enabled' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyEnabled")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(title)
                        .addParameter(operator.rcValue())
                        .addParameter(enabled)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEnablementOfTabByValue(@NonNull String title,@NonNull Operator operator,@NonNull Boolean enabled
        ) throws IllegalArgumentException {
            Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(enabled, "Argument 'enabled' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyEnabled")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(title)
                        .addParameter(operator.rcValue())
                        .addParameter(enabled)
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfTabByIndex(@NonNull Integer index,@NonNull Boolean selected,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(index, "Argument 'index' must not be null"); //$NON-NLS-1$
            Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifySelectedTabByIndex")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(index)
                        .addParameter(selected)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param selected 
         *        whether the component is expected to be selected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfTabByIndex(@NonNull Integer index,@NonNull Boolean selected
        ) throws IllegalArgumentException {
            Validate.notNull(index, "Argument 'index' must not be null"); //$NON-NLS-1$
            Validate.notNull(selected, "Argument 'selected' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifySelectedTabByIndex")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(index)
                        .addParameter(selected)
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectTabByIndex(@NonNull Integer index
        ) throws IllegalArgumentException {
            Validate.notNull(index, "Argument 'index' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcSelectTabByIndex")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(index)
                        .build();
        }
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEnablementOfTabByIndex(@NonNull Integer index,@NonNull Boolean enabled,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(index, "Argument 'index' must not be null"); //$NON-NLS-1$
            Validate.notNull(enabled, "Argument 'enabled' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyEnabledByIndex")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(index)
                        .addParameter(enabled)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkEnablementOfTabByIndex(@NonNull Integer index,@NonNull Boolean enabled
        ) throws IllegalArgumentException {
            Validate.notNull(index, "Argument 'index' must not be null"); //$NON-NLS-1$
            Validate.notNull(enabled, "Argument 'enabled' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyEnabledByIndex")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(index)
                        .addParameter(enabled)
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkTextOfTabByIndex(@NonNull Integer index,@NonNull String title,@NonNull Operator operator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(index, "Argument 'index' must not be null"); //$NON-NLS-1$
            Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyTextOfTabByIndex")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(index)
                        .addParameter(title)
                        .addParameter(operator.rcValue())
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param title 
         *        the title 
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkTextOfTabByIndex(@NonNull Integer index,@NonNull String title,@NonNull Operator operator
        ) throws IllegalArgumentException {
            Validate.notNull(index, "Argument 'index' must not be null"); //$NON-NLS-1$
            Validate.notNull(title, "Argument 'title' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyTextOfTabByIndex")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(index)
                        .addParameter(title)
                        .addParameter(operator.rcValue())
                        .addParameter(0)
                        .build();
        }
        
        /**
         * 
         * @param tab 
         *        the tab
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfTab(@NonNull String tab,@NonNull Operator operator,@NonNull Boolean exists,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(tab, "Argument 'tab' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyExistenceOfTab")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(tab)
                        .addParameter(operator.rcValue())
                        .addParameter(exists)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param tab 
         *        the tab
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfTab(@NonNull String tab,@NonNull Operator operator,@NonNull Boolean exists
        ) throws IllegalArgumentException {
            Validate.notNull(tab, "Argument 'tab' must not be null"); //$NON-NLS-1$
            Validate.notNull(operator, "Argument 'operator' must not be null"); //$NON-NLS-1$
            Validate.notNull(exists, "Argument 'exists' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcVerifyExistenceOfTab")
                        .setDefaultMapping(false)
                        .setComponentIdentifier(m_componentIdentifier)
                        .addParameter(tab)
                        .addParameter(operator.rcValue())
                        .addParameter(exists)
                        .addParameter(0)
                        .build();
        }
        
} 