/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * Interface representing the ListComponent component from the concrete toolkit. 
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * 
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2020-01-13T16:08:29.179Z")
public interface ListComponent extends org.eclipse.jubula.toolkit.base.components.TextComponent {
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfEntryByValue(@NonNull String text,@NonNull Operator operator,@NonNull Boolean selected,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfEntryByValue(@NonNull String text,@NonNull Operator operator,@NonNull Boolean selected
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfEntryByValue(@NonNull String text,@NonNull Operator operator,@NonNull Boolean exists,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkExistenceOfEntryByValue(@NonNull String text,@NonNull Operator operator,@NonNull Boolean exists
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param index 
         *        the index
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfEntryByIndex(@NonNull String index,@NonNull Boolean selected,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * 
         * @param index 
         *        the index
         * @param selected 
         *        whether the component is expected to be selected or not
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkSelectionOfEntryByIndex(@NonNull String index,@NonNull Boolean selected
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param index 
         *        the index
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param numberOfClicks 
         *        the amount of interactions
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectEntryByIndexIndices(@NonNull String index,@NonNull BinaryChoice extendSelection,@NonNull InteractionMode mouseButton,@NonNull Integer numberOfClicks
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param searchType 
         *        the search type
         * @param extendSelection 
         *        whether to extend the selection or not
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param numberOfClicks 
         *        the amount of interactions
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP selectEntryByValueS(@NonNull String text,@NonNull Operator operator,@NonNull SearchType searchType,@NonNull BinaryChoice extendSelection,@NonNull InteractionMode mouseButton,@NonNull Integer numberOfClicks
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param searchType 
         *        the search type
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP dragEntryByValue(@NonNull InteractionMode mouseButton,@NonNull Modifier[] modifierKeys,@NonNull String text,@NonNull Operator operator,@NonNull SearchType searchType
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param index 
         *        the index
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP dragEntryByIndex(@NonNull InteractionMode mouseButton,@NonNull Modifier[] modifierKeys,@NonNull Integer index
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param searchType 
         *        the search type
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP dropOnEntryByValue(@NonNull String text,@NonNull Operator operator,@NonNull SearchType searchType,@NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param index 
         *        the index
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * 
         */
        @NonNull public CAP dropOnEntryByIndex(@NonNull Integer index,@NonNull Integer delayBeforeDropMilliseconds
        ) throws IllegalArgumentException;
        
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkPropertyAtMousePosition(@NonNull String propertyName,@NonNull String propertyValue,@NonNull Operator operator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException;
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP checkPropertyAtMousePosition(@NonNull String propertyName,@NonNull String propertyValue,@NonNull Operator operator
        ) throws IllegalArgumentException;
        
} 