/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Interface representing the MenuBarComponentActionHandler component from the concrete toolkit.
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2020-01-13T16:08:29.174Z")
public interface MenuBarComponentActionHandler {
    
    
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * 
         */
        public Result selectMenuEntryByTextpath(
            @Nullable String menupath,
            @Nullable Operator operator
        ) ;
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * 
         */
        public Result selectMenuEntryByIndexpath(
            @Nullable String indexpath
        ) ;
        
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkEnablementOfEntryByTextpath(
            @Nullable String menupath,
            @Nullable Operator operator,
            @Nullable Boolean enabled,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @since 4.1
         */
        public Result checkEnablementOfEntryByTextpath(
            @Nullable String menupath,
            @Nullable Operator operator,
            @Nullable Boolean enabled
        ) ;
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkEnablementOfEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable Boolean enabled,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param enabled 
         *        whether the component is expected to be enabled or not
         * @since 4.1
         */
        public Result checkEnablementOfEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable Boolean enabled
        ) ;
        
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfEntryByTextpath(
            @Nullable String menupath,
            @Nullable Operator operator,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether the component is expected to exist or not
         * @since 4.1
         */
        public Result checkExistenceOfEntryByTextpath(
            @Nullable String menupath,
            @Nullable Operator operator,
            @Nullable Boolean exists
        ) ;
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param exists 
         *        whether the component is expected to exist or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param exists 
         *        whether the component is expected to exist or not
         * @since 4.1
         */
        public Result checkExistenceOfEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable Boolean exists
        ) ;
        
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfEntryByTextpath(
            @Nullable String menupath,
            @Nullable Operator operator,
            @Nullable Boolean selected,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param menupath 
         *        the menupath
         * @param operator 
         *        the operator used for comparison
         * @param selected 
         *        whether the component is expected to be selected or not
         * @since 4.1
         */
        public Result checkSelectionOfEntryByTextpath(
            @Nullable String menupath,
            @Nullable Operator operator,
            @Nullable Boolean selected
        ) ;
        
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable Boolean selected,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param selected 
         *        whether the component is expected to be selected or not
         * @since 4.1
         */
        public Result checkSelectionOfEntryByIndexpath(
            @Nullable String indexpath,
            @Nullable Boolean selected
        ) ;
        
        /**
         * 
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @since 4.1
         */
        public Result waitForComponent(
            @Nullable Integer timeoutInMs,
            @Nullable Integer delayAfterVisibility
        ) ;
        /**
         * 
         * @param delayAfterVisibility 
         *        the static delay after the component became visible
         * @since 4.1
         */
        public Result waitForComponent(
            @Nullable Integer delayAfterVisibility
        ) ;
        
} 