/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.adapter;

import java.awt.Rectangle;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeOperationContext;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeTableOperationContext;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITreeTableComponent;
import org.eclipse.jubula.rc.swt.components.ISWTTableComponent;
import org.eclipse.jubula.rc.swt.components.SWTCell;
import org.eclipse.jubula.rc.swt.tester.adapter.ControlAdapter;
import org.eclipse.jubula.rc.swt.tester.util.CAPUtil;
import org.eclipse.jubula.rc.swt.tester.util.RowManager;
import org.eclipse.jubula.rc.swt.tester.util.TreeOperationContext;
import org.eclipse.jubula.rc.swt.tester.util.TreeTableOperationContext;
import org.eclipse.jubula.rc.swt.utils.SwtPointUtil;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeAdapter
extends ControlAdapter
implements ITreeTableComponent,
ISWTTableComponent {
    private RowManager m_rowManager;

    public TreeAdapter(Object objectToAdapt) {
        super(objectToAdapt);
        this.m_rowManager = new RowManager((Tree)objectToAdapt);
    }

    public AbstractTreeOperationContext getContext() {
        return new TreeOperationContext(this.getEventThreadQueuer(), this.getRobot(), (Tree)this.getRealComponent());
    }

    public AbstractTreeTableOperationContext getContext(int column) {
        return new TreeTableOperationContext(this.getEventThreadQueuer(), this.getRobot(), (Tree)this.getRealComponent(), column);
    }

    public String getPropertyValueOfCell(final String name, final Object cell) {
        return (String)this.getEventThreadQueuer().invokeAndWait("getPropertyValueOfCell", (IRunnable)new IRunnable<String>(){

            public String run() {
                return TreeAdapter.this.getRobot().getPropertyValue(cell, name);
            }
        });
    }

    public Object getRootNode() {
        return this.getEventThreadQueuer().invokeAndWait("getRootNode", (IRunnable)new IRunnable<TreeItem[]>(){

            public TreeItem[] run() {
                return ((Tree)TreeAdapter.this.getRealComponent()).getItems();
            }
        });
    }

    public boolean isRootVisible() {
        return true;
    }

    private Tree getTree() {
        return (Tree)this.getRealComponent();
    }

    public int getColumnCount() {
        return (Integer)this.getEventThreadQueuer().invokeAndWait("getRootNode", (IRunnable)new IRunnable<Integer>(){

            public Integer run() {
                int col = TreeAdapter.this.getTree().getColumnCount();
                return col == 0 ? 1 : col;
            }
        });
    }

    public int getRowCount() {
        return (Integer)this.getEventThreadQueuer().invokeAndWait("getRowCount", (IRunnable)new IRunnable<Integer>(){

            public Integer run() throws StepExecutionException {
                return TreeAdapter.this.m_rowManager.getRowCount();
            }
        });
    }

    public String getCellText(final int row, final int column) {
        return (String)this.getEventThreadQueuer().invokeAndWait("getCellText", (IRunnable)new IRunnable<String>(){

            public String run() throws StepExecutionException {
                TreeItem treeItem = TreeAdapter.this.m_rowManager.getRow(row);
                return CAPUtil.getWidgetText((Widget)treeItem, "TEST_TESTABLE_TEXT_" + column, treeItem.getText(column));
            }
        });
    }

    public String getColumnHeaderText(final int column) {
        return (String)this.getEventThreadQueuer().invokeAndWait("getColumnName", (IRunnable)new IRunnable<String>(){

            public String run() {
                TreeColumn colItem = TreeAdapter.this.getTree().getColumn(column);
                return CAPUtil.getWidgetText((Widget)colItem, colItem.getText());
            }
        });
    }

    public String getRowText(final int rowIdx) {
        return (String)this.getEventThreadQueuer().invokeAndWait("getRowText", (IRunnable)new IRunnable<String>(){

            public String run() {
                TreeItem rowItem = TreeAdapter.this.m_rowManager.getRow(rowIdx);
                if (rowItem == null) {
                    throw new StepExecutionException("Row with index " + rowIdx + " does not exist.", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
                }
                return CAPUtil.getWidgetText((Widget)rowItem, rowItem.getText());
            }
        });
    }

    public Cell getSelectedCell() throws StepExecutionException {
        return (Cell)this.getEventThreadQueuer().invokeAndWait("getSelectedCell", (IRunnable)new IRunnable<Cell>(){

            public Cell run() throws StepExecutionException {
                if (TreeAdapter.this.getTree().getSelection().length == 0) {
                    throw new StepExecutionException("No table cell selected.", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
                }
                TreeItem ti = TreeAdapter.this.getTree().getSelection()[0];
                return new SWTCell(TreeAdapter.this.m_rowManager.getRowIndex(ti), 0, ti);
            }
        });
    }

    public boolean isHeaderVisible() {
        return (Boolean)this.getEventThreadQueuer().invokeAndWait("isHeaderVisible", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() throws StepExecutionException {
                return TreeAdapter.this.getTree().getHeaderVisible();
            }
        });
    }

    public boolean isCellEditable(int row, int col) {
        Control cellEditor = (Control)this.activateEditor(new Cell(row, col));
        return this.invokeIsEditable(cellEditor);
    }

    private boolean invokeIsEditable(final Control cellEditor) {
        return (Boolean)this.getEventThreadQueuer().invokeAndWait("getSelectedCell", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() {
                if (cellEditor == null || cellEditor instanceof TableCursor || cellEditor == TreeAdapter.this.getTree()) {
                    return false;
                }
                if ((cellEditor.getStyle() & 8) == 0) {
                    return true;
                }
                return false;
            }
        });
    }

    public Object activateEditor(Cell cell) {
        this.scrollCellToVisible(cell.getRow(), cell.getCol());
        Rectangle rect = this.getCellBounds(cell.getRow(), cell.getCol(), true);
        Control editor = SwtUtils.getEditor((Widget)this.getTree(), SwtPointUtil.toSwtRectangle(rect), this.getRobot());
        if (!this.invokeIsEditable(editor)) {
            org.eclipse.swt.graphics.Rectangle cellBounds = new org.eclipse.swt.graphics.Rectangle(rect.x, rect.y, rect.width, rect.height);
            ClickOptions co = ClickOptions.create().setClickCount(2).setScrollToVisible(false);
            this.getRobot().click((Object)this.getTree(), (Object)cellBounds, co);
            editor = SwtUtils.getEditor((Widget)this.getTree(), SwtPointUtil.toSwtRectangle(rect), this.getRobot());
        }
        return editor;
    }

    public boolean hasCellSelection() {
        return (Boolean)this.getEventThreadQueuer().invokeAndWait("hasCellSelection", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() {
                if (TreeAdapter.this.getTree().getSelection().length > 0) {
                    return true;
                }
                return false;
            }
        });
    }

    public Rectangle scrollCellToVisible(final int row, final int col) throws StepExecutionException {
        this.getEventThreadQueuer().invokeAndWait("scrollCellToVisible", (IRunnable)new IRunnable<Void>(){

            public Void run() {
                if (TreeAdapter.this.getTree().getColumnCount() > 0 || col > 0) {
                    TreeAdapter.this.getTree().showColumn(TreeAdapter.this.getTree().getColumn(col));
                }
                TreeAdapter.this.getTree().showItem(TreeAdapter.this.m_rowManager.getRow(row));
                return null;
            }
        });
        final org.eclipse.swt.graphics.Rectangle cBoundsRelToParent = SwtPointUtil.toSwtRectangle(this.getCellBounds(row, col, true));
        this.getEventThreadQueuer().invokeAndWait("getCellBoundsRelativeToParent", (IRunnable)new IRunnable<Void>(){

            public Void run() {
                Point cOriginRelToParent = TreeAdapter.this.getTree().getDisplay().map((Control)TreeAdapter.this.getTree(), (Control)TreeAdapter.this.getTree().getParent(), new Point(cBoundsRelToParent.x, cBoundsRelToParent.y));
                cBoundsRelToParent.x = cOriginRelToParent.x;
                cBoundsRelToParent.y = cOriginRelToParent.y;
                return null;
            }
        });
        Control parent = (Control)this.getEventThreadQueuer().invokeAndWait("getParent", (IRunnable)new IRunnable<Control>(){

            public Control run() {
                return TreeAdapter.this.getTree().getParent();
            }
        });
        this.getRobot().scrollToVisible((Object)parent, (Object)cBoundsRelToParent);
        return this.getCellBounds(row, col, true);
    }

    public Rectangle scrollCellToVisibleMy(final int row, final int col) throws StepExecutionException {
        return (Rectangle)this.getEventThreadQueuer().invokeAndWait("scrollCellToVisible", (IRunnable)new IRunnable<Rectangle>(){

            public Rectangle run() {
                TreeItem res = TreeAdapter.this.m_rowManager.getRow(row);
                TreeAdapter.this.getTree().showColumn(TreeAdapter.this.getTree().getColumn(col));
                TreeAdapter.this.getTree().showItem(res);
                org.eclipse.swt.graphics.Rectangle bounds = res.getBounds(col);
                TreeAdapter.this.getRobot().scrollToVisible((Object)TreeAdapter.this.getTree(), (Object)bounds);
                bounds = res.getBounds(col);
                bounds.intersect(TreeAdapter.this.getTree().getClientArea());
                return new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        });
    }

    public Object getTableHeader() {
        return this.getRealComponent();
    }

    public Rectangle getHeaderBounds(final int col) {
        return (Rectangle)this.getEventThreadQueuer().invokeAndWait("getHeaderBounds", (IRunnable)new IRunnable<Rectangle>(){

            public Rectangle run() throws StepExecutionException {
                org.eclipse.swt.graphics.Rectangle rect = TreeAdapter.this.getTree().getItem(0).getBounds(col);
                rect.y = ((TreeAdapter)TreeAdapter.this).getTree().getClientArea().y;
                return new Rectangle(rect.x, rect.y, rect.width, TreeAdapter.this.getTree().getHeaderHeight());
            }
        });
    }

    public String getText() {
        Cell selectedCell = this.getSelectedCell();
        return this.getCellText(selectedCell.getRow(), selectedCell.getCol());
    }

    public boolean doesRowExist(int row) {
        return this.m_rowManager.getRow(row) != null;
    }

    public int getTopIndex() {
        return this.m_rowManager.getRowIndex(this.getTree().getTopItem());
    }

    public int getRowIndex(TreeItem ti) {
        return this.m_rowManager.getRowIndex(ti);
    }

    public boolean isChecked(int row) {
        return this.m_rowManager.getRow(row).getChecked();
    }

    public int getSelectionIndex() {
        return (Integer)this.getEventThreadQueuer().invokeAndWait("getSelectionIndex", (IRunnable)new IRunnable<Integer>(){

            public Integer run() throws StepExecutionException {
                TreeItem[] items = TreeAdapter.this.getTree().getSelection();
                if (items.length == 0) {
                    return -1;
                }
                return TreeAdapter.this.m_rowManager.getRowIndex(items[0]);
            }
        });
    }

    public Rectangle getCellBounds(final int row, final int col, final boolean restr) {
        return (Rectangle)this.getEventThreadQueuer().invokeAndWait("getCellBounds", (IRunnable)new IRunnable<Rectangle>(){

            public Rectangle run() throws StepExecutionException {
                TreeItem ti = TreeAdapter.this.m_rowManager.getRow(row);
                int column = TreeAdapter.this.getTree().getColumnCount() > 0 || col > 0 ? col : 0;
                org.eclipse.swt.graphics.Rectangle r = ti.getBounds(column);
                if (!restr) {
                    return SwtPointUtil.toAwtRectangle(r);
                }
                String text = CAPUtil.getWidgetText((Widget)ti, "TEST_TESTABLE_TEXT_" + column, ti.getText(column));
                Image image = ti.getImage(column);
                if (text != null && text.length() != 0) {
                    GC gc = new GC((Drawable)TreeAdapter.this.getTree());
                    int charWidth = 0;
                    try {
                        FontMetrics fm = gc.getFontMetrics();
                        charWidth = fm.getAverageCharWidth();
                    }
                    finally {
                        gc.dispose();
                    }
                    r.width = text.length() * charWidth;
                    if (image != null) {
                        r.width += image.getBounds().width;
                    }
                } else if (image != null) {
                    r.width = image.getBounds().width;
                }
                if (column > 0) {
                    TreeColumn tc = TreeAdapter.this.getTree().getColumn(column);
                    int alignment = tc.getAlignment();
                    if (alignment == 0x1000000) {
                        r.x = (int)((double)r.x + ((double)tc.getWidth() / 2.0 - (double)r.width / 2.0));
                    }
                    if (alignment == 131072) {
                        r.x += tc.getWidth() - r.width;
                    }
                }
                return new Rectangle(r.x, r.y, r.width, r.height);
            }
        });
    }

    public Item[] getColumnItems() {
        return this.getTree().getColumns();
    }

    public TreeItem getRow(int rowInd) {
        return this.m_rowManager.getRow(rowInd);
    }
}

