/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Interface representing the SliderComponentActionHandler component from the concrete toolkit.
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2020-02-03T06:45:23.527Z")
public interface SliderComponentActionHandler extends org.eclipse.jubula.toolkit.base.components.handler.GraphicsComponentActionHandler {
    
    
        /**
         * 
         * @param position 
         *        the position to use
         * @param operator 
         *        the operator used for comparison
         * @param measure 
         *        the way to measure a unit
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkPosition(
            @Nullable String position,
            @Nullable Operator operator,
            @Nullable Measure measure,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param position 
         *        the position to use
         * @param operator 
         *        the operator used for comparison
         * @param measure 
         *        the way to measure a unit
         * @since 4.1
         */
        public Result checkPosition(
            @Nullable String position,
            @Nullable Operator operator,
            @Nullable Measure measure
        ) ;
        
        /**
         * 
         * @param position 
         *        the position to use
         * @param operator 
         *        the operator used for comparison
         * @param measure 
         *        the way to measure a unit
         * 
         */
        public Result selectPosition(
            @Nullable String position,
            @Nullable Operator operator,
            @Nullable Measure measure
        ) ;
        
} 