/*******************************************************************************
 * Copyright (c) 2014 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.internal.impl;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * Class representing the ReflectionComponent component from the concrete toolkit.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ComponentClassGenerator", 
           date =  "2020-02-03T06:45:23.515Z")
public class ReflectionComponent implements org.eclipse.jubula.toolkit.concrete.components.ReflectionComponent {
            public ReflectionComponent() {
                super();
            }
    
    protected IComponentIdentifier getPseudoComponentIdentifier() {
        return null;
    }
    
        
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP invokeMethodStoreReturnValue(@NonNull String fullyQualifiedClassName,@NonNull String methodName,@Nullable String methodSignature,@Nullable String methodArguments,@Nullable String methodArgumentSeparator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(fullyQualifiedClassName, "Argument 'fullyQualifiedClassName' must not be null"); //$NON-NLS-1$
            Validate.notNull(methodName, "Argument 'methodName' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcInvokeMethodStoreReturnApi")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(fullyQualifiedClassName)
                        .addParameter(methodName)
                        .addOptionalParameter(methodSignature)
                        .addOptionalParameter(methodArguments)
                        .addOptionalParameter(methodArgumentSeparator)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP invokeMethodStoreReturnValue(@NonNull String fullyQualifiedClassName,@NonNull String methodName,@Nullable String methodSignature,@Nullable String methodArguments,@Nullable String methodArgumentSeparator
        ) throws IllegalArgumentException {
            Validate.notNull(fullyQualifiedClassName, "Argument 'fullyQualifiedClassName' must not be null"); //$NON-NLS-1$
            Validate.notNull(methodName, "Argument 'methodName' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcInvokeMethodStoreReturnApi")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(fullyQualifiedClassName)
                        .addParameter(methodName)
                        .addOptionalParameter(methodSignature)
                        .addOptionalParameter(methodArguments)
                        .addOptionalParameter(methodArgumentSeparator)
                        .addParameter(3000)
                        .build();
        }
        
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP invokeMethod(@NonNull String fullyQualifiedClassName,@NonNull String methodName,@Nullable String methodSignature,@Nullable String methodArguments,@Nullable String methodArgumentSeparator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(fullyQualifiedClassName, "Argument 'fullyQualifiedClassName' must not be null"); //$NON-NLS-1$
            Validate.notNull(methodName, "Argument 'methodName' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcInvokeMethod")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(fullyQualifiedClassName)
                        .addParameter(methodName)
                        .addOptionalParameter(methodSignature)
                        .addOptionalParameter(methodArguments)
                        .addOptionalParameter(methodArgumentSeparator)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP invokeMethod(@NonNull String fullyQualifiedClassName,@NonNull String methodName,@Nullable String methodSignature,@Nullable String methodArguments,@Nullable String methodArgumentSeparator
        ) throws IllegalArgumentException {
            Validate.notNull(fullyQualifiedClassName, "Argument 'fullyQualifiedClassName' must not be null"); //$NON-NLS-1$
            Validate.notNull(methodName, "Argument 'methodName' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcInvokeMethod")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(fullyQualifiedClassName)
                        .addParameter(methodName)
                        .addOptionalParameter(methodSignature)
                        .addOptionalParameter(methodArguments)
                        .addOptionalParameter(methodArgumentSeparator)
                        .addParameter(3000)
                        .build();
        }
        
        
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP invokeExternalMethodStoreReturnValue(@NonNull String fullyQualifiedClassName,@NonNull String methodName,@Nullable String methodSignature,@Nullable String methodArguments,@Nullable String methodArgumentSeparator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(fullyQualifiedClassName, "Argument 'fullyQualifiedClassName' must not be null"); //$NON-NLS-1$
            Validate.notNull(methodName, "Argument 'methodName' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcInvokeExternalMethodStoreReturnApi")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(fullyQualifiedClassName)
                        .addParameter(methodName)
                        .addOptionalParameter(methodSignature)
                        .addOptionalParameter(methodArguments)
                        .addOptionalParameter(methodArgumentSeparator)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP invokeExternalMethodStoreReturnValue(@NonNull String fullyQualifiedClassName,@NonNull String methodName,@Nullable String methodSignature,@Nullable String methodArguments,@Nullable String methodArgumentSeparator
        ) throws IllegalArgumentException {
            Validate.notNull(fullyQualifiedClassName, "Argument 'fullyQualifiedClassName' must not be null"); //$NON-NLS-1$
            Validate.notNull(methodName, "Argument 'methodName' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcInvokeExternalMethodStoreReturnApi")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(fullyQualifiedClassName)
                        .addParameter(methodName)
                        .addOptionalParameter(methodSignature)
                        .addOptionalParameter(methodArguments)
                        .addOptionalParameter(methodArgumentSeparator)
                        .addParameter(3000)
                        .build();
        }
        
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP invokeExternalMethod(@NonNull String fullyQualifiedClassName,@NonNull String methodName,@Nullable String methodSignature,@Nullable String methodArguments,@Nullable String methodArgumentSeparator,@NonNull Integer timeoutInMs
        ) throws IllegalArgumentException {
            Validate.notNull(fullyQualifiedClassName, "Argument 'fullyQualifiedClassName' must not be null"); //$NON-NLS-1$
            Validate.notNull(methodName, "Argument 'methodName' must not be null"); //$NON-NLS-1$
            Validate.notNull(timeoutInMs, "Argument 'timeoutInMs' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcInvokeExternalMethod")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(fullyQualifiedClassName)
                        .addParameter(methodName)
                        .addOptionalParameter(methodSignature)
                        .addOptionalParameter(methodArguments)
                        .addOptionalParameter(methodArgumentSeparator)
                        .addParameter(timeoutInMs)
                        .build();
        }
        /**
         * 
         * @param fullyQualifiedClassName 
         *        the fully qualified class name
         * @param methodName 
         *        the name of the Method which will be invoked
         * @param methodSignature 
         *        the Method's signature
         * @param methodArguments 
         *        a space-delimited list of command-line arguments
         * @param methodArgumentSeparator 
         *        the separator for the arguments
         * @throws IllegalArgumentException if one of the passed parameters is <code>null</code>.
         * @since 4.1
         */
        @NonNull public CAP invokeExternalMethod(@NonNull String fullyQualifiedClassName,@NonNull String methodName,@Nullable String methodSignature,@Nullable String methodArguments,@Nullable String methodArgumentSeparator
        ) throws IllegalArgumentException {
            Validate.notNull(fullyQualifiedClassName, "Argument 'fullyQualifiedClassName' must not be null"); //$NON-NLS-1$
            Validate.notNull(methodName, "Argument 'methodName' must not be null"); //$NON-NLS-1$
            
            return new CapBuilder("rcInvokeExternalMethod")
                        .setDefaultMapping(true)
                        .setComponentIdentifier(getPseudoComponentIdentifier())
                        .addParameter(fullyQualifiedClassName)
                        .addParameter(methodName)
                        .addOptionalParameter(methodSignature)
                        .addOptionalParameter(methodArguments)
                        .addOptionalParameter(methodArgumentSeparator)
                        .addParameter(3000)
                        .build();
        }
        
} 