/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.provider.contentprovider;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.model.TestResult;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestResultTreeViewContentProvider
implements ITreeContentProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TestResultTreeViewContentProvider.class);

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TestResultNode) {
            TestResultNode result = (TestResultNode)parentElement;
            return result.getResultNodeList().toArray();
        }
        if (parentElement instanceof TestResult) {
            return new Object[]{((TestResult)parentElement).getRootResultNode()};
        }
        if (parentElement instanceof TestResultNode[]) {
            TestResultNode[] inputArray = (TestResultNode[])parentElement;
            Object[] elements = new Object[inputArray.length];
            System.arraycopy(inputArray, 0, elements, 0, inputArray.length);
            return elements;
        }
        LOG.warn(Messages.ParentElementHasInvalidTypeReturningEmptyArray);
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof TestResultNode) {
            return ((TestResultNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof TestResult) {
            return new Object[]{((TestResult)inputElement).getRootResultNode()};
        }
        if (inputElement instanceof TestResultNode[]) {
            TestResultNode[] inputArray = (TestResultNode[])inputElement;
            Object[] elements = new Object[inputArray.length];
            System.arraycopy(inputArray, 0, elements, 0, inputArray.length);
            return elements;
        }
        LOG.warn(Messages.InputElementHasInvalidTypeReturningEmptyArray);
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

