/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.base.internal.impl.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.StringUtils;

import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.tools.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.constants.TestDataConstants;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.toolkit.internal.annotations.RealizedType;
import org.eclipse.jubula.toolkit.internal.annotations.TesterClass;

/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Class representing the TextComponentActionHandler component from the base toolkit.
 * @since 4.0
 */
@RealizedType(realizedType="guidancer.abstract.Widget")
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2020-02-21T08:47:13.338Z")
public class TextComponentActionHandler extends org.eclipse.jubula.toolkit.base.internal.impl.handler.GraphicsComponentActionHandler implements org.eclipse.jubula.toolkit.base.components.handler.TextComponentActionHandler {
            public TextComponentActionHandler(@NonNull ComponentIdentifier componentIdentifier) {
                super(componentIdentifier);
            }
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkText(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs
        )  {
            if (text == null) return null;
            
            if (operator == null) return null;
            
            if (timeoutInMs == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyText")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(timeoutInMs)
                            .build(), null);
        }
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @since 4.1
         */
        public Result checkText(
            @Nullable String text,
            @Nullable Operator operator
        )  {
            if (text == null) return null;
            
            if (operator == null) return null;
            
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcVerifyText")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .addParameter(text)
                            .addParameter(operator.rcValue())
                            .addParameter(0)
                            .build(), null);
        }
        
        
        /**
         * Use this action to read the value of a component with text so that you can use the value as data for other Test Steps
         * @since 4.0
         */
        public Result readValue(
        )  {
            return AUTRegistry.INSTANCE.get().execute(
                new CapBuilder("rcReadValue")
                            .setDefaultMapping(false)
                            .setComponentIdentifier(m_componentIdentifier)
                            .build(), null);
        }
        
} 