/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Interface representing the ComboComponentActionHandler component from the concrete toolkit.
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2020-02-21T08:47:13.229Z")
public interface ComboComponentActionHandler extends org.eclipse.jubula.toolkit.base.components.handler.TextInputComponentActionHandler {
    
    
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfEntryByValue(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @since 4.1
         */
        public Result checkExistenceOfEntryByValue(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable Boolean exists
        ) ;
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param selected 
         *        whether the component is expected to be selected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkSelectionOfEntryByIndex(
            @Nullable String index,
            @Nullable Boolean selected,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param index 
         *        the 1-based index
         * @param selected 
         *        whether the component is expected to be selected or not
         * @since 4.1
         */
        public Result checkSelectionOfEntryByIndex(
            @Nullable String index,
            @Nullable Boolean selected
        ) ;
        
        /**
         * 
         * @param index 
         *        the 1-based index
         * 
         */
        public Result selectEntryByIndex(
            @Nullable String index
        ) ;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param searchType 
         *        the search type
         * 
         */
        public Result selectEntryByValue(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable SearchType searchType
        ) ;
        
} 