/*******************************************************************************
 * Copyright (c) 2016 BREDEX GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BREDEX GmbH - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.jubula.toolkit.concrete.components.handler;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.AUTRegistry;
import org.eclipse.jubula.client.Result;
import org.eclipse.jubula.communication.CAP;
import org.eclipse.jubula.toolkit.CapBuilder;
import org.eclipse.jubula.toolkit.annotations.Beta;
import org.eclipse.jubula.toolkit.enums.ValueSets.*;
import javax.annotation.Generated;


/**
 * An ActionHandler directly executes the remote controlling commands for a
 * registered AUT - see {@link org.eclipse.jubula.client.AUTRegistry}
 *
 * Interface representing the TreeComponentActionHandler component from the concrete toolkit.
 * @noextend This interface is not intended to be extended by clients.
 * @noimplement This interface is not intended to be implemented by clients.
 * @since 4.0
 */
@Generated(value = "org.eclipse.jubula.toolkit.api.gen.ActionHandlerGenerator", 
           date =  "2020-02-21T08:47:13.265Z")
public interface TreeComponentActionHandler extends org.eclipse.jubula.toolkit.base.components.handler.GraphicsComponentActionHandler {
    
    
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * 
         */
        public Result collapseNodeByTextpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator
        ) ;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * 
         */
        public Result collapseNodeByIndexpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath
        ) ;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * 
         */
        public Result expandNodeByTextpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator
        ) ;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * 
         */
        public Result expandNodeByIndexpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath
        ) ;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param extendSelection 
         *        whether to extend the selection or not
         * 
         */
        public Result selectNodeByTextpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Integer numberOfClicks,
            @Nullable InteractionMode mouseButton,
            @Nullable BinaryChoice extendSelection
        ) ;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param numberOfClicks 
         *        the amount of interactions
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param extendSelection 
         *        whether to extend the selection or not
         * 
         */
        public Result selectNodeByIndexpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath,
            @Nullable Integer numberOfClicks,
            @Nullable InteractionMode mouseButton,
            @Nullable BinaryChoice extendSelection
        ) ;
        
        /**
         * 
         * @param direction 
         *        the direction to navigate
         * @param numberOfNodes 
         *        the amount of nodes
         * @param numberOfClicks 
         *        the amount of interactions
         * 
         */
        public Result move(
            @Nullable TreeDirection direction,
            @Nullable Integer numberOfNodes,
            @Nullable Integer numberOfClicks
        ) ;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfNodeByTextpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param textpath 
         *        the textpath to use
         * @param operator 
         *        the operator used for comparison
         * @param exists 
         *        whether existence is expected or not
         * @since 4.1
         */
        public Result checkExistenceOfNodeByTextpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String textpath,
            @Nullable Operator operator,
            @Nullable Boolean exists
        ) ;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param exists 
         *        whether existence is expected or not
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkExistenceOfNodeByIndexpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath,
            @Nullable Boolean exists,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param indexpath 
         *        the 1-based indexpath e.g. "1/2/1"
         * @param exists 
         *        whether existence is expected or not
         * @since 4.1
         */
        public Result checkExistenceOfNodeByIndexpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String indexpath,
            @Nullable Boolean exists
        ) ;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkTextOfSelectedNodeS(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @since 4.1
         */
        public Result checkTextOfSelectedNodeS(
            @Nullable String text,
            @Nullable Operator operator
        ) ;
        
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkTextMousePosition(
            @Nullable String text,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param text 
         *        the text to use
         * @param operator 
         *        the operator used for comparison
         * @since 4.1
         */
        public Result checkTextMousePosition(
            @Nullable String text,
            @Nullable Operator operator
        ) ;
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param treeTextpath 
         *        the tree textpath
         * @param operator 
         *        the operator used for comparison
         * 
         */
        public Result dragNodeByTextpath(
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String treeTextpath,
            @Nullable Operator operator
        ) ;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param treeTextpath 
         *        the tree textpath
         * @param operator 
         *        the operator used for comparison
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public Result dropOnNodeByTextpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String treeTextpath,
            @Nullable Operator operator,
            @Nullable Integer delayBeforeDropMilliseconds
        ) ;
        
        /**
         * 
         * @param mouseButton 
         *        the interaction type e.g. on desktop systems the mouse button
         * @param modifierKeys 
         *        the modifier keys
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param treeIndexpath 
         *        the 1-based tree indexpath
         * 
         */
        public Result dragNodeByIndexpath(
            @Nullable InteractionMode mouseButton,
            @Nullable Modifier[] modifierKeys,
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String treeIndexpath
        ) ;
        
        /**
         * 
         * @param pathType 
         *        whether the given path is a relative or absolute path
         * @param preAscend 
         *        the amount of implicit pre-ascends; similiar to the amount of ".." in path navigations
         * @param treeIndexpath 
         *        the 1-based tree indexpath
         * @param delayBeforeDropMilliseconds 
         *        the static delay before performing the drop (milliseconds)
         * 
         */
        public Result dropOnNodeByIndexpath(
            @Nullable SearchType pathType,
            @Nullable Integer preAscend,
            @Nullable String treeIndexpath,
            @Nullable Integer delayBeforeDropMilliseconds
        ) ;
        
        
        
        
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * @param timeoutInMs 
         *        the dynamic timeout in ms
         * @since 4.1
         */
        public Result checkPropertyAtMousePosition(
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator operator,
            @Nullable Integer timeoutInMs
        ) ;
        /**
         * 
         * @param propertyName 
         *        the name of the property
         * @param propertyValue 
         *        the value of the property
         * @param operator 
         *        the operator used for comparison
         * @since 4.1
         */
        public Result checkPropertyAtMousePosition(
            @Nullable String propertyName,
            @Nullable String propertyValue,
            @Nullable Operator operator
        ) ;
        
} 