/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.editors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.businessprocess.db.TestCaseBP;
import org.eclipse.jubula.client.core.commands.CAPRecordedCommand;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.events.IRecordListener;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IEventHandlerContainer;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.ObjectMappingManager;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMObjectDeletedException;
import org.eclipse.jubula.client.core.persistence.locking.LockManager;
import org.eclipse.jubula.client.core.utils.StringHelper;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.provider.DecoratingCellLabelProvider;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.actions.ActivateEditorForSpecTCAction;
import org.eclipse.jubula.client.ui.rcp.businessprocess.UINodeBP;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.controllers.TestExecutionContributor;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.EventHandlerDropTargetListener;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TCEditorDropTargetListener;
import org.eclipse.jubula.client.ui.rcp.dialogs.AddEventHandlerDialog;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.EventHandlerContentProvider;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.TooltipLabelProvider;
import org.eclipse.jubula.client.ui.rcp.provider.selectionprovider.SelectionProviderIntermediate;
import org.eclipse.jubula.client.ui.rcp.utils.UIIdentitiyElementComparer;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.i18n.I18n;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class TestCaseEditor
extends AbstractTestCaseEditor
implements IRecordListener,
IDoubleClickListener {
    private static final int[] SASH_WEIGHT = new int[]{75, 25};
    private ObjectMappingManager m_objectMappingManager = new ObjectMappingManager();
    private TreeViewer m_eventHandlerTreeViewer;
    private TreeViewer m_currentTreeViewer;
    private SelectionProviderIntermediate m_selectionProviderDelegate;

    @Override
    public void createPartControlImpl(Composite parent) {
        super.createPartControlImpl(parent);
        this.getMainTreeViewer().addDoubleClickListener((IDoubleClickListener)this);
        this.m_eventHandlerTreeViewer.setContentProvider((IContentProvider)new EventHandlerContentProvider());
        this.m_eventHandlerTreeViewer.getControl().setMenu(this.createContextMenu());
        this.addDoubleClickListener("org.eclipse.jubula.client.ui.commands.OpenSpecification", (StructuredViewer)this.m_eventHandlerTreeViewer);
        if (!Plugin.getDefault().anyDirtyStar()) {
            this.checkAndRemoveUnusedTestData();
        }
        this.m_currentTreeViewer = this.getMainTreeViewer();
        this.m_selectionProviderDelegate = new SelectionProviderIntermediate();
        this.m_selectionProviderDelegate.setSelectionProviderDelegate((ISelectionProvider)this.m_currentTreeViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.m_selectionProviderDelegate);
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        int returnCode;
        IPersistentObject inputTC = this.getEditorHelper().getEditSupport().getWorkVersion();
        ISpecTestCasePO recordTC = CAPRecordedCommand.getRecSpecTestCase();
        boolean isStillObserving = CAPRecordedCommand.isObserving();
        if (isStillObserving && inputTC.equals(recordTC) && (returnCode = this.showSaveInObservModeDialog()) == 0) {
            TestExecutionContributor.getInstance().getClientTest().resetToTesting();
            DataEventDispatcher.getInstance().fireRecordModeStateChanged(DataEventDispatcher.RecordModeState.notRunning);
            isStillObserving = false;
        }
        if (!isStillObserving) {
            try {
                this.m_objectMappingManager.saveMappings();
                this.refreshOMProfilesForAUTS();
                this.removeIncorrectCompNamePairsInExecTcs();
                super.doSave(monitor);
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
            }
            catch (ProjectDeletedException projectDeletedException) {
                PMExceptionHandler.handleProjectDeletedException();
            }
        }
    }

    private void removeIncorrectCompNamePairsInExecTcs() {
        INodePO workVersion = (INodePO)this.getEditorHelper().getEditSupport().getWorkVersion();
        ArrayList<Long> parentProjectIds = new ArrayList<Long>();
        parentProjectIds.add(workVersion.getParentProjectId());
        EntityManager editorSession = this.getEditorHelper().getEditSupport().getSession();
        List execTcRefs = NodePM.getExecTestCases((String)workVersion.getGuid(), parentProjectIds, (EntityManager)editorSession);
        if (execTcRefs == null) {
            return;
        }
        HashSet<INodePO> lockedNodePOs = new HashSet<INodePO>();
        for (IExecTestCasePO execTc : execTcRefs) {
            try {
                INodePO parentNode = execTc.getSpecAncestor();
                if (parentNode != null) {
                    INodePO editorSessionParentNode = (INodePO)editorSession.find(parentNode.getClass(), (Object)parentNode.getId());
                    if (!LockManager.instance().lockPO(editorSession, (IPersistentObject)editorSessionParentNode, true)) continue;
                    lockedNodePOs.add(editorSessionParentNode);
                    continue;
                }
                LOG.info("The parent of ExecTestCase (GUID " + execTc.getGuid() + ") is null. Skipped removal of incorrect compNamePairs.");
            }
            catch (PMDirtyVersionException pMDirtyVersionException) {
            }
            catch (PMObjectDeletedException pMObjectDeletedException) {}
        }
        for (INodePO node : lockedNodePOs) {
            CompNamesBP.removeIncorrectCompNamePairs((IWritableComponentNameCache)this.getCompNameCache(), (INodePO)node);
        }
    }

    private void refreshOMProfilesForAUTS() {
        EntityManager sess = GeneralStorage.getInstance().getMasterSession();
        for (IAUTMainPO aut : GeneralStorage.getInstance().getProject().getAutMainList()) {
            sess.refresh((Object)aut.getObjMap().getProfile());
        }
    }

    @Override
    public String getEditorPrefix() {
        return Messages.PluginTC;
    }

    public void capRecorded(final ICapPO newCap, final IComponentIdentifier ci, final boolean hasDefaultMapping) {
        if (newCap == null) {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_TEST_STEP_NOT_CREATED);
        } else {
            final IAUTMainPO recordAut = TestExecution.getInstance().getConnectedAut();
            Plugin.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (TestCaseEditor.this.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
                        return;
                    }
                    if (!hasDefaultMapping) {
                        String capComponentName = TestCaseEditor.this.m_objectMappingManager.addMapping(recordAut, ci, newCap.getComponentName());
                        newCap.setComponentName(capComponentName);
                    }
                    TestCaseEditor.this.getTreeViewer().refresh(false);
                    TestCaseEditor.this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)newCap), true);
                    TestCaseEditor.this.getEditorHelper().setDirty(true);
                }
            });
        }
    }

    @Override
    public Image getDisabledTitleImage() {
        return IconConstants.DISABLED_TC_EDITOR_IMAGE;
    }

    @Override
    public void reOpenEditor(IPersistentObject node) throws PMException {
        this.m_objectMappingManager.clear();
        super.reOpenEditor(node);
        if (node instanceof ISpecTestCasePO) {
            CAPRecordedCommand.setRecSpecTestCase((ISpecTestCasePO)((ISpecTestCasePO)node));
        }
    }

    @Override
    protected void setHelp(Composite parent) {
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.guidancerSpecTestCaseEditorContextId");
    }

    private int showSaveInObservModeDialog() {
        MessageDialog dialog = new MessageDialog(Plugin.getActiveWorkbenchWindowShell(), Messages.SaveInObservationModeDialogTitle, null, Messages.SaveInObservationModeDialogQuestion, 3, new String[]{Messages.DialogMessageButton_YES, Messages.DialogMessageButton_NO}, 0);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        dialog.open();
        return dialog.getReturnCode();
    }

    @Override
    public ISelection getSelection() {
        if (this.m_currentTreeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.m_currentTreeViewer.getSelection();
    }

    private void createEventHandlerPart(Composite parent) {
        Composite headLineComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        headLineComposite.setLayout((Layout)layout);
        Label headLine = new Label(headLineComposite, 0);
        headLine.setText(Messages.TestCaseEditorEHAreaHeadline);
        ControlDecorator.createInfo((Control)headLine, I18n.getString((String)"ControlDecorator.EventHandler"), false);
        GridData ehTvGridData = new GridData();
        ehTvGridData.grabExcessHorizontalSpace = true;
        ehTvGridData.grabExcessVerticalSpace = true;
        ehTvGridData.horizontalAlignment = 4;
        ehTvGridData.verticalAlignment = 4;
        ehTvGridData.verticalSpan = 100;
        GridLayout ehTvLayout = new GridLayout(1, true);
        ehTvLayout.marginWidth = 0;
        ehTvLayout.marginHeight = 0;
        ehTvLayout.marginBottom = 0;
        ehTvLayout.marginTop = 0;
        this.m_eventHandlerTreeViewer = new TreeViewer(headLineComposite);
        this.m_eventHandlerTreeViewer.getTree().setLayout((Layout)ehTvLayout);
        this.m_eventHandlerTreeViewer.getTree().setLayoutData((Object)ehTvGridData);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.m_eventHandlerTreeViewer);
        DecoratingCellLabelProvider lp = new DecoratingCellLabelProvider((ILabelProvider)new TooltipLabelProvider(), Plugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator());
        this.m_eventHandlerTreeViewer.setLabelProvider((IBaseLabelProvider)lp);
        this.m_eventHandlerTreeViewer.setComparer((IElementComparer)new UIIdentitiyElementComparer());
        this.m_eventHandlerTreeViewer.setUseHashlookup(true);
        this.firePropertyChange(258);
    }

    @Override
    protected void addInternalSelectionListeners(ISelectionChangedListener editorSelectionChangedListener) {
        super.addInternalSelectionListeners(editorSelectionChangedListener);
        this.m_eventHandlerTreeViewer.addSelectionChangedListener(editorSelectionChangedListener);
    }

    @Override
    protected void addDragAndDropSupport(int operations, Transfer[] transfers) {
        super.addDragAndDropSupport(operations, transfers);
        this.m_eventHandlerTreeViewer.addDropSupport(operations, transfers, (DropTargetListener)new EventHandlerDropTargetListener(this));
    }

    public TreeViewer getEventHandlerTreeViewer() {
        return this.m_eventHandlerTreeViewer;
    }

    public void addEventHandler(ISpecTestCasePO eventHandlerInput, ISpecTestCasePO evHandlerOwner) {
        EditSupport editSupport = this.getEditorHelper().getEditSupport();
        ISpecTestCasePO workSpecTcPO = (ISpecTestCasePO)editSupport.getWorkVersion();
        ISpecTestCasePO eventHandlerInputPO = eventHandlerInput;
        IEventExecTestCasePO eventHandlerPO = null;
        try {
            ISpecTestCasePO eventHandlerWorkV = (ISpecTestCasePO)editSupport.createWorkVersion((IPersistentObject)eventHandlerInputPO);
            eventHandlerPO = NodeMaker.createEventExecTestCasePO((ISpecTestCasePO)eventHandlerWorkV, (INodePO)workSpecTcPO);
            int status = this.openAddEventHandlerDlg((IEventHandlerContainer)evHandlerOwner, eventHandlerPO);
            if (status == 0) {
                editSupport.lockWorkVersion();
                TestCaseBP.addEventHandler((EditSupport)editSupport, (ISpecTestCasePO)workSpecTcPO, (IEventExecTestCasePO)eventHandlerPO);
                this.getEditorHelper().setDirty(true);
                DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)eventHandlerPO, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.onlyInEditor);
            }
        }
        catch (InvalidDataException invalidDataException) {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_DOUBLE_EVENT, null, (String[])new String[]{NLS.bind((String)Messages.TestCaseEditorDoubleEventTypeErrorDetail, (Object[])new Object[]{evHandlerOwner.getName(), I18n.getString((String)eventHandlerPO.getEventType())})});
        }
        catch (PMException e) {
            PMExceptionHandler.handlePMExceptionForMasterSession(e);
        }
    }

    private int openAddEventHandlerDlg(IEventHandlerContainer eventHandlerCont, final IEventExecTestCasePO eventHandler) {
        AddEventHandlerDialog dialog = new AddEventHandlerDialog(Plugin.getActiveWorkbenchWindowShell(), eventHandler.getSpecTestCase().getName(), eventHandlerCont);
        dialog.addListener(new AddEventHandlerDialog.Listener(){

            @Override
            public void notifySelected(String refName, String eventType, String reentryType, Integer maxRetries) {
                String evType = (String)StringHelper.getInstance().getMap().get(eventType);
                TestCaseEditor.this.setEventHandlerProperties(eventHandler, refName, evType, reentryType, maxRetries);
            }
        });
        int status = dialog.open();
        dialog.close();
        return status;
    }

    @Override
    public void handlePropertyChanged(boolean isCompNameChanged) {
        super.handlePropertyChanged(isCompNameChanged);
        Plugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                TestCaseEditor.this.getEventHandlerTreeViewer().refresh();
            }
        });
    }

    @Override
    protected SashForm createSashForm(Composite parent) {
        SashForm form = super.createSashForm(parent);
        this.createEventHandlerPart((Composite)form);
        form.setWeights(SASH_WEIGHT);
        return form;
    }

    @Override
    public void setInitialInput() {
        super.setInitialInput();
        this.m_eventHandlerTreeViewer.setContentProvider((IContentProvider)new EventHandlerContentProvider());
        ISpecTestCasePO workVersion = this.getWorkVersion();
        this.m_eventHandlerTreeViewer.setInput((Object)workVersion);
        this.m_eventHandlerTreeViewer.expandAll();
        this.m_eventHandlerTreeViewer.getTree().addFocusListener((FocusListener)new TreeFocusListener());
    }

    @Override
    protected void initTopTreeViewer(INodePO root) {
        super.initTopTreeViewer(root);
        this.getMainTreeViewer().getTree().addFocusListener((FocusListener)new TreeFocusListener());
    }

    @Override
    public void refresh() {
        super.refresh();
        Plugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                TestCaseEditor.this.getEventHandlerTreeViewer().refresh();
            }
        });
    }

    @Override
    protected DropTargetListener getViewerDropAdapter() {
        return new TCEditorDropTargetListener(this);
    }

    protected ISpecTestCasePO getWorkVersion() {
        return (ISpecTestCasePO)super.getWorkVersion();
    }

    @Override
    public void setSelectionImpl(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection ss = (StructuredSelection)selection;
            Object firstElement = ss.getFirstElement();
            if (firstElement instanceof IEventExecTestCasePO) {
                UINodeBP.setFocusAndSelection((ISelection)ss, this.getEventHandlerTreeViewer());
            } else {
                super.setSelectionImpl(selection);
            }
        }
    }

    @Override
    public void setFocus() {
        this.m_currentTreeViewer.getTree().setFocus();
        Plugin.showStatusLine((IWorkbenchPart)this);
    }

    public void doubleClick(DoubleClickEvent event) {
        Object selObj;
        if (event.getSelection() instanceof IStructuredSelection && (selObj = ((IStructuredSelection)event.getSelection()).getFirstElement()) != null && selObj.equals(this.getWorkVersion())) {
            ActivateEditorForSpecTCAction.activateEditor(this.getWorkVersion());
        }
        CommandHelper.executeCommand((String)"org.eclipse.jubula.client.ui.commands.OpenSpecification", (IWorkbenchPartSite)this.getSite());
    }

    @Override
    public Image getIcon() {
        return IconConstants.TC_EDITOR_IMAGE;
    }

    private class TreeFocusListener
    extends FocusAdapter {
        private TreeFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            Tree tree = (Tree)e.getSource();
            if (TestCaseEditor.this.getMainTreeViewer().getTree() == tree) {
                TestCaseEditor.this.m_currentTreeViewer = TestCaseEditor.this.getMainTreeViewer();
            } else if (TestCaseEditor.this.getEventHandlerTreeViewer().getTree() == tree) {
                TestCaseEditor.this.m_currentTreeViewer = TestCaseEditor.this.getEventHandlerTreeViewer();
            }
            if (TestCaseEditor.this.m_selectionProviderDelegate != null) {
                TestCaseEditor.this.m_selectionProviderDelegate.setSelectionProviderDelegate((ISelectionProvider)TestCaseEditor.this.m_currentTreeViewer);
            }
        }
    }
}

